<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Mvc\Model;

class Tabval extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=4, nullable=false)
   */
  public $cdvalu;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dsvalu;

  /**
   *
   * @var string
   * @Column(type="string", length=20, nullable=false)
   */
  public $sgvalu;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $decpre;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $decimp;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('tabval');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdvalu' => isset($rec->cdvalu) && (string)$rec->cdvalu !== '' ? (string) $rec->cdvalu : new RawValue('""'),
      'dsvalu' => isset($rec->dsvalu) && (string)$rec->dsvalu !== '' ? (string) $rec->dsvalu : new RawValue('""'),
      'sgvalu' => isset($rec->sgvalu) && (string)$rec->sgvalu !== '' ? (string) $rec->sgvalu : new RawValue('""'),
      'decpre' => isset($rec->decpre) && (string)$rec->decpre !== '' ? (string) $rec->decpre : 0,
      'decimp' => isset($rec->decimp) && (string)$rec->decimp !== '' ? (string) $rec->decimp : 0
    );

    $query  = 'cdvalu = :cdvalu:';
    $params = array(
      'cdvalu' => $values['cdvalu']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion
}
