<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Tabstg extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=4, nullable=false)
   */
  public $cdstag;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dsstag;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $collez;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('tabstg');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdstag' => isset($rec->cdstag) && (string)$rec->cdstag !== '' ? (string)$rec->cdstag : new RawValue('""'),
      'dsstag' => isset($rec->dsstag) && (string)$rec->dsstag !== '' ? (string)$rec->dsstag : new RawValue('""'),
      'collez' => isset($rec->collez) && (string)$rec->collez !== '' ? (string)$rec->collez : 0
    );

    $query  = 'cdstag = :cdstag:';
    $params = array(
      'cdstag' => $values['cdstag']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Tabstg objects
   */
  public static function getAllSeasons($orderByCollez = false) {
    $orderBy = "ORDER BY " . ($orderByCollez ? "ts.collez" : "ts.cdstag");
    $query = "SELECT ts.cdstag, ts.dsstag,
      ts.cdstag AS code, ts.dsstag AS description
      FROM Go2B\Models\Tabstg ts
      $orderBy";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }
  //endregion
}
