<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Svtipo extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=4, nullable=false)
   */
  public $cdstag;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=18, nullable=false)
   */
  public $codneu;

  /**
   *
   * @var string
   * @Column(type="string", length=40, nullable=false)
   */
  public $desneu;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $titlin;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $lineam;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $seriem;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $tipmod;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $tipsta;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $genere;

  /**
   *
   * @var string
   * @Column(type="string", length=4, nullable=false)
   */
  public $unimis;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $ragcon;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('svtipo');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdstag' => isset($rec->cdstag) && (string)$rec->cdstag !== '' ? (string)$rec->cdstag : new RawValue('""'),
      'codneu' => isset($rec->codneu) && (string)$rec->codneu !== '' ? (string)$rec->codneu : new RawValue('""'),
      'desneu' => isset($rec->desneu) && (string)$rec->desneu !== '' ? (string)$rec->desneu : new RawValue('""'),
      'titlin' => isset($rec->titlin) && (string)$rec->titlin !== '' ? (string)$rec->titlin : new RawValue('""'),
      'lineam' => isset($rec->lineam) && (string)$rec->lineam !== '' ? (string)$rec->lineam : new RawValue('""'),
      'seriem' => isset($rec->seriem) && (string)$rec->seriem !== '' ? (string)$rec->seriem : new RawValue('""'),
      'tipmod' => isset($rec->tipmod) && (string)$rec->tipmod !== '' ? (string)$rec->tipmod : new RawValue('""'),
      'tipsta' => isset($rec->tipsta) && (string)$rec->tipsta !== '' ? (string)$rec->tipsta : new RawValue('""'),
      'genere' => isset($rec->genere) && (string)$rec->genere !== '' ? (string)$rec->genere : new RawValue('""'),
      'unimis' => isset($rec->unimis) && (string)$rec->unimis !== '' ? (string)$rec->unimis : new RawValue('""'),
      'ragcon' => isset($rec->ragcon) && (string)$rec->ragcon !== '' ? (string)$rec->ragcon : new RawValue('""')
    );

    $query  = 'cdstag = :cdstag: AND codneu = :codneu:';
    $params = array(
      'cdstag' => $values['cdstag'],
      'codneu' => $values['codneu']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }

  /**
   * Delete all stats for season
   */
  public static function deleteSeason($seasons) {
    $cdstag = explode('#', $seasons);
    $svtipo = self::find(array(
      'conditions' => "cdstag IN ({cdstag:array})",
      'bind' => array('cdstag'=> $cdstag)
    ));
    $svtipo->delete();
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Svtipo objects
   */
  public static function getStatsLines() {
    $query = 'SELECT DISTINCT s.lineam
      FROM Go2B\Models\Svtipo s
      ORDER BY s.lineam';
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Svtipo objects
   */
  public static function getStatsSeries() {
    $query = 'SELECT DISTINCT s.seriem
      FROM Go2B\Models\Svtipo s
      ORDER BY s.seriem';
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Svtipo objects
   */
  public static function getStatsModelTypes() {
    $query = 'SELECT DISTINCT s.tipmod
      FROM Go2B\Models\Svtipo s
      ORDER BY s.tipmod';
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Svtipo objects
   */
  public static function getStatsGenres() {
    $query = 'SELECT DISTINCT s.genere
      FROM Go2B\Models\Svtipo s
      ORDER BY s.genere';
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function emptyTable() {
    $query = "TRUNCATE svtipo";
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
