<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Svcorp extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=11, nullable=false)
   */
  public $idcorp;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $idtest;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $prorig;

  /**
   *
   * @var string
   * @Column(type="string", length=20, nullable=false)
   */
  public $codart;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $qtatot;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $implor;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $impnet;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $prelis;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $precos;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $datcon;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('svcorp');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'idcorp' => isset($rec->idcorp) && (string)$rec->idcorp !== '' ? (string)$rec->idcorp : self::getNextIdcorp(),
      'idtest' => isset($rec->idtest) && (string)$rec->idtest !== '' ? (string)$rec->idtest : 0,
      'prorig' => isset($rec->prorig) && (string)$rec->prorig !== '' ? (string)$rec->prorig : 0,
      'codart' => isset($rec->codart) && (string)$rec->codart !== '' ? (string)$rec->codart : new RawValue('""'),
      'qtatot' => isset($rec->qtatot) && (string)$rec->qtatot !== '' ? (string)$rec->qtatot : 0,
      'implor' => isset($rec->implor) && (string)$rec->implor !== '' ? (string)$rec->implor : 0,
      'impnet' => isset($rec->impnet) && (string)$rec->impnet !== '' ? (string)$rec->impnet : 0,
      'prelis' => isset($rec->prelis) && (string)$rec->prelis !== '' ? (string)$rec->prelis : 0,
      'precos' => isset($rec->precos) && (string)$rec->precos !== '' ? (string)$rec->precos : 0,
      'datcon' => isset($rec->datcon) && (string)$rec->datcon !== '' ? (string)$rec->datcon : '0000-00-00'
    );

    $query  = 'idcorp = :idcorp:';
    $params = array(
      'idcorp' => $values['idcorp']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Svcorp objects
   */
  public static function getTop10QuantityBestellers($cdstag, $id_usr, $where, $params) {
    $params['cdstag'] = $cdstag;
    $params['id_usr'] = $id_usr;
    $query = "SELECT a.codneu, s.desneu, SUM(c.qtatot) AS tot_qty, COALESCE(m.flimag,'') AS flimag
      FROM Go2B\Models\Svcorp c
      INNER JOIN Go2B\Models\Svtest t ON c.idtest = t.idtest
      INNER JOIN Go2B\Models\Svarti a ON a.cdstag = t.cdstag AND a.codart = c.codart
      INNER JOIN Go2B\Models\Svtipo s ON s.cdstag = a.cdstag AND s.codneu = a.codneu
      LEFT JOIN Go2B\Models\Tipolo m ON m.cdartn = a.codneu
      INNER JOIN Go2B\Models\B2bUsrage u ON u.cdagen = t.cdagen
      WHERE t.cdstag = :cdstag: AND u.id_usr = :id_usr: $where
      GROUP BY a.codneu
      ORDER BY tot_qty DESC
      LIMIT 10";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Svcorp objects
   */
  public static function getTop10ValueBestellers($cdstag, $id_usr, $where, $params) {
    $params['cdstag'] = $cdstag;
    $params['id_usr'] = $id_usr;
    $query = "SELECT a.codneu, s.desneu, SUM(c.impnet) AS tot_val, COALESCE(m.flimag,'') AS flimag
      FROM Go2B\Models\Svcorp c
      INNER JOIN Go2B\Models\Svtest t ON c.idtest = t.idtest
      INNER JOIN Go2B\Models\Svarti a ON a.cdstag = t.cdstag AND a.codart = c.codart
      INNER JOIN Go2B\Models\Svtipo s ON s.cdstag = a.cdstag AND s.codneu = a.codneu
      LEFT JOIN Go2B\Models\Tipolo m ON m.cdartn = a.codneu
      INNER JOIN Go2B\Models\B2bUsrage u ON u.cdagen = t.cdagen
      WHERE t.cdstag = :cdstag: AND u.id_usr = :id_usr: $where
      GROUP BY a.codneu
      ORDER BY tot_val DESC
      LIMIT 10";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Svcorp object
   */
  public static function getRowTotals($cdstag, $id_usr, $where, $params) {
    $params['cdstag'] = $cdstag;
    $params['id_usr'] = $id_usr;
    $query = "SELECT SUM(c.qtatot) AS tot_qty, SUM(c.impnet) AS tot_val
      FROM Go2B\Models\Svcorp c
      INNER JOIN Go2B\Models\Svtest t ON t.idtest = c.idtest
      INNER JOIN Go2B\Models\B2bUsrage u ON u.cdagen = t.cdagen
      WHERE t.cdstag = :cdstag: AND u.id_usr = :id_usr: $where";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params)[0];
  }

  /**
   * Query:   SELECT
   * Return:  int
   */
  public static function getNextIdcorp() {
    $query = "SELECT COALESCE(MAX(c.idcorp),0) + 1 AS nextId
      FROM Go2B\Models\Svcorp c";
    return Di::getDefault()->get('modelsManager')->executeQuery($query)[0]->nextId;
  }

  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function emptyTable() {
    $query = "TRUNCATE svcorp";
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
