<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Svanag extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=4, nullable=false)
   */
  public $cdstag;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=2, nullable=false)
   */
  public $tipana;

  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=11, nullable=false)
   */
  public $codana;

  /**
   *
   * @var string
   * @Column(type="string", length=40, nullable=false)
   */
  public $ragsoc;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $ccitta;

  /**
   *
   * @var string
   * @Column(type="string", length=20, nullable=false)
   */
  public $nazion;

  /**
   *
   * @var string
   * @Column(type="string", length=20, nullable=false)
   */
  public $zonage;

  /**
   *
   * @var string
   * @Column(type="string", length=20, nullable=false)
   */
  public $catego;

  /**
   *
   * @var string
   * @Column(type="string", length=10, nullable=false)
   */
  public $sganag;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('svanag');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdstag' => isset($rec->cdstag) && (string)$rec->cdstag !== '' ? (string)$rec->cdstag : new RawValue('""'),
      'tipana' => isset($rec->tipana) && (string)$rec->tipana !== '' ? (string)$rec->tipana : new RawValue('""'),
      'codana' => isset($rec->codana) && (string)$rec->codana !== '' ? (string)$rec->codana : 0,
      'ragsoc' => isset($rec->ragsoc) && (string)$rec->ragsoc !== '' ? (string)$rec->ragsoc : new RawValue('""'),
      'ccitta' => isset($rec->ccitta) && (string)$rec->ccitta !== '' ? (string)$rec->ccitta : new RawValue('""'),
      'nazion' => isset($rec->nazion) && (string)$rec->nazion !== '' ? (string)$rec->nazion : new RawValue('""'),
      'zonage' => isset($rec->zonage) && (string)$rec->zonage !== '' ? (string)$rec->zonage : new RawValue('""'),
      'catego' => isset($rec->catego) && (string)$rec->catego !== '' ? (string)$rec->catego : new RawValue('""'),
      'sganag' => isset($rec->sganag) && (string)$rec->sganag !== '' ? (string)$rec->sganag : new RawValue('""')
    );

    $query  = 'cdstag = :cdstag: AND tipana = :tipana: AND codana = :codana:';
    $params = array(
      'cdstag' => $values['cdstag'],
      'tipana' => $values['tipana'],
      'codana' => $values['codana']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }

  /**
   * Delete all stats for season
   */
  public static function deleteSeason($seasons) {
    $cdstag = explode('#', $seasons);
    $svanag = self::find(array(
      'conditions' => "cdstag IN ({cdstag:array})",
      'bind' => array('cdstag'=> $cdstag)
    ));
    $svanag->delete();
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Svanag objects
   */
  public static function getTop10QuantityCustomers($cdstag, $id_usr, $where, $params) {
    $params['cdstag'] = $cdstag;
    $params['id_usr'] = $id_usr;
    $query = "SELECT a.codana, a.ragsoc, SUM(c.qtatot) AS tot_qty
      FROM Go2B\Models\Svanag a
      INNER JOIN Go2B\Models\Svtest t ON a.cdstag = t.cdstag AND a.tipana = t.tipana AND a.codana = t.codana
      INNER JOIN Go2B\Models\Svcorp c ON c.idtest = t.idtest
      INNER JOIN Go2B\Models\B2bUsrage u ON u.cdagen = t.cdagen
      WHERE t.cdstag = :cdstag: AND u.id_usr = :id_usr: $where
      GROUP BY a.codana
      ORDER BY tot_qty DESC
      LIMIT 10";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Svanag objects
   */
  public static function getTop10ValueCustomers($cdstag, $id_usr, $where, $params) {
    $params['cdstag'] = $cdstag;
    $params['id_usr'] = $id_usr;
    $query = "SELECT a.codana, a.ragsoc, SUM(c.impnet) AS tot_val
      FROM Go2B\Models\Svanag a
      INNER JOIN Go2B\Models\Svtest t ON a.cdstag = t.cdstag AND a.tipana = t.tipana AND a.codana = t.codana
      INNER JOIN Go2B\Models\Svcorp c ON c.idtest = t.idtest
      INNER JOIN Go2B\Models\B2bUsrage u ON u.cdagen = t.cdagen
      WHERE t.cdstag = :cdstag: AND u.id_usr = :id_usr: $where
      GROUP BY a.codana
      ORDER BY tot_val DESC
      LIMIT 10";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Svanag objects
   */
  public static function getCustomerStatsFromUser($id_usr) {
    $query = 'SELECT DISTINCT s.tipana, s.codana, s.ragsoc
      FROM Go2B\Models\Svanag s
      INNER JOIN Go2B\Models\Anagra a ON s.tipana = a.tpanag AND s.codana = a.cdanag
      INNER JOIN Go2B\Models\B2bUsrage u ON u.cdagen = a.cdagen
      WHERE u.id_usr = :id_usr:
      ORDER BY s.ragsoc';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('id_usr' => $id_usr));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Svanag objects
   */
  public static function getStatsCountries($where, $params) {
    $query = "SELECT DISTINCT s.nazion
      FROM Go2B\Models\Svanag s
      WHERE $where
      ORDER BY s.nazion";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Svanag objects
   */
  public static function getStatsZones($where, $params) {
    $query = "SELECT DISTINCT s.zonage
      FROM Go2B\Models\Svanag s
      WHERE $where
      ORDER BY s.zonage";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function emptyTable() {
    $query = "TRUNCATE svanag";
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
