<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Spmate extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdartn;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $tpcomp;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdmate;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $flcamp;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $riflis;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $varpre;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $inplib;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('spmate');
  }

  /**
   * Allows to query the first record that match the key
   *
   * @param mixed $parameters
   * @return Spmate
   */
  public static function findFirstByKey($cdartn, $tpcomp, $cdmate) {
    $params = array('cdartn' => $cdartn, 'tpcomp' => $tpcomp, 'cdmate' => $cdmate);
    return parent::findFirst(array('cdartn = :cdartn: AND tpcomp = :tpcomp: AND cdmate = :cdmate:', 'bind' => $params));
  }

  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdartn' => isset($rec->cdartn) && (string)$rec->cdartn !== '' ? (string)$rec->cdartn : new RawValue('""'),
      'tpcomp' => isset($rec->tpcomp) && (string)$rec->tpcomp !== '' ? (string)$rec->tpcomp : new RawValue('""'),
      'cdmate' => isset($rec->cdmate) && (string)$rec->cdmate !== '' ? (string)$rec->cdmate : new RawValue('""'),
      'flcamp' => isset($rec->flcamp) && (string)$rec->flcamp !== '' ? (string)$rec->flcamp : 0,
      'riflis' => isset($rec->riflis) && (string)$rec->riflis !== '' ? (string)$rec->riflis : 0,
      'varpre' => isset($rec->varpre) && (string)$rec->varpre !== '' ? (string)$rec->varpre : 0,
      'inplib' => isset($rec->inplib) && (string)$rec->inplib !== '' ? (string)$rec->inplib : 0
    );

    $query  = 'cdartn = :cdartn: AND tpcomp = :tpcomp: AND cdmate = :cdmate:';
    $params = array(
      'cdartn' => $values['cdartn'],
      'tpcomp' => $values['tpcomp'],
      'cdmate' => $values['cdmate']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Spmate objects
   */
  public static function getMaterialTypes($cdartn) {
    $params = array('cdartn' => $cdartn);
    $andWhere = '';
    $query = 'SELECT DISTINCT sm.tpcomp, tc.dscomp, sm.inplib, tm.cdmatn,
      tm.dsmatn, sm.cdmate, am.dsmate, COALESCE(am.cdcolo, "") AS cdcolo,
      am.flimag, tm.cdmacr, sm.flcamp, sm.riflis, sm.varpre, sm.inplib
      FROM Go2B\Models\Spmate sm
      INNER JOIN Go2B\Models\Tpcomp tc ON sm.tpcomp = tc.tpcomp
      INNER JOIN Go2B\Models\Anamat am ON sm.cdmate = am.cdmate
      INNER JOIN Go2B\Models\Tipmat tm ON am.cdmatn = tm.cdmatn
      WHERE sm.cdartn = :cdartn: AND tm.flbloc = 0 AND am.flbloc = 0
      ORDER BY sm.tpcomp, tm.dsmatn, am.cdmate';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Spmate objects
   */
  public static function getDefaultMaterialTypes($cdartn) {
    $query = 'SELECT DISTINCT sm.tpcomp, tc.dscomp, sm.inplib, tm.cdmatn,
      tm.dsmatn, sm.cdmate, am.dsmate, COALESCE(am.cdcolo, "") AS cdcolo,
      am.flimag, tm.cdmacr, sm.flcamp, sm.riflis, sm.varpre, sm.inplib
      FROM Go2B\Models\Spmate sm
      INNER JOIN Go2B\Models\Tpcomp tc ON sm.tpcomp = tc.tpcomp
      INNER JOIN Go2B\Models\Anamat am ON sm.cdmate = am.cdmate
      INNER JOIN Go2B\Models\Tipmat tm ON am.cdmatn = tm.cdmatn
      WHERE sm.cdartn = :cdartn: AND tm.flbloc = 0 AND am.flbloc = 0 AND sm.flcamp = 1
      ORDER BY sm.tpcomp, tm.dsmatn, am.cdmate';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdartn' => $cdartn));
  }

  /**
   * Query:   SELECT
   * Return:  double
   */
  public static function getListPriceForComponent($nulist, $cdartn, $tpcomp, $cdmate = '') {
    $params = array('nulist' => $nulist, 'cdartn' => $cdartn, 'tpcomp' => $tpcomp);
    $andWhere = '';
    if (!empty($cdmate)) {
      $andWhere = 'AND sm.cdmate = :cdmate:';
      $params['cdmate'] = $cdmate;
    }
    $query = 'SELECT COALESCE(lc.prezzo, 0) AS prezzo
      FROM Go2B\Models\Spmate sm
      INNER JOIN Go2B\Models\Anamat am ON sm.cdmate = am.cdmate
      INNER JOIN Go2B\Models\Tipmat tm ON tm.cdmatn = am.cdmatn
      LEFT JOIN Go2B\Models\Lsvcat lc ON tm.catpre = lc.catpre AND sm.cdartn = lc.cdartn
      WHERE lc.nulist = :nulist: AND sm.cdartn = :cdartn: AND sm.tpcomp = :tpcomp: ' .
      $andWhere;
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    return count($result) > 0 ? $result[0]->prezzo : 0;
  }

  /**
   * Query:   SELECT
   * Return:  double
   */
  public static function getAddPriceForComponent($nulist, $cdmate, $tpcomp, $cdartn, $isFreeInput = false) {
    $params = array('nulist' => $nulist, 'cdmate' => $cdmate, 'tpcomp' => $tpcomp, 'cdartn' => $cdartn);
    $andWhere = '';
    if ($isFreeInput) {
      $andWhere = 'AND sm.cdmate = :cdmate';
    }
    $query = "SELECT COALESCE(IF(sm.varpre = 1, (SELECT lc.prezzo FROM lscorp lc WHERE lc.nulist = :nulist AND lc.cdarti = :cdmate), 0), 0) AS prezzo
      FROM spmate sm
      WHERE sm.cdartn = :cdartn AND sm.tpcomp = :tpcomp $andWhere
      LIMIT 1";
    $result = Di::getDefault()->get('db')->query($query, $params)->fetchAll();
    return count($result) > 0 ? $result[0]['prezzo'] : 0;
  }

  /**
   * Query:   SELECT
   * Return:  double
   */
  public static function getPriceToSubtractForModel($nulist, $cdartn) {
    $params = array('nulist' => $nulist, 'cdartn' => $cdartn);
    $query = "SELECT COALESCE(lc.prezzo, 0) AS prezzo
      FROM spmate sm
      INNER JOIN lscorp lc ON lc.cdarti = sm.cdmate
      WHERE sm.cdartn = :cdartn AND lc.nulist = :nulist AND sm.flcamp = 1 AND sm.varpre = 1
      LIMIT 1";
    $result = Di::getDefault()->get('db')->query($query, $params)->fetchAll();
    return count($result) > 0 ? $result[0]['prezzo'] : 0;
  }

  /**
   * Query:   SELECT
   * Return:  bool
   */
  public static function hasComponents($cdartn) {
    $query = 'SELECT COUNT(sm.tpcomp) AS components
      FROM Go2B\Models\Spmate sm
      INNER JOIN Go2B\Models\Tpcomp tc ON sm.tpcomp = tc.tpcomp
      INNER JOIN Go2B\Models\Anamat am ON sm.cdmate = am.cdmate
      INNER JOIN Go2B\Models\Tipmat tm ON am.cdmatn = tm.cdmatn
      WHERE sm.cdartn = :cdartn: AND tm.flbloc = 0 AND am.flbloc = 0 ';
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdartn' => $cdartn));
    return count($result) > 0 ? $result[0]->components > 0 : false;
  }

  /**
   * Query:   SELECT
   * Return:  bool
   */
  public static function hasGetAllMaterialsFlag($cdartn, $tpcomp) {
    $query = 'SELECT sm.inplib
      FROM Go2B\Models\Spmate sm
      WHERE sm.cdartn = :cdartn: AND sm.tpcomp = :tpcomp: ';
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdartn' => $cdartn, 'tpcomp' => $tpcomp));
    return count($result) > 0 ? $result[0]->inplib == 1 : false;
  }
  //endregion
}
