<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Smcorp extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdarti;

  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $tpcomp;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdmate;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('smcorp');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdarti' => isset($rec->cdarti) && (string)$rec->cdarti !== '' ? (string)$rec->cdarti : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0,
      'tpcomp' => isset($rec->tpcomp) && (string)$rec->tpcomp !== '' ? (string)$rec->tpcomp : new RawValue('""'),
      'cdmate' => isset($rec->cdmate) && (string)$rec->cdmate !== '' ? (string)$rec->cdmate : new RawValue('""')
    );

    $query  = 'cdarti = :cdarti: AND seqrap = :seqrap:';
    $params = array(
      'cdarti' => $values['cdarti'],
      'seqrap' => $values['seqrap']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Smcorp objects
   */
  public static function getAllComponents($cdarti) {
    $query = 'SELECT DISTINCT sc.tpcomp, tc.dscomp, tm.cdmatn, tm.dsmatn,
      sc.cdmate, am.dsmate, am.cdcolo, am.flimag, tm.cdmacr, sc.seqrap
      FROM Go2B\Models\Smcorp sc
      INNER JOIN Go2B\Models\Tpcomp tc ON sc.tpcomp = tc.tpcomp
      INNER JOIN Go2B\Models\Anamat am ON sc.cdmate = am.cdmate
      INNER JOIN Go2B\Models\Tipmat tm ON am.cdmatn = tm.cdmatn
      WHERE sc.cdarti = :cdarti: AND tm.flbloc = 0 AND am.flbloc = 0
      GROUP BY sc.cdmate
      ORDER BY sc.seqrap, sc.tpcomp, tm.dsmatn, am.cdmate';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdarti' => $cdarti));
  }
  //endregion
}
