<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Scacon extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdcata;

  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=6, nullable=false)
   */
  public $tpcond;

  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $dtmini;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $dtmaxi;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $dtmcli;

  /**
   *
   * @var string
   * @Column(type="string", length=40, nullable=false)
   */
  public $dsscad;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $dtmcoi;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $dtmcof;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('scacon');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdcata' => isset($rec->cdcata) && (string)$rec->cdcata !== '' ? (string)$rec->cdcata : new RawValue('""'),
      'tpcond' => isset($rec->tpcond) && (string)$rec->tpcond !== '' ? (string)$rec->tpcond : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0,
      'dtmini' => isset($rec->dtmini) && (string)$rec->dtmini !== '' ? (string)$rec->dtmini : '0000-00-00',
      'dtmaxi' => isset($rec->dtmaxi) && (string)$rec->dtmaxi !== '' ? (string)$rec->dtmaxi : '0000-00-00',
      'dtmcli' => isset($rec->dtmcli) && (string)$rec->dtmcli !== '' ? (string)$rec->dtmcli : '0000-00-00',
      'dsscad' => isset($rec->dsscad) && (string)$rec->dsscad !== '' ? (string)$rec->dsscad : new RawValue('""'),
      'dtmcoi' => isset($rec->dtmcoi) && (string)$rec->dtmcoi !== '' ? (string)$rec->dtmcoi : '0000-00-00',
      'dtmcof' => isset($rec->dtmcof) && (string)$rec->dtmcof !== '' ? (string)$rec->dtmcof : '0000-00-00'
    );

    $query  = 'cdcata = :cdcata: AND tpcond = :tpcond: AND seqrap = :seqrap:';
    $params = array(
      'cdcata' => $values['cdcata'],
      'tpcond' => $values['tpcond'],
      'seqrap' => $values['seqrap']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Scacon objects
   */
  public static function getDatesFromCatalog($cdcata, $tpcond) {
    $query = "SELECT s.cdcata, s.tpcond, s.seqrap, s.dsscad,
      s.dtmini AS raw_dtmini, DATE_FORMAT(s.dtmini, '%d/%m/%Y') AS dtmini,
      s.dtmaxi AS raw_dtmaxi, DATE_FORMAT(s.dtmaxi, '%d/%m/%Y') AS dtmaxi,
      s.dtmcli AS raw_dtmcli, DATE_FORMAT(s.dtmcli, '%d/%m/%Y') AS dtmcli,
      s.dtmcoi AS raw_dtmcoi, DATE_FORMAT(s.dtmcoi, '%d/%m/%Y') AS dtmcoi,
      s.dtmcof AS raw_dtmcof, DATE_FORMAT(s.dtmcof, '%d/%m/%Y') AS dtmcof
      FROM Go2B\Models\Scacon s
      WHERE s.cdcata = :cdcata: AND s.tpcond = :tpcond:
      ORDER BY s.seqrap";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdcata' => $cdcata, 'tpcond' => $tpcond));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Scacon objects
   */
  public static function getPeriodsForCatalog($cdcata) {
    $periods = self::find(
      array('cdcata = :cdcata: AND dtmini <= :dtoggi: AND dtmaxi >= :dtoggi:',
            'bind' => array('cdcata' => $cdcata, 'dtoggi' => date('Y-m-d'))));
    return count($periods) > 0 ? $periods : array();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Scacon objects
   */
  public static function getTwoStepsPeriodsForCatalog($cdcata) {
    $periods = self::find(
      array('cdcata = :cdcata: AND dtmcoi >= :dtoggi:',
            'bind' => array('cdcata' => $cdcata, 'dtoggi' => date('Y-m-d'))));
    return count($periods) > 0 ? $periods : array();
  }

  /**
   * Query:   SELECT
   * Return:  int
   */
  public static function getMaxSeqrap($cdcata, $tpcond) {
    $query = "SELECT COALESCE(MAX(s.seqrap), 0) AS seqrap
      FROM Go2B\Models\Scacon s
      WHERE s.cdcata = :cdcata: AND s.tpcond = :tpcond:";
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdcata' => $cdcata, 'tpcond' => $tpcond));
    return $result[0]->seqrap;
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertExpiration($cdcata, $tpcond, $seqrap, $dtmini, $dtmaxi, $dtmcli, $dsscad, $dtmcoi, $dtmcof) {
    $params = array('cdcata' => $cdcata, 'tpcond' => $tpcond, 'seqrap' => $seqrap,
      'dtmini' => $dtmini, 'dtmaxi' => $dtmaxi, 'dtmcli' => $dtmcli,
      'dsscad' => $dsscad, 'dtmcoi' => $dtmcoi, 'dtmcof' => $dtmcof);
    $query = "INSERT INTO Go2B\Models\Scacon (cdcata, tpcond, seqrap, dtmini, dtmaxi, dtmcli,
      dsscad, dtmcoi, dtmcof)
      VALUES (:cdcata:, :tpcond:, :seqrap:, :dtmini:, :dtmaxi:, :dtmcli:,
      :dsscad:, :dtmcoi:, :dtmcof:)";
    Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateExpiration($cdcata, $tpcond, $seqrap, $dtmini, $dtmaxi, $dtmcli, $dsscad, $dtmcoi, $dtmcof) {
    $params = array('cdcata' => $cdcata, 'tpcond' => $tpcond, 'seqrap' => $seqrap,
      'dtmini' => $dtmini, 'dtmaxi' => $dtmaxi, 'dtmcli' => $dtmcli,
      'dsscad' => $dsscad, 'dtmcoi' => $dtmcoi, 'dtmcof' => $dtmcof);
    $query = "UPDATE Go2B\Models\Scacon s SET s.dtmini = :dtmini:, s.dtmaxi = :dtmaxi:,
      s.dtmcli = :dtmcli:, s.dsscad = :dsscad:, s.dtmcoi = :dtmcoi:, s.dtmcof = :dtmcof:
      WHERE s.cdcata = :cdcata: AND s.tpcond = :tpcond: AND s.seqrap = :seqrap:";
    Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteExpiration($cdcata, $tpcond, $seqrap) {
    $params = array('cdcata' => $cdcata, 'tpcond' => $tpcond, 'seqrap' => $seqrap);
    $query = "DELETE s.*
      FROM scacon s
      WHERE s.cdcata = :cdcata AND s.tpcond = :tpcond AND s.seqrap = :seqrap";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function emptyTable() {
    $query = "TRUNCATE scacon";
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
