<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Psagen extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=6, nullable=false)
   */
  public $cdagen;

  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=6, nullable=false)
   */
  public $cdpost;

  /**
   *
   * @var string
   * @Column(type="string", length=20, nullable=false)
   */
  public $dspost;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $egoapp;

  /**
   *
   * @var string
   * @Column(type="string", length=2, nullable=false)
   */
  public $idlang;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $dtexpo;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $dtaggi;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $fltest;

  /**
   *
   * @var string
   * @Column(type="string", length=2, nullable=false)
   */
  public $tpordc;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $prosrv;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $dtexpi;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $cdmaga;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $keylic;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $scriga;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('psagen');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdagen' => isset($rec->cdagen) && (string)$rec->cdagen !== '' ? (string)$rec->cdagen : 0,
      'cdpost' => isset($rec->cdpost) && (string)$rec->cdpost !== '' ? (string)$rec->cdpost : 0,
      'dspost' => isset($rec->dspost) && (string)$rec->dspost !== '' ? (string)$rec->dspost : new RawValue('""'),
      'egoapp' => isset($rec->egoapp) && (string)$rec->egoapp !== '' ? (string)$rec->egoapp : 0,
      'idlang' => isset($rec->idlang) && (string)$rec->idlang !== '' ? (string)$rec->idlang : new RawValue('""'),
      'dtexpo' => isset($rec->dtexpo) && (string)$rec->dtexpo !== '' ? (string)$rec->dtexpo : new RawValue('""'),
      'dtaggi' => isset($rec->dtaggi) && (string)$rec->dtaggi !== '' ? (string)$rec->dtaggi : new RawValue('""'),
      'fltest' => isset($rec->fltest) && (string)$rec->fltest !== '' ? (string)$rec->fltest : 0,
      'tpordc' => isset($rec->tpordc) && (string)$rec->tpordc !== '' ? (string)$rec->tpordc : new RawValue('""'),
      'prosrv' => isset($rec->prosrv) && (string)$rec->prosrv !== '' ? (string)$rec->prosrv : 0,
      'dtexpi' => isset($rec->dtexpi) && (string)$rec->dtexpi !== '' ? (string)$rec->dtexpi : new RawValue('""'),
      'cdmaga' => isset($rec->cdmaga) && (string)$rec->cdmaga !== '' ? (string)$rec->cdmaga : 0,
      'keylic' => isset($rec->keylic) && (string)$rec->keylic !== '' ? (string)$rec->keylic : new RawValue('""'),
      'scriga' => isset($rec->scriga) && (string)$rec->scriga !== '' ? (string)$rec->scriga : new RawValue('""')
    );

    $query  = 'cdagen = :cdagen: AND cdpost = :cdpost:';
    $params = array(
      'cdagen' => $values['cdagen'],
      'cdpost' => $values['cdpost'],
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Psagen objects
   */
  public static function getAllDevices() {
    $query = "SELECT p.egoapp, p.dspost, p.cdagen, p.cdpost, an.dsagen,
      t.dscond, IF(ab.fltota > 0, 'S', '') AS fltota,
      IF(ab.fllist > 0,'S','') AS fllist, IF(p.keylic > '', 'S', '') AS keylic
      FROM Go2B\Models\Psagen p
      INNER JOIN Go2B\Models\Anaage an ON an.cdagen = p.cdagen
      INNER JOIN Go2B\Models\Abagen ab ON ab.cdagen = p.cdagen
      LEFT JOIN Go2B\Models\Tpcond t ON t.tpcond = ab.tpcond
      WHERE p.egoapp > 0
      GROUP BY p.cdagen, p.cdpost
      ORDER BY p.egoapp";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertNewDevice($cdagen, $cdpost, $dspost, $egoapp) {
    $params = array('cdagen' => $cdagen, 'cdpost' => $cdpost, 'dspost' => $dspost, 'egoapp' => $egoapp);
    $query = "INSERT INTO psagen (cdagen, cdpost, dspost, egoapp, idlang,
      dtexpo, dtaggi, fltest, tpordc, prosrv, dtexpi, cdmaga, keylic, scriga)
      VALUES (:cdagen, :cdpost, :dspost, :egoapp, 'IT', '0000-00-00 00:00:00',
      '0000-00-00', 0, '', 0, '0000-00-00', 0, '', 0)";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteDeviceForAgent($cdagen, $cdpost) {
    $query = "DELETE p.*
      FROM psagen p
      WHERE p.cdagen = :cdagen AND p.cdpost = :cdpost";
    Di::getDefault()->get('db')->query($query, array('cdagen' => $cdagen, 'cdpost' => $cdpost));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAgent($cdagen) {
    $query = "DELETE p.*
      FROM psagen p
      WHERE p.cdagen = :cdagen";
    Di::getDefault()->get('db')->query($query, array('cdagen' => $cdagen));
  }
  //endregion
}
