<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Pagcon extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=4, nullable=false)
   */
  public $cdstag;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $tpcond;

  /**
   *
   * @var string
   * @Column(type="string", length=4, nullable=false)
   */
  public $tppaga;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $valmin;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('pagcon');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdstag' => isset($rec->cdstag) && (string)$rec->cdstag !== '' ? (string)$rec->cdstag : new RawValue('""'),
      'tpcond' => isset($rec->tpcond) && (string)$rec->tpcond !== '' ? (string)$rec->tpcond : 0,
      'tppaga' => isset($rec->tppaga) && (string)$rec->tppaga !== '' ? (string)$rec->tppaga : new RawValue('""'),
      'valmin' => isset($rec->valmin) && (string)$rec->valmin !== '' ? (string)$rec->valmin : 0
    );

    $query  = 'cdstag = :cdstag: AND tpcond = :tpcond: AND tppaga = :tppaga:';
    $params = array(
      'cdstag' => $values['cdstag'],
      'tpcond' => $values['tpcond'],
      'tppaga' => $values['tppaga']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Pagcon objects
   */
  public static function getConditions($cdstag, $tpcond) {
    $query = "SELECT p.tppaga AS tpitem, p.valmin AS valmin
      FROM Go2B\Models\Pagcon p
      WHERE p.cdstag = :cdstag: AND p.tpcond = :tpcond:";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdstag' => $cdstag, 'tpcond' => $tpcond));
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertCondition($cdstag, $tpcond, $tppaga, $valmin) {
    $params = array('cdstag' => $cdstag, 'tpcond' => $tpcond, 'tppaga' => $tppaga, 'valmin' => $valmin);
    $query = "INSERT INTO pagcon (cdstag, tpcond, tppaga, valmin)
      VALUES (:cdstag, :tpcond, :tppaga, :valmin)";
    return Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteConditions($cdstag, $tpcond) {
    $params = array('cdstag' => $cdstag, 'tpcond' => $tpcond);
    $query = "DELETE p.*
      FROM pagcon p
      WHERE p.cdstag = :cdstag AND p.tpcond = :tpcond";
    return Di::getDefault()->get('db')->query($query, $params);
  }
  //endregion
}
