<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Ocproc extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=11, nullable=false)
   */
  public $nuordc;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdprom;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdarti;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $prezzo;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $scont1;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $scont2;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $scont3;

  /**
   *
   * @var string
   * @Column(type="string", length=2, nullable=false)
   */
  public $tipapp;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('ocproc');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'nuordc' => isset($rec->nuordc) && (string)$rec->nuordc !== '' ? (string)$rec->nuordc : 0,
      'cdprom' => isset($rec->cdprom) && (string)$rec->cdprom !== '' ? (string)$rec->cdprom : new RawValue('""'),
      'cdarti' => isset($rec->cdarti) && (string)$rec->cdarti !== '' ? (string)$rec->cdarti : new RawValue('""'),
      'prezzo' => isset($rec->prezzo) && (string)$rec->prezzo !== '' ? (string)$rec->prezzo : 0,
      'scont1' => isset($rec->scont1) && (string)$rec->scont1 !== '' ? (string)$rec->scont1 : 0,
      'scont2' => isset($rec->scont2) && (string)$rec->scont2 !== '' ? (string)$rec->scont2 : 0,
      'scont3' => isset($rec->scont3) && (string)$rec->scont3 !== '' ? (string)$rec->scont3 : 0,
      'tipapp' => isset($rec->tipapp) && (string)$rec->tipapp !== '' ? (string)$rec->tipapp : new RawValue('""')
    );

    $query  = 'nuordc = :nuordc: AND cdprom = :cdprom: AND cdarti = :cdarti:';
    $params = array(
      'nuordc' => $values['nuordc'],
      'cdprom' => $values['cdprom'],
      'cdarti' => $values['cdarti']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   INSERT
   * Return:  bool
   */
  public static function insertPromoArticle($nuordc, $cdpromo, $cdarti, $prezzo, $scont1, $scont2, $scont3, $tipapp) {
    $ocproc = new self();
    $ocproc->nuordc = $nuordc;
    $ocproc->cdprom = $cdprom;
    $ocproc->cdarti = $cdarti;
    $ocproc->prezzo = $prezzo;
    $ocproc->scont1 = $scont1;
    $ocproc->scont2 = $scont2;
    $ocproc->scont3 = $scont3;
    $ocproc->tipapp = $tipapp;
    return $ocproc->save();
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteArticlesPromo($cdprom, $nuordc) {
    $query = 'DELETE FROM ocproc
      WHERE nuordc = :nuordc AND cdprom = :cdprom';
    Di::getDefault()->get('db')->query($query, array('nuordc' => $nuordc, 'cdprom' => $cdprom));
  }
  //endregion
}
