<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Lstest extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $nulist;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dslist;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;

  /**
   *
   * @var string
   * @Column(type="string", length=4, nullable=false)
   */
  public $cdvalu;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $dtiniz;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $dtfine;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('lstest');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'nulist' => isset($rec->nulist) && (string)$rec->nulist !== '' ? (string)$rec->nulist : new RawValue('""'),
      'dslist' => isset($rec->dslist) && (string)$rec->dslist !== '' ? (string)$rec->dslist : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0,
      'cdvalu' => isset($rec->cdvalu) && (string)$rec->cdvalu !== '' ? (string)$rec->cdvalu : new RawValue('""'),
      'dtiniz' => isset($rec->dtiniz) && (string)$rec->dtiniz !== '' ? (string)$rec->dtiniz : '0000-00-00',
      'dtfine' => isset($rec->dtfine) && (string)$rec->dtfine !== '' ? (string)$rec->dtfine : '0000-00-00'
    );

    $query  = 'nulist = :nulist:';
    $params = array(
      'nulist' => $values['nulist']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Lstest objects
   */
  public static function getAllPriceLists() {
    $query = 'SELECT l.nulist, l.dslist
      FROM Go2B\Models\Lstest l';
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Lstest objects
   */
  public static function getAllPriceListsForAgent($cdagen) {
    $params = array();
    $join = '';
    if ($cdagen >= 0) {
      $params = array('cdagen' => $cdagen);
      $join = "INNER JOIN Go2B\Models\Ageana aa ON aa.tipdat = 'C' AND aa.cdagen = :cdagen: AND aa.tpanag = a.tpanag AND aa.codice = a.cdanag";
    }
    $query = "SELECT l.nulist, l.dslist
      FROM Go2B\Models\Lstest l
      INNER JOIN Go2B\Models\Anagra a ON a.nulist = l.nulist
      $join
      WHERE a.cdblco < 2
      GROUP BY l.nulist
      ORDER BY l.nulist ";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Lstest objects
   */
  public static function getAllAvailablePriceListsForAgent($cdagen) {
    $query = 'SELECT l.nulist, l.dslist
      FROM Go2B\Models\Lstest l
      INNER JOIN Go2B\Models\B2bAddinf i ON i.tabell = "anaage" AND i.codic1 = :cdagen: AND i.tpdato = "nulist" AND i.valore = l.nulist
      WHERE (l.dtiniz <= :today: OR l.dtiniz = "0000-00-00")
      AND (l.dtfine >= :today: OR l.dtfine = "0000-00-00")
      GROUP BY l.nulist
      ORDER BY l.nulist';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdagen' => $cdagen, 'today' => date('Y-m-d')));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Lstest objects
   */
  public static function getAllAvailablePriceLists() {
    $query = 'SELECT l.nulist, l.dslist
      FROM Go2B\Models\Lstest l
      WHERE (l.dtiniz <= :today: OR l.dtiniz = "0000-00-00")
      AND (l.dtfine >= :today: OR l.dtfine = "0000-00-00")';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('today' => date('Y-m-d')));
  }
  //endregion
}
