<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Lktest extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdlkbk;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dslkbk;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdcata;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=true)
   */
  public $filimg;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $fltipo;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('lktest');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdlkbk' => isset($rec->cdlkbk) && (string)$rec->cdlkbk !== '' ? (string)$rec->cdlkbk : new RawValue('""'),
      'dslkbk' => isset($rec->dslkbk) && (string)$rec->dslkbk !== '' ? (string)$rec->dslkbk : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0,
      'cdcata' => isset($rec->cdcata) && (string)$rec->cdcata !== '' ? (string)$rec->cdcata : new RawValue('""'),
      'filimg' => isset($rec->filimg) && (string)$rec->filimg !== '' ? (string)$rec->filimg : new RawValue('""'),
      'fltipo' => isset($rec->fltipo) && (string)$rec->fltipo !== '' ? (string)$rec->fltipo : 0
    );

    $query  = 'cdlkbk = :cdlkbk:';
    $params = array(
      'cdlkbk' => $values['cdlkbk']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Lktest objects
   */
  public static function getAllLookbooks($type) {
    $params = array('fltipo' => $type);
    $query = 'SELECT l.cdlkbk, l.dslkbk, l.seqrap, l.cdcata, l.filimg,
      (SELECT COUNT(lk.cdlook) FROM Go2B\Models\Lkcorp lk WHERE lk.cdlkbk = l.cdlkbk) AS num_look
      FROM Go2B\Models\Lktest l
      WHERE l.fltipo = :fltipo:
      ORDER BY l.seqrap, l.cdlkbk';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Lktest objects
   */
  public static function getAllLookbooksFromCatalog($cdcata) {
    $query = 'SELECT l.cdlkbk, l.dslkbk, l.seqrap, l.filimg
      FROM Go2B\Models\Lktest l
      WHERE l.cdcata = :cdcata:
      ORDER BY l.seqrap, l.dslkbk';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdcata' => $cdcata));
  }

  /**
   * Query:   SELECT
   * Return:  Lktest object
   */
  public static function getLookbook($cdlkbk) {
    $query = 'SELECT l.cdlkbk, l.dslkbk, l.cdcata, c.dscata, l.filimg
      FROM Go2B\Models\Lktest l
      INNER JOIN Go2B\Models\Cttest c ON l.cdcata = c.cdcata
      WHERE l.cdlkbk = :cdlkbk:';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdlkbk' => $cdlkbk))[0];
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function createNewLookbook($cdlkbk, $dslkbk, $cdcata, $filimg, $fltipo) {
    $params = array('cdlkbk' => $cdlkbk, 'dslkbk' => $dslkbk, 'cdcata' => $cdcata, 'filimg' => $filimg, 'fltipo' => $fltipo);
    $query = 'INSERT INTO lktest (cdlkbk, dslkbk, seqrap, cdcata, filimg, fltipo)
      VALUES (:cdlkbk, :dslkbk, 0, :cdcata, :filimg, :fltipo)';
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateLookbook($cdlkbk, $dslkbk, $filimg) {
    $params = array('cdlkbk' => $cdlkbk, 'dslkbk' => $dslkbk, 'filimg' => $filimg);
    $query = 'UPDATE lktest
      SET dslkbk = :dslkbk, filimg = :filimg
      WHERE cdlkbk = :cdlkbk';
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteLookbook($cdlkbk) {
    $query = 'DELETE lt.*
      FROM lktest lt
      WHERE lt.cdlkbk = :cdlkbk';
    Di::getDefault()->get('db')->query($query, array('cdlkbk' => $cdlkbk));
  }

  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function emptyTable() {
    $query = "TRUNCATE lktest";
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
