<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Linmod extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdlinm;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dslinm;

  /**
   *
   * @var string
   * @Column(type="string", length=4, nullable=false)
   */
  public $cdtitl;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=false)
   */
  public $flimag;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('linmod');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdlinm' => isset($rec->cdlinm) && (string)$rec->cdlinm !== '' ? (string)$rec->cdlinm : new RawValue('""'),
      'dslinm' => isset($rec->dslinm) && (string)$rec->dslinm !== '' ? (string)$rec->dslinm : new RawValue('""'),
      'cdtitl' => isset($rec->cdtitl) && (string)$rec->cdtitl !== '' ? (string)$rec->cdtitl : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0,
      'flimag' => isset($rec->flimag) && (string)$rec->flimag !== '' ? (string)$rec->flimag : new RawValue('""')
    );

    $query  = 'cdlinm = :cdlinm:';
    $params = array(
      'cdlinm' => $values['cdlinm']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Linmod objects
   */
  public static function getAllLines() {
    $query = "SELECT tl.cdtitl, tl.dstitl, lm.cdlinm, lm.dslinm,
      lm.cdlinm AS code, lm.dslinm AS description
      FROM Go2B\Models\Linmod lm
      INNER JOIN Go2B\Models\Titlin tl ON lm.cdtitl = tl.cdtitl
      ORDER BY lm.dslinm";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Linmod objects
   */
  public static function getAllLinesWithLanguageDescriptions() {
    $query = "SELECT lm.cdlinm, lm.dslinm, lm.cdtitl, COALESCE(tl.dstitl, '') AS dstitl,
      COALESCE(den.descri,'') AS des_en, COALESCE(des.descri,'') AS des_es,
      COALESCE(dfr.descri,'') AS des_fr, COALESCE(dde.descri,'') AS des_de
      FROM Go2B\Models\Linmod lm
      LEFT JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN Go2B\Models\Deslin den ON den.tpdato = 'dslinm' AND den.codic1 = lm.cdlinm AND den.codic2 = '' AND den.idlang = 'EN'
      LEFT JOIN Go2B\Models\Deslin des ON des.tpdato = 'dslinm' AND des.codic1 = lm.cdlinm AND des.codic2 = '' AND des.idlang = 'ES'
      LEFT JOIN Go2B\Models\Deslin dfr ON dfr.tpdato = 'dslinm' AND dfr.codic1 = lm.cdlinm AND dfr.codic2 = '' AND dfr.idlang = 'FR'
      LEFT JOIN Go2B\Models\Deslin dde ON dde.tpdato = 'dslinm' AND dde.codic1 = lm.cdlinm AND dde.codic2 = '' AND dde.idlang = 'DE'
      ORDER BY lm.dslinm";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Linmod objects
   */
  public static function getLinesForLocalization() {
    $query = "SELECT lm.cdlinm AS code, lm.dslinm AS description,
      COALESCE(it.valore,'') AS des_it, COALESCE(en.valore,'') AS des_en,
      COALESCE(es.valore,'') AS des_es, COALESCE(fr.valore,'') AS des_fr,
      COALESCE(de.valore,'') AS des_de
      FROM Go2B\Models\Linmod lm
      LEFT JOIN Go2B\Models\B2bAddinf it ON it.tabell = 'linmod' AND it.codic1 = lm.cdlinm AND it.codic2 = '' AND it.tpdato = 'des_it'
      LEFT JOIN Go2B\Models\B2bAddinf en ON en.tabell = 'linmod' AND en.codic1 = lm.cdlinm AND en.codic2 = '' AND en.tpdato = 'des_en'
      LEFT JOIN Go2B\Models\B2bAddinf es ON es.tabell = 'linmod' AND es.codic1 = lm.cdlinm AND es.codic2 = '' AND es.tpdato = 'des_es'
      LEFT JOIN Go2B\Models\B2bAddinf fr ON fr.tabell = 'linmod' AND fr.codic1 = lm.cdlinm AND fr.codic2 = '' AND fr.tpdato = 'des_fr'
      LEFT JOIN Go2B\Models\B2bAddinf de ON de.tabell = 'linmod' AND de.codic1 = lm.cdlinm AND de.codic2 = '' AND de.tpdato = 'des_de'
      ORDER BY lm.cdlinm";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Linmod objects
   */
  public static function getAllMinimalLinesWithBrand() {
    $query = "SELECT lm.cdlinm, lm.dslinm, tl.cdtitl, tl.dstitl
      FROM Go2B\Models\Linmod lm
      INNER JOIN Go2B\Models\Titlin tl ON lm.cdtitl = tl.cdtitl
      ORDER BY tl.dstitl, lm.dslinm";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Linmod objects
   */
  public static function getAllLinesFromBrand($cdcata, $cdtitl, $idlang = 'IT') {
    $params = array('cdcata' => $cdcata, 'cdtitl' => $cdtitl, 'tpdato' => 'des_' . strtolower($idlang));
    $ljoin  = "LEFT JOIN Go2B\Models\B2bAddinf ai ON ai.tabell = 'linmod' AND ai.codic1 = lm.cdlinm AND ai.codic2 = '' AND ai.tpdato = :tpdato: ";

    if ($idlang != 'IT') {
      $dslinm = 'COALESCE(ai.valore,d1.descri,lm.dslinm)';
      $ljoin .= "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dslinm' AND d1.codic1 = lm.cdlinm AND d1.idlang = :idlang: ";
      $params['idlang'] = $idlang;
    } else {
      $dslinm = 'COALESCE(ai.valore,lm.dslinm)';
    }

    $query = "SELECT lm.cdlinm, $dslinm AS dslinm
      FROM Go2B\Models\Linmod lm
      INNER JOIN Go2B\Models\Tipolo tp ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Anaart aa ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON aa.cdarti = ca.cdarti
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      $ljoin
      WHERE ca.cdcata = :cdcata: AND lm.cdtitl = :cdtitl:
      AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      GROUP BY lm.cdlinm
      ORDER BY lm.seqrap, lm.dslinm, lm.cdlinm";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Linmod objects
   */
  public static function getAllLinesFromCatalog($cdcata = '', $cdstag = '') {
    $params = array();
    $where  = '';
    if ($cdcata != '') {
      $params['cdcata'] = $cdcata;
      $where = 'WHERE aa.cdarti NOT IN (SELECT ca.cdarti FROM Go2B\Models\Ctarti ca WHERE ca.cdcata = :cdcata: AND ca.cdarti IS NOT NULL)';
    }

    $seasonJoin = '';
    if ($cdstag != '') {
      $where .= $where != '' ? ' AND ' : ' WHERE ';
      $where .= ' ct.cdstag = :cdstag: ';
      $seasonJoin = 'INNER JOIN Go2B\Models\Ctarti ca ON aa.cdarti = ca.cdarti
        INNER JOIN Go2B\Models\Cttest ct ON ct.cdcata = ca.cdcata';
      $params['cdstag'] = $cdstag;
    }

    $query = "SELECT lm.cdlinm, lm.dslinm, lm.cdlinm,
      COALESCE(sm.cdserm,'') AS cdserm, tl.cdtitl
      FROM Go2B\Models\Tipolo tp
      INNER JOIN Go2B\Models\Anaart aa ON tp.cdartn = aa.cdartn
      $seasonJoin
      INNER JOIN Go2B\Models\Linmod lm ON tp.cdlinm = lm.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON lm.cdtitl = tl.cdtitl
      LEFT JOIN Go2B\Models\Sermod sm ON tp.cdlinm = sm.cdlinm AND tp.cdserm = sm.cdserm
      $where
      GROUP BY lm.cdlinm
      ORDER BY tl.cdtitl, lm.seqrap, lm.cdlinm, tp.cdartn";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Linmod objects
   */
  public static function getLinesFromCatalog($cdcata) {
    $query = 'SELECT lm.cdlinm, lm.dslinm, tl.cdtitl, tl.dstitl
      FROM Go2B\Models\Linmod lm
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdlinm = lm.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON ca.cdarti = aa.cdarti
      WHERE ca.cdcata = :cdcata:
      GROUP BY tl.cdtitl, lm.cdlinm
      ORDER BY tl.dstitl, lm.dslinm';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdcata' => $cdcata));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Linmod objects
   */
  public static function getLinesFilteredByGenreFromCatalog($cdcata, $tpgene) {
    $params = array('cdcata' => $cdcata, 'tpgene' => $tpgene);
    $query = 'SELECT lm.cdlinm, lm.dslinm, tl.cdtitl, tl.dstitl
      FROM Go2B\Models\Linmod lm
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdlinm = lm.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON ca.cdarti = aa.cdarti
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      WHERE ca.cdcata = :cdcata: AND tp.tpgene = :tpgene:
      AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,"2000-01-01") <= CURRENT_DATE() AND IFNULL(ba.dtfine,"2200-01-01") >= CURRENT_DATE()
      GROUP BY tl.dstitl, lm.dslinm';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Linmod objects
   */
  public static function getLinesFilteredByModelTypeFromCatalog($cdcata, $tpmode) {
    $params = array('cdcata' => $cdcata, 'tpmode' => $tpmode);
    $query = 'SELECT lm.cdlinm, lm.dslinm, tl.cdtitl, tl.dstitl
      FROM Go2B\Models\Linmod lm
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdlinm = lm.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON ca.cdarti = aa.cdarti
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      WHERE ca.cdcata = :cdcata: AND tp.tpmode = :tpmode:
      AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,"2000-01-01") <= CURRENT_DATE() AND IFNULL(ba.dtfine,"2200-01-01") >= CURRENT_DATE()
      GROUP BY tl.dstitl, lm.dslinm';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Linmod objects
   */
  public static function getLinesWithDiscountFromCatalogs($whereCatalogs, $params) {
    $query = "SELECT DISTINCT lm.cdlinm, lm.dslinm, COALESCE(cb.sconto,0) AS sconto
      FROM Go2B\Models\Linmod lm
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdlinm = lm.cdlinm
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON ca.cdarti = aa.cdarti
      LEFT JOIN Go2B\Models\B2bDisbdy cb ON cb.cdlinm = lm.cdlinm AND cb.cdserm = '' AND cb.numdis = :numdis:
      WHERE ca.cdcata IN ($whereCatalogs)";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Linmod objects
   */
  public static function getLinesFromCatalogWithConditions($cdcata, $idlang = 'IT') {
    $params = array('cdcata' => $cdcata, 'tpdato' => 'des_' . strtolower($idlang));
    $ljoin  = "LEFT JOIN Go2B\Models\B2bAddinf ai ON ai.tabell = 'linmod' AND ai.codic1 = lm.cdlinm AND ai.codic2 = '' AND ai.tpdato = :tpdato: ";

    if ($idlang != 'IT') {
      $dslinm = 'COALESCE(ai.valore,d1.descri,lm.dslinm)';
      $ljoin .= "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dslinm' AND d1.codic1 = lm.cdlinm AND d1.idlang = :idlang: ";
      $params['idlang'] = $idlang;
    } else {
      $dslinm = 'COALESCE(ai.valore,lm.dslinm)';
    }

    $query = "SELECT lm.cdlinm, $dslinm AS dslinm, tl.cdtitl, lm.seqrap, lm.flimag
      FROM Go2B\Models\Linmod lm
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdlinm = lm.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON ca.cdarti = aa.cdarti
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      $ljoin
      WHERE ca.cdcata = :cdcata:
      AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      GROUP BY dslinm
      ORDER BY lm.seqrap, dslinm";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Linmod objects
   */
  public static function getLinesFromCatalogAndBrandWithConditions($cdcata, $cdtitl, $idlang = 'IT') {
    $params = array('cdcata' => $cdcata, 'cdtitl' => $cdtitl, 'tpdato' => 'des_' . strtolower($idlang));
    $ljoin  = "LEFT JOIN Go2B\Models\B2bAddinf ai ON ai.tabell = 'linmod' AND ai.codic1 = lm.cdlinm AND ai.codic2 = '' AND ai.tpdato = :tpdato: ";

    if ($idlang != 'IT') {
      $dslinm = 'COALESCE(ai.valore,d1.descri,lm.dslinm)';
      $ljoin .= "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dslinm' AND d1.codic1 = lm.cdlinm AND d1.idlang = :idlang: ";
      $params['idlang'] = $idlang;
    } else {
      $dslinm = 'COALESCE(ai.valore,lm.dslinm)';
    }

    $query = "SELECT lm.cdlinm, $dslinm AS dslinm, tl.cdtitl, lm.seqrap, lm.flimag
      FROM Go2B\Models\Linmod lm
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdlinm = lm.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON ca.cdarti = aa.cdarti
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      $ljoin
      WHERE ca.cdcata = :cdcata: AND tl.cdtitl = :cdtitl:
      AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      GROUP BY dslinm
      ORDER BY lm.seqrap, dslinm";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Linmod objects
   */
  public static function getArticleCodesFromLines($where, $params) {
    $query = "SELECT a.cdarti
      FROM Go2B\Models\Linmod l
      INNER JOIN Go2B\Models\Tipolo t ON l.cdlinm = t.cdlinm
      INNER JOIN Go2B\Models\Anaart a ON t.cdartn = a.cdartn
      WHERE l.cdlinm IN ($where)";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Linmod objects
   */
  public static function getAllLinesWithBanner() {
    $query = "SELECT lm.cdlinm AS code1, '' AS code2, lm.dslinm AS description, COALESCE(ai.valore,'') AS banner
      FROM Go2B\Models\Linmod lm
      LEFT JOIN Go2B\Models\B2bAddinf ai ON ai.tabell = 'linmod' AND ai.codic1 = lm.cdlinm AND ai.codic2 = '' AND ai.tpdato = 'banner'
      ORDER BY lm.dslinm";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Linmod objects
   */
  public static function getAllLinesForPromo($cdprom) {
    if (!empty($cdprom)) {
      $presPvcorp = 'COALESCE((SELECT COUNT(c.cdlinm) FROM Go2B\Models\Pvcorp c WHERE c.cdlinm = l.cdlinm AND c.cdprom = :cdprom:), 0) AS presPvcorp';
      $presPvgrup = 'COALESCE((SELECT COUNT(g.cdlinm) FROM Go2B\Models\Pvgrup g WHERE g.cdlinm = l.cdlinm AND g.cdprom = :cdprom:), 0) AS presPvgrup';
      $params = array('cdprom' => $cdprom);
    } else {
      $presPvcorp = '0 AS presPvcorp';
      $presPvgrup = '0 AS presPvgrup';
      $params = array();
    }
    $query = "SELECT l.cdlinm, l.dslinm, $presPvcorp, $presPvgrup
      FROM Go2B\Models\Linmod l
      ORDER BY l.cdlinm";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return   string
   */
  public static function getFullDescriptionLine($cdlinm) {
    $query = "SELECT CONCAT(tl.dstitl, ' - ', lm.dslinm) AS description
      FROM Go2B\Models\Linmod lm
      INNER JOIN Go2B\Models\Titlin tl ON lm.cdtitl = tl.cdtitl
      WHERE lm.cdlinm = :cdlinm:";
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdlinm' => $cdlinm));
    return count($result) == 1 ? $result[0]->description : '';
  }
  //endregion
}
