<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Indorc extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=4, nullable=false)
   */
  public $tpindo;

  /**
   *
   * @var string
   * @Column(type="string", length=40, nullable=false)
   */
  public $dsindo;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('indorc');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'tpindo' => isset($rec->tpindo) && (string)$rec->tpindo !== '' ? (string)$rec->tpindo : new RawValue('""'),
      'dsindo' => isset($rec->dsindo) && (string)$rec->dsindo !== '' ? (string)$rec->dsindo : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0
    );

    $query  = 'tpindo = :tpindo:';
    $params = array(
      'tpindo' => $values['tpindo']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Indorc objects
   */
  public static function getAllDrops() {
    $query = "SELECT ic.tpindo, ic.dsindo,
      ic.tpindo AS code, ic.dsindo AS description
      FROM Go2B\Models\Indorc ic
      ORDER BY ic.seqrap";
      return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }
  //endregion
}
