<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Imgart extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=4, nullable=false)
   */
  public $tpimag;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $codic1;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $codic2;

  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=11, nullable=false)
   */
  public $seqrap;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=false)
   */
  public $flimag;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('imgart');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'tpimag' => isset($rec->tpimag) && (string)$rec->tpimag !== '' ? (string)$rec->tpimag : new RawValue('""'),
      'codic1' => isset($rec->codic1) && (string)$rec->codic1 !== '' ? trim((string)$rec->codic1) : new RawValue('""'),
      'codic2' => isset($rec->codic2) && (string)$rec->codic2 !== '' ? (string)$rec->codic2 : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0,
      'flimag' => isset($rec->flimag) && (string)$rec->flimag !== '' ? (string)$rec->flimag : new RawValue('""')
    );

    $query  = 'tpimag = :tpimag: AND codic1 = :codic1: AND codic2 = :codic2: AND seqrap = :seqrap:';
    $params = array(
      'tpimag' => $values['tpimag'],
      'codic1' => $values['codic1'],
      'codic2' => $values['codic2'],
      'seqrap' => $values['seqrap']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Imgart objects
   */
  public static function getImagesForModel($cdartn) {
    $query = "SELECT i.tpimag, i.flimag
      FROM Go2B\Models\Imgart i
      WHERE i.codic1 = :cdartn:
      ORDER BY i.tpimag";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdartn' => $cdartn));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Imgart objects
   */
  public static function getAllImagesFromModel($cdartn) {
    $query = "SELECT i.seqrap, i.flimag
      FROM Go2B\Models\Imgart i
      WHERE i.tpimag LIKE 'MOD%' AND i.codic1 = :cdartn:
      ORDER BY i.seqrap, i.tpimag";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdartn' => $cdartn));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Imgart objects
   */
  public static function getAllImagesFromArticle($cdarti) {
    $query = "SELECT i.seqrap, i.flimag
      FROM Go2B\Models\Imgart i
      WHERE i.tpimag LIKE 'AR%' AND i.codic1 = :cdarti:
      ORDER BY i.seqrap, i.tpimag";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdarti' => $cdarti));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Imgart objects
   */
  public static function getAllImagesFromColor($cdarti, $cdcolo) {
    $query = "SELECT i.seqrap, i.flimag
      FROM Go2B\Models\Imgart i
      WHERE i.tpimag LIKE 'AC%' AND i.codic1 = :cdarti: AND i.codic2 = :cdcolo:
      ORDER BY i.seqrap, i.tpimag";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdarti' => $cdarti, 'cdcolo' => $cdcolo));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Imgart objects
   */
  public static function getFabricColorImage($cdpers, $cdcolo) {
    $query = "SELECT i.seqrap, i.flimag
      FROM Go2B\Models\Imgart i
      WHERE i.tpimag LIKE 'ARTP' AND i.codic1 = :cdpers: AND i.codic2 = :cdcolo:
      ORDER BY i.seqrap, i.tpimag";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdpers' => $cdpers, 'cdcolo' => $cdcolo));
  }

  /**
   * Query:   SELECT
   * Return:  Array of mixed arrays
   */
  public static function getAllImagesToFindAndSync($cdcata, $isFabric = false, $reassign = false, $i = 0, $type = 0) {
    switch ($i) {
      case 0:
        $params = array('cdcata' => $cdcata, 'findf0' => '.jpg');
        $query = "SELECT DISTINCT 0 AS sequen, 'tipolo' AS tablen, 'cdartn' AS fieldn, '' AS field2,
          tp.cdartn AS keynam, '' AS keyna2, '' AS keyna3,
          CONCAT(REPLACE(tp.cdartn, ' ', '_'), :findf0) AS flima1,
          '' AS flima2,
          '' AS flima3
          FROM tipolo tp
          INNER JOIN anaart ar ON tp.cdartn = ar.cdartn
          INNER JOIN ctarti ca ON ar.cdarti = ca.cdarti
          WHERE ca.cdcata = :cdcata " . ($reassign ? '' : " AND tp.flimag = '' ");
        break;
      case 1:
        $params = array('cdcata' => $cdcata, 'findf1' => '.jpg');
        $query = "SELECT DISTINCT 1 AS sequen, 'anaart' AS tablen, 'cdarti' AS fieldn, '' AS field2,
          ar.cdarti AS keynam, '' AS keyna2, '' AS keyna3,
          CONCAT(REPLACE(ar.cdarti, ' ', '_'), :findf1) AS flima1,
          IF(ar.cdpers > '', CONCAT(REPLACE(ar.cdpers, ' ', '_'), :findf1),IF(ar.cdcolo > '',CONCAT(REPLACE(ar.cdcolo, ' ', '_'), :findf1),'')) AS flima2," .
          (($type == 5) ? "CONCAT(REPLACE(ar.cdartn, ' ', '_'), :findf1)" : "''") . " as flima3
          FROM anaart ar
          INNER JOIN ctarti ca ON ar.cdarti = ca.cdarti
          WHERE ca.cdcata = :cdcata " . ($reassign ? '' : " AND ar.flimag = '' ");
        break;
      case 2:
        $params = array('cdcata' => $cdcata, 'findf2' => !$isFabric ? '.jpg' : '*.jpg');
        $query = "SELECT DISTINCT 2 AS sequen, 'anaper' AS tablen, 'cdpers' AS fieldn, '' AS field2,
          ar.cdpers AS keynam, '' AS keyna2, '' AS keyna3,
          CONCAT(REPLACE(ar.cdpers, ' ', '_'), :findf2) AS flima1,
          '' as flima2,
          '' as flima3
          FROM ctarti ca
          INNER JOIN anaart ar ON ar.cdarti = ca.cdarti
          INNER JOIN anaper ap ON ap.cdpers = ar.cdpers
          WHERE ca.cdcata = :cdcata AND ar.cdpers > '' " . ($reassign ? '' : " AND ap.flimag = '' ");
        break;
      case 3:
        $params = array('cdcata' => $cdcata, 'findf3' => '.jpg');
        $query = " SELECT DISTINCT 3 AS sequen, 'artcol' as tablen, 'cdarti' as fieldn, 'cdcolo' as field2,
          ar.cdarti as keynam, ac.cdcolo as keyna2, '' AS keyna3,
          CONCAT(REPLACE(ar.cdarti, ' ', '_'), '_', REPLACE(ac.cdcolo, ' ', '_'), :findf3) AS flima1,
          CONCAT(REPLACE(ar.cdpers, ' ', '_'), '_', REPLACE(ac.cdcolo, ' ', '_'), :findf3) AS flima2,
          '' AS flima3
          FROM artcol ac
          INNER JOIN anaart ar ON ar.cdarti = ac.cdarti
          INNER JOIN anaper ap ON ap.cdpers = ar.cdpers
          INNER JOIN ctarti ca ON ca.cdarti = ar.cdarti
          WHERE ca.cdcata = :cdcata " . ($reassign ? '' : " AND ac.flimag = '' ");
        break;
      case 4:
        $params = array('cdcata' => $cdcata, 'findf4' => '.jpg');
        $query = "SELECT DISTINCT 4 AS sequen, 'imgart' AS tablen, 'tpimag' AS fieldn, 'codic1' AS field2,
          CONCAT('MOD', pi.progim) AS keynam, tp.cdartn AS keyna2, '' AS keyna3,
          CONCAT(REPLACE(tp.cdartn, ' ', '_'), '_', CONCAT('MOD', pi.progim), :findf4) AS flima1,
          '' AS flima2,
          '' AS flima3
          FROM tipolo tp
          INNER JOIN anaart ar ON tp.cdartn = ar.cdartn
          INNER JOIN ctarti ca ON ar.cdarti = ca.cdarti
          JOIN (SELECT 2 AS progim UNION SELECT 3 UNION SELECT 4 UNION SELECT 5 UNION SELECT 6 UNION SELECT 7 UNION SELECT 8 UNION SELECT 9 UNION SELECT 10 UNION SELECT 11 UNION SELECT 12) AS pi
          LEFT JOIN imgart ia ON ia.tpimag = CONCAT('MOD', pi.progim) AND ia.codic1 = tp.cdartn AND ia.codic2 = '' AND ia.seqrap = 0
          WHERE ca.cdcata = :cdcata " . ($reassign ? '' : " AND ISNULL(ia.tpimag) ");
        break;
      case 5:
        $params = array('cdcata' => $cdcata, 'findf5' => '.jpg');
        $query = "SELECT DISTINCT 5 AS sequen, 'imgart' AS tablen, 'tpimag' AS fieldn, 'codic1' AS field2,
          CONCAT('AR', LPAD(pi.progim, 2, '0')) AS keynam, ar.cdarti AS keyna2, '' AS keyna3,
          CONCAT(REPLACE(ar.cdarti, ' ', '_'), '_', CONCAT('AR', LPAD(pi.progim, 2, '0')), :findf5) AS flima1,
          CONCAT(REPLACE(ar.cdarti, ' ', '_'), '_', CONCAT('MOD', pi.progim), :findf5) AS flima2,
          '' AS flima3
          FROM ctarti ca
          INNER JOIN anaart ar ON ar.cdarti = ca.cdarti
          INNER JOIN tipolo tp ON tp.cdartn = ar.cdartn
          JOIN (SELECT 2 AS progim UNION SELECT 3 UNION SELECT 4 UNION SELECT 5 UNION SELECT 6 UNION SELECT 7 UNION SELECT 8 UNION SELECT 9 UNION SELECT 10 UNION SELECT 11 UNION SELECT 12) AS pi
          LEFT JOIN imgart ia ON ia.tpimag = CONCAT('AR',LPAD(pi.progim, 2, '0')) AND ia.codic1 = ar.cdarti AND ia.codic2 = '' AND ia.seqrap = 0
          WHERE ca.cdcata = :cdcata " . ($reassign ? '' : " AND ISNULL(ia.tpimag) ");
        break;
      case 6:
        $params = array('cdcata' => $cdcata, 'findf6' => '.jpg');
        $query = "SELECT DISTINCT 6 AS sequen, 'imgart' AS tablen, 'tpimag' AS fieldn, 'codic1' AS field2,
          CONCAT('AC', LPAD(pi.progim, 2, '0')) AS keynam, ar.cdarti AS keyna2, ac.cdcolo AS keyna3,
          CONCAT(REPLACE(ar.cdarti, ' ', '_'), '_', ac.cdcolo, '_', CONCAT('AC', LPAD(pi.progim, 2, '0')), :findf6) AS flima1,
          '' AS flima2,
          '' AS flima3
          FROM artcol ac
          INNER JOIN anaart ar ON ar.cdarti = ac.cdarti
          INNER JOIN ctarti ca ON ca.cdarti = ar.cdarti
          JOIN (SELECT 2 AS progim UNION SELECT 3 UNION SELECT 4 UNION SELECT 5 UNION SELECT 6 UNION SELECT 7 UNION SELECT 8 UNION SELECT 9 UNION SELECT 10 UNION SELECT 11 UNION SELECT 12) AS pi
          LEFT JOIN imgart ia ON ia.tpimag = CONCAT('AC',LPAD(pi.progim, 2, '0')) AND ia.codic1 = ar.cdarti AND ia.codic2 = ac.cdcolo AND ia.seqrap = 0
          WHERE ca.cdcata = :cdcata AND ac.cdcolo != '' " . ($reassign ? '' : " AND ISNULL(ia.tpimag) ");
        break;
    }

/*
    $query = "SELECT DISTINCT 0 AS sequen, 'tipolo' AS tablen, 'cdartn' AS fieldn, '' AS field2,
      tp.cdartn AS keynam, '' AS keyna2, '' AS keyna3,
      CONCAT(REPLACE(tp.cdartn, ' ', '_'), :findf0) AS flima1,
      '' AS flima2,
      '' AS flima3
      FROM tipolo tp
      INNER JOIN anaart ar ON tp.cdartn = ar.cdartn
      INNER JOIN ctarti ca ON ar.cdarti = ca.cdarti
      WHERE ca.cdcata = :cdcata $andWhereTp
      UNION
      SELECT DISTINCT 1 AS sequen, 'anaart' AS tablen, 'cdarti' AS fieldn, '' AS field2,
      ar.cdarti AS keynam, '' AS keyna2, '' AS keyna3,
      CONCAT(REPLACE(ar.cdarti, ' ', '_'), :findf1) AS flima1,
      IF(ar.cdpers > '', CONCAT(REPLACE(ar.cdpers, ' ', '_'), :findf1),'') AS flima2,
      '' as flima3
      FROM anaart ar
      INNER JOIN ctarti ca ON ar.cdarti = ca.cdarti
      WHERE ca.cdcata = :cdcata $andWhereAr
      UNION
      SELECT DISTINCT 2 AS sequen, 'anaper' AS tablen, 'cdpers' AS fieldn, '' AS field2,
      ar.cdpers AS keynam, '' AS keyna2, '' AS keyna3,
      CONCAT(REPLACE(ar.cdpers, ' ', '_'), :findf2) AS flima1,
      '' as flima2,
      '' as flima3
      FROM ctarti ca
      INNER JOIN anaart ar ON ar.cdarti = ca.cdarti
      INNER JOIN anaper ap ON ap.cdpers = ar.cdpers
      WHERE ca.cdcata = :cdcata AND ar.cdpers > '' $andWhereAp
      UNION
      SELECT DISTINCT 3 AS sequen, 'artcol' as tablen, 'cdarti' as fieldn, 'cdcolo' as field2,
      ar.cdarti as keynam, ac.cdcolo as keyna2, '' AS keyna3,
      CONCAT(REPLACE(ar.cdarti, ' ', '_'), '_', REPLACE(ac.cdcolo, ' ', '_'), :findf3) AS flima1,
      CONCAT(REPLACE(ar.cdpers, ' ', '_'), '_', REPLACE(ac.cdcolo, ' ', '_'), :findf3) AS flima2,
      '' AS flima3
      FROM artcol ac
      INNER JOIN anaart ar ON ar.cdarti = ac.cdarti
      INNER JOIN anaper ap ON ap.cdpers = ar.cdpers
      INNER JOIN ctarti ca ON ca.cdarti = ar.cdarti
      WHERE ca.cdcata = :cdcata $andWhereAc
      UNION
      SELECT DISTINCT 4 AS sequen, 'imgart' AS tablen, 'tpimag' AS fieldn, 'codic1' AS field2,
      CONCAT('MOD', pi.progim) AS keynam, tp.cdartn AS keyna2, '' AS keyna3,
      CONCAT(REPLACE(tp.cdartn, ' ', '_'), '_', CONCAT('MOD', pi.progim), :findf4) AS flima1,
      '' AS flima2,
      '' AS flima3
      FROM tipolo tp
      INNER JOIN anaart ar ON tp.cdartn = ar.cdartn
      INNER JOIN ctarti ca ON ar.cdarti = ca.cdarti
      JOIN (SELECT 2 AS progim UNION SELECT 3 UNION SELECT 4 UNION SELECT 5 UNION SELECT 6 UNION SELECT 7 UNION SELECT 8 UNION SELECT 8 UNION SELECT 9) AS pi
      LEFT JOIN imgart ia ON ia.tpimag = CONCAT('MOD', pi.progim) AND ia.codic1 = tp.cdartn AND ia.codic2 = '' AND ia.seqrap = 0
      WHERE ca.cdcata = :cdcata $andWhereIm
      UNION
      SELECT DISTINCT 5 AS sequen, 'imgart' AS tablen, 'tpimag' AS fieldn, 'codic1' AS field2,
      CONCAT('AR', LPAD(pi.progim, 2, '0')) AS keynam, ar.cdarti AS keyna2, '' AS keyna3,
      CONCAT(REPLACE(ar.cdarti, ' ', '_'), '_', CONCAT('AR', LPAD(pi.progim, 2, '0')), :findf5) AS flima1,
      CONCAT(REPLACE(ar.cdarti, ' ', '_'), '_', CONCAT('MOD', pi.progim), :findf5) AS flima2,
      '' AS flima3
      FROM ctarti ca
      INNER JOIN anaart ar ON ar.cdarti = ca.cdarti
      INNER JOIN tipolo tp ON tp.cdartn = ar.cdartn
      JOIN (SELECT 2 AS progim UNION SELECT 3 UNION SELECT 4 UNION SELECT 5) AS pi
      LEFT JOIN imgart ia ON ia.tpimag = CONCAT('AR',LPAD(pi.progim, 2, '0')) AND ia.codic1 = ar.cdarti AND ia.codic2 = '' AND ia.seqrap = 0
      WHERE ca.cdcata = :cdcata $andWhereIm
      UNION
      SELECT DISTINCT 6 AS sequen, 'imgart' AS tablen, 'tpimag' AS fieldn, 'codic1' AS field2,
      CONCAT('AC', LPAD(pi.progim, 2, '0')) AS keynam, ar.cdarti AS keyna2, ac.cdcolo AS keyna3,
      CONCAT(REPLACE(ar.cdarti, ' ', '_'), '_', ac.cdcolo, '_', CONCAT('AC', LPAD(pi.progim, 2, '0')), :findf6) AS flima1,
      '' AS flima2,
      '' AS flima3
      FROM artcol ac
      INNER JOIN anaart ar ON ar.cdarti = ac.cdarti
      INNER JOIN ctarti ca ON ca.cdarti = ar.cdarti
      JOIN (SELECT 2 AS progim UNION SELECT 3 UNION SELECT 4 UNION SELECT 5) AS pi
      LEFT JOIN imgart ia ON ia.tpimag = CONCAT('AC',LPAD(pi.progim, 2, '0')) AND ia.codic1 = ar.cdarti AND ia.codic2 = ac.cdcolo AND ia.seqrap = 0
      WHERE ca.cdcata = :cdcata AND ac.cdcolo != '' $andWhereIm
      ORDER BY `tablen` DESC
      LIMIT $limit $offset ";
      */

    return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function saveModelImage($i, $cdartn, $flimag) {
    $imgart = new self();
    $imgart->tpimag = 'MOD' . $i;
    $imgart->codic1 = $cdartn;
    $imgart->codic2 = new RawValue('');
    $imgart->seqrap = 0;
    $imgart->flimag = $flimag;
    $imgart->save();
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function saveArticleImage($i, $cdarti, $flimag) {
    $imgart = new self();
    $imgart->tpimag = 'AR' . ($i < 10 ? '0' . $i : $i);
    $imgart->codic1 = $cdarti;
    $imgart->codic2 = new RawValue('');
    $imgart->seqrap = 0;
    $imgart->flimag = $flimag;
    $imgart->save();
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function saveImageFromAutoProcess($tpimag, $cdartn, $flimag) {
    $params = array('tpimag' => $tpimag, 'codic1' => $cdartn, 'flimag' => $flimag);
    $query = "INSERT INTO imgart (tpimag, codic1, codic2, seqrap, flimag)
      VALUES (:tpimag, :codic1, '', 0, :flimag)
      ON DUPLICATE KEY UPDATE flimag = :flimag";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   REPLACE
   * Return:  void
   */
  public static function updateImage($tpimag, $codic1, $flimag, $codic2 = '') {
    $params = array('tpimag' => $tpimag, 'codic1' => $codic1, 'flimag' => $flimag, 'codic2' => $codic2);
    $query = "REPLACE INTO imgart
      VALUES (:tpimag, :codic1, :codic2, 0, :flimag)";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllImagesForModel($cdartn) {
    $query = 'DELETE i.*
      FROM imgart i
      WHERE i.tpimag LIKE "M%" AND i.codic1 = :cdartn';
    Di::getDefault()->get('db')->query($query, array('cdartn' => $cdartn));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllImagesForArticle($cdarti) {
    $query = 'DELETE i.*
      FROM imgart i
      WHERE i.tpimag LIKE "AR%" AND i.codic1 = :cdarti';
    Di::getDefault()->get('db')->query($query, array('cdarti' => $cdarti));
  }

  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function emptyTable() {
    $query = "TRUNCATE imgart";
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
