<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Gopart extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $nurpar;

  /**
   *
   * @var string
   * @Column(type="string", length=2, nullable=false)
   */
  public $tpanag;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdanag;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;

  /**
   *
   * @var string
   * @Column(type="string", length=10, nullable=false)
   */
  public $tipdoc;

  /**
   *
   * @var string
   * @Column(type="string", length=20, nullable=false)
   */
  public $numdoc;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $datdoc;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $impdoc;

  /**
   *
   * @var string
   * @Column(type="string", length=4, nullable=false)
   */
  public $tipsca;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $datsca;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $impsca;

  /**
   *
   * @var string
   * @Column(type="string", length=20, nullable=false)
   */
  public $des_it;

  /**
   *
   * @var string
   * @Column(type="string", length=20, nullable=false)
   */
  public $des_en;

  /**
   *
   * @var string
   * @Column(type="string", length=20, nullable=false)
   */
  public $des_fr;

  /**
   *
   * @var string
   * @Column(type="string", length=20, nullable=false)
   */
  public $des_es;

  /**
   *
   * @var string
   * @Column(type="string", length=20, nullable=false)
   */
  public $des_de;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $notpar;

  /**
   *
   * @var string
   * @Column(type="string", length=4, nullable=false)
   */
  public $valuta;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $despag;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('gopart');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'nurpar' => isset($rec->nurpar) && (string)$rec->nurpar !== '' ? (string)$rec->nurpar : 0,
      'tpanag' => isset($rec->tpanag) && (string)$rec->tpanag !== '' ? (string)$rec->tpanag : new RawValue('""'),
      'cdanag' => isset($rec->cdanag) && (string)$rec->cdanag !== '' ? (string)$rec->cdanag : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0,
      'tipdoc' => isset($rec->tipdoc) && (string)$rec->tipdoc !== '' ? (string)$rec->tipdoc : new RawValue('""'),
      'numdoc' => isset($rec->numdoc) && (string)$rec->numdoc !== '' ? (string)$rec->numdoc : new RawValue('""'),
      'datdoc' => isset($rec->datdoc) && (string)$rec->datdoc !== '' ? (string)$rec->datdoc : '0000-00-00',
      'impdoc' => isset($rec->impdoc) && (string)$rec->impdoc !== '' ? (string)$rec->impdoc : 0,
      'tipsca' => isset($rec->tipsca) && (string)$rec->tipsca !== '' ? (string)$rec->tipsca : new RawValue('""'),
      'datsca' => isset($rec->datsca) && (string)$rec->datsca !== '' ? (string)$rec->datsca : '0000-00-00',
      'impsca' => isset($rec->impsca) && (string)$rec->impsca !== '' ? (string)$rec->impsca : 0,
      'des_it' => isset($rec->des_it) && (string)$rec->des_it !== '' ? (string)$rec->des_it : new RawValue('""'),
      'des_en' => isset($rec->des_en) && (string)$rec->des_en !== '' ? (string)$rec->des_en : new RawValue('""'),
      'des_fr' => isset($rec->des_fr) && (string)$rec->des_fr !== '' ? (string)$rec->des_fr : new RawValue('""'),
      'des_es' => isset($rec->des_es) && (string)$rec->des_es !== '' ? (string)$rec->des_es : new RawValue('""'),
      'des_de' => isset($rec->des_de) && (string)$rec->des_de !== '' ? (string)$rec->des_de : new RawValue('""'),
      'notpar' => isset($rec->notpar) && (string)$rec->notpar !== '' ? (string)$rec->notpar : new RawValue('""'),
      'valuta' => isset($rec->valuta) && (string)$rec->valuta !== '' ? (string)$rec->valuta : new RawValue('""')
    );

    $query  = 'nurpar = :nurpar:';
    $params = array(
      'nurpar' => $values['nurpar']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Gopart objects
   */
  public static function getDeadlinesForCustomer($tpanag, $cdanag) {
    $query = "SELECT g.nurpar, g.tpanag, g.cdanag, g.seqrap, g.tipdoc, g.numdoc,
      DATE_FORMAT(g.datdoc, '%d/%m/%Y') AS datdoc, g.impdoc, g.tipsca,
      g.datsca AS ord_datsca, DATE_FORMAT(g.datsca, '%d/%m/%Y') AS datsca,
      g.impsca, g.des_it, g.des_en, g.des_fr, g.des_es, g.des_de,
      g.notpar, g.valuta, g.despag, DATEDIFF(CURRENT_DATE(), g.datsca) AS expired
      FROM Go2B\Models\Gopart g
      WHERE g.tpanag = :tpanag: AND g.cdanag = :cdanag:
      ORDER BY g.numdoc, ord_datsca";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('tpanag' => $tpanag, 'cdanag' => $cdanag));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Gopart objects
   */
  public static function getMinimalDeadlinesForCustomer($tpanag, $cdanag) {
    $query = 'SELECT DISTINCT g.numdoc, g.impdoc, a.descri
      FROM Go2B\Models\Gopart g
      INNER JOIN Go2B\Models\Anagra a ON a.tpanag = g.tpanag AND a.cdanag = g.cdanag
      WHERE g.tpanag = :tpanag: AND g.cdanag = :cdanag:';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('tpanag' => $tpanag, 'cdanag' => $cdanag));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Gopart objects
   */
  public static function getValuesDeadlinesForCustomer($tpanag, $cdanag) {
    $query = 'SELECT g.impsca, DATEDIFF(CURRENT_DATE(), g.datsca) AS expired
      FROM Go2B\Models\Gopart g
      WHERE g.tpanag = :tpanag: AND g.cdanag = :cdanag:';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('tpanag' => $tpanag, 'cdanag' => $cdanag));
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateCustomerCode($oldcode, $cdanag) {
    $query = 'UPDATE gopart g
      INNER JOIN anagra a ON a.tpanag = g.tpanag AND a.cdanag = g.cdanag
      SET g.tpanag = "CL", g.cdanag = :cdanag
      WHERE g.tpanag = "CN" AND g.cdanag = :oldcode AND a.cdblco = 0';
    Di::getDefault()->get('db')->query($query, array('cdanag' => $cdanag, 'oldcode' => $oldcode));
  }
  //endregion
}
