<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Dscorp extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdarti;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdcolo;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdvari;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdasso;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $taglia;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", nullable=false)
   */
  public $dtdisp;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $quanti;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('dscorp');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdarti' => isset($rec->cdarti) && (string)$rec->cdarti !== '' ? (string)$rec->cdarti : new RawValue('""'),
      'cdcolo' => isset($rec->cdcolo) && (string)$rec->cdcolo !== '' ? (string)$rec->cdcolo : new RawValue('""'),
      'cdvari' => isset($rec->cdvari) && (string)$rec->cdvari !== '' ? (string)$rec->cdvari : new RawValue('""'),
      'cdasso' => isset($rec->cdasso) && (string)$rec->cdasso !== '' ? (string)$rec->cdasso : new RawValue('""'),
      'taglia' => isset($rec->taglia) && (string)$rec->taglia !== '' ? (string)$rec->taglia : new RawValue('""'),
      'dtdisp' => isset($rec->dtdisp) && (string)$rec->dtdisp !== '' ? (string)$rec->dtdisp : '0000-00-00',
      'quanti' => isset($rec->quanti) && (string)$rec->quanti !== '' ? (string)$rec->quanti : 0
    );

    $query  = 'cdarti = :cdarti: AND cdcolo = :cdcolo: AND cdvari = :cdvari: AND cdasso = :cdasso: AND taglia = :taglia: AND dtdisp = :dtdisp:';
    $params = array(
      'cdarti' => $values['cdarti'],
      'cdcolo' => $values['cdcolo'],
      'cdvari' => $values['cdvari'],
      'cdasso' => $values['cdasso'],
      'taglia' => $values['taglia'],
      'dtdisp' => $values['dtdisp']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Aux functions
  /**
   * Subquery to get used quantity on orders
   */
  private static function getCurrentQuantityToSubtract() {
    return
      'SELECT SUM(og.quanti)
      FROM Go2B\Models\Octagl og
      INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
      INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
      WHERE oc.cdarti = dc.cdarti AND ot.flstat = 2 AND og.dstagl = dc.taglia';
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Dscorp objects
   */
  public static function getArticleAvailabilityForOrderList($nurorc) {
    $qtyToSubtract = self::getCurrentQuantityToSubtract();
    $query = "SELECT COALESCE(dc.quanti, 0) AS quant1, COALESCE( ($qtyToSubtract), 0) AS quant2, tg.quanti AS quant3
      FROM Go2B\Models\Dscorp dc
      INNER JOIN Go2B\Models\Occorp cp ON cp.cdarti = dc.cdarti
      INNER JOIN Go2B\Models\Octagl tg ON cp.nurorc = tg.nurorc AND tg.dstagl = dc.taglia
      WHERE cp.nurorc = :nurorc: AND tg.quanti > 0";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('nurorc' => $nurorc));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Dscorp objects
   */
  public static function getColorVariantArticleAvailabilityForOrderList($nurorc) {
    $query = 'SELECT (
      COALESCE(dc.quanti -
        COALESCE(
          (SELECT SUM(og.quanti)
          FROM Go2B\Models\Octagl og
          INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
          INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
          WHERE oc.cdarti = dc.cdarti AND oc.cdcolo = dc.cdcolo AND oc.cdvari = dc.cdvari AND ot.flstat = 2 AND og.dstagl = dc.taglia), 0),
        0) - tg.quanti) AS quanti_c
      FROM Go2B\Models\Dscorp dc
      INNER JOIN Go2B\Models\Occorp cp ON cp.cdarti = dc.cdarti AND cp.cdcolo = dc.cdcolo AND cp.cdvari = dc.cdvari
      INNER JOIN Go2B\Models\Octagl tg ON cp.nurorc = tg.nurorc AND tg.dstagl = dc.taglia
      WHERE cp.nurorc = :nurorc: AND tg.quanti > 0';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('nurorc' => $nurorc));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Dscorp arrays
   */
  public static function getArticleAvailability($cdarti) {
    $query = "SELECT dc1.taglia AS item, dc1.dtdisp AS dtdisp, COALESCE(dc1.quanti -
      COALESCE(
        (SELECT SUM(og1.quanti)
        FROM octagl og1
        INNER JOIN occorp oc1 ON oc1.nurorc = og1.nurorc
        INNER JOIN octest ot1 ON ot1.nuordc = oc1.nuordc
        WHERE oc1.cdarti = dc1.cdarti AND ot1.flstat = 2 AND og1.dstagl = dc1.taglia),
        0),
      0) AS quanti, 0 AS isasso
      FROM dscorp dc1
      WHERE dc1.cdarti = :cdarti AND dc1.cdasso = ''
      UNION
      SELECT dc2.cdasso AS item, dc2.dtdisp AS dtdisp, COALESCE(dc2.quanti -
      COALESCE(
        (SELECT SUM(oa2.quanti)
        FROM ocasso oa2
        INNER JOIN occorp oc2 ON oc2.nurorc = oa2.nurorc
        INNER JOIN octest ot2 ON ot2.nuordc = oc2.nuordc
        WHERE oa2.cdasso = dc2.cdasso AND ot2.flstat = 2 AND oa2.cdasso = dc2.cdasso),
        0),
      0) AS quanti, 1 AS isasso
      FROM dscorp dc2
      WHERE dc2.cdarti = :cdarti AND dc2.cdasso != ''
      ORDER BY dtdisp, isasso, item";
    $params = array('cdarti' => (string)$cdarti);
    return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Dscorp objects
   */
  public static function getColorAvailability($cdarti, $cdcolo, $cdtagl) {
    $query = "SELECT dc.cdvari, dc.taglia, dc.dtdisp, COALESCE(dc.quanti -
        COALESCE(
         (SELECT SUM(og.quanti)
          FROM Go2B\Models\Octagl og
          INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
          INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
          WHERE oc.cdarti = dc.cdarti AND oc.cdcolo = dc.cdcolo AND ot.flstat = 2 AND og.dstagl = dc.taglia),
          0),
        0
      ) AS quanti
      FROM Go2B\Models\Dscorp dc
      INNER JOIN Go2B\Models\Postgl pt ON dc.taglia = pt.taglia
      WHERE dc.cdarti = :cdarti: AND dc.cdcolo = :cdcolo: AND pt.cdtagl = :cdtagl:
      ORDER BY dc.cdvari, dc.dtdisp, pt.postgl";

    $params = array('cdarti' => $cdarti, 'cdcolo' => $cdcolo, 'cdtagl' => $cdtagl);

    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Dscorp arrays
   */
  public static function getArticleAvailabilityForArticle($article) {
    $query = "SELECT dc1.taglia AS item, dc1.dtdisp AS dtdisp, COALESCE(dc1.quanti -
        (SELECT COALESCE(SUM(og1.quanti), 0)
        FROM octagl og1
        INNER JOIN occorp oc1 ON oc1.nurorc = og1.nurorc
        INNER JOIN octest ot1 ON ot1.nuordc = oc1.nuordc
        WHERE oc1.cdarti = dc1.cdarti AND ot1.flstat = 2 AND og1.dstagl = dc1.taglia),
      0) AS quanti, 0 AS isasso
      FROM dscorp dc1
      WHERE dc1.cdarti = :cdarti AND dc1.cdasso = ''
      UNION
      SELECT dc2.cdasso AS item, dc2.dtdisp AS dtdisp, COALESCE(dc2.quanti -
        (SELECT COALESCE(SUM(oa2.quanti), 0)
        FROM ocasso oa2
        INNER JOIN occorp oc2 ON oc2.nurorc = oa2.nurorc
        INNER JOIN octest ot2 ON ot2.nuordc = oc2.nuordc
        WHERE oc2.cdarti = dc2.cdarti AND ot2.flstat = 2 AND oa2.cdasso = dc2.cdasso),
      0) AS quanti, 1 AS isasso
      FROM dscorp dc2
      WHERE dc2.cdarti = :cdarti AND dc2.cdasso != ''
      GROUP BY dtdisp
      ORDER BY dtdisp, isasso, item";

    $params = array('cdarti' => $article->cdarti);
    return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Dscorp objects
   */
  public static function getArticleAvailabilities($cdarti) {
    $query = "SELECT COALESCE(
      (dc.quanti -
        COALESCE(
          (SELECT SUM(og.quanti)
          FROM Go2B\Models\Octagl og
          INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
          INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
          WHERE oc.cdarti = dc.cdarti AND ot.flstat = 2 AND og.dstagl = dc.taglia),
          0)),
      0) AS quanti
      FROM Go2B\Models\Dscorp dc
      WHERE dc.cdarti = :cdarti:";

    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdarti' => $cdarti));
  }

    /**
     * Query:   SELECT
     * Return:  Array of Dscorp objects
     */
    public static function getArticleAvailabilityForSizes($cdarti) {
        $query = "SELECT dc.taglia, COALESCE(
      (dc.quanti -
        COALESCE(
          (SELECT SUM(og.quanti)
          FROM Go2B\Models\Octagl og
          INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
          INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
          WHERE oc.cdarti = dc.cdarti AND ot.flstat = 2 AND og.dstagl = dc.taglia),
          0)),
      0) AS quanti
      FROM Go2B\Models\Dscorp dc
      WHERE dc.cdarti = :cdarti:";

        $data = Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdarti' => $cdarti))->toArray();
        return array_column($data, 'quanti', 'taglia');
    }

  /**
   * Query:   SELECT
   * Return:  Array of Dscorp objects
   */
  public static function getColorAvailabilityForArticle($article) {
    $query = "SELECT dc1.taglia AS item, dc1.dtdisp AS dtdisp, COALESCE(dc1.quanti -
        (SELECT COALESCE(SUM(og1.quanti), 0)
        FROM octagl og1
        INNER JOIN occorp oc1 ON oc1.nurorc = og1.nurorc
        INNER JOIN octest ot1 ON ot1.nuordc = oc1.nuordc
        WHERE oc1.cdarti = dc1.cdarti AND oc1.cdcolo = dc1.cdcolo
        AND oc1.cdvari = dc1.cdvari AND ot1.flstat = 2 AND og1.dstagl = dc1.taglia),
      0) AS quanti, 0 AS isasso
      FROM dscorp dc1
      WHERE dc1.cdarti = :cdarti AND dc1.cdcolo = :cdcolo AND dc1.cdvari = :cdvari AND dc1.cdasso = ''
      UNION
      SELECT dc2.cdasso AS item, dc2.dtdisp AS dtdisp, COALESCE(dc2.quanti -
        (SELECT COALESCE(SUM(oa2.quanti), 0)
        FROM ocasso oa2
        INNER JOIN occorp oc2 ON oc2.nurorc = oa2.nurorc
        INNER JOIN octest ot2 ON ot2.nuordc = oc2.nuordc
        WHERE oc2.cdarti = dc2.cdarti AND oc2.cdcolo = dc2.cdcolo
        AND oc2.cdvari = dc2.cdvari AND ot2.flstat = 2 AND oa2.cdasso = dc2.cdasso),
      0) AS quanti, 1 AS isasso
      FROM dscorp dc2
      WHERE dc2.cdarti = :cdarti AND dc2.cdcolo = :cdcolo  AND dc2.cdvari = :cdvari AND dc2.cdasso != ''
      GROUP BY dtdisp
      ORDER BY dtdisp, isasso, item";

    $params = array(
      'cdarti' => $article->cdarti,
      'cdcolo' => $article->cdcolo_v,
      'cdvari' => $article->cdvari
    );
    return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Dscorp objects
   */
  public static function getArticlesWithAvailability($cdcata) {
    $query = "SELECT dc.cdarti, aa.dsarti, tp.cdtagl, dc.quanti
      FROM Go2B\Models\Dscorp dc
      INNER JOIN Go2B\Models\Anaart aa ON dc.cdarti = aa.cdarti
      INNER JOIN Go2B\Models\Ctarti ca ON ca.cdarti = aa.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON aa.cdartn = tp.cdartn
      WHERE ca.cdcata = :cdcata: AND dc.cdasso = ''
      GROUP BY dc.cdarti";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdcata' => $cdcata));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Dscorp objects
   */
  public static function getAssortmentAvailabilityForArticle($cdarti) {
    $query = "SELECT dc.cdasso, dc.quanti
      FROM Go2B\Models\Dscorp dc
      WHERE dc.cdarti = :cdarti: AND dc.cdasso != '' ";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdarti' => $cdarti));
  }

  /**
   * Query:   SELECT
   * Return:  Dscorp object
   */
  public static function getMaxArticleAvailability($cdarti) {
    $qtyToSubtract = self::getCurrentQuantityToSubtract();
    $query = "SELECT COALESCE(
        MAX( dc.quanti - COALESCE( ($qtyToSubtract), 0 ) ),
      0) AS quanti
      FROM Go2B\Models\Dscorp dc
      WHERE dc.cdarti = :cdarti:";

    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdarti' => $cdarti))[0];
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertArticleAvailability($cdarti, $taglia, $quanti) {
    $params = array( 'cdarti' => $cdarti, 'taglia' => $taglia, 'dtoggi' => date('Y-m-d'), 'quanti' => $quanti);
    $query = "INSERT INTO dscorp (cdarti, cdcolo, cdvari, cdasso, taglia, dtdisp, quanti)
      VALUES (:cdarti, '', '', '', :taglia, :dtoggi, :quanti)";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertArticleAssortmentAvailability($cdarti, $cdasso, $quanti) {
    $params = array( 'cdarti' => $cdarti, 'cdasso' => $cdasso, 'dtoggi' => date('Y-m-d'), 'quanti' => $quanti);
    $query = "INSERT INTO dscorp (cdarti, cdcolo, cdvari, cdasso, taglia, dtdisp, quanti)
      VALUES (:cdarti, '', '', :cdasso, '', :dtoggi, :quanti)";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteArticleAvailabity($cdarti) {
    $params = array('cdarti' => $cdarti);
    $query = "DELETE d.*
      FROM dscorp d
      WHERE d.cdarti = :cdarti";
    Di::getDefault()->get('db')->query($query, $params);
  }
  //endregion
}
