<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Desart extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=2, nullable=false)
   */
  public $tpinpu;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $codice;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=4, nullable=false)
   */
  public $tpdesc;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=2, nullable=false)
   */
  public $idlang;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $descri;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('desart');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'tpinpu' => isset($rec->tpinpu) && (string)$rec->tpinpu !== '' ? (string)$rec->tpinpu : new RawValue('""'),
      'codice' => isset($rec->codice) && (string)$rec->codice !== '' ? (string)$rec->codice : new RawValue('""'),
      'tpdesc' => isset($rec->tpdesc) && (string)$rec->tpdesc !== '' ? (string)$rec->tpdesc : new RawValue('""'),
      'idlang' => isset($rec->idlang) && (string)$rec->idlang !== '' ? (string)$rec->idlang : new RawValue('""'),
      'descri' => isset($rec->descri) && (string)$rec->descri !== '' ? (string)$rec->descri : new RawValue('""')
    );

    $query  = 'tpinpu = :tpinpu: AND codice = :codice: AND tpdesc = :tpdesc: AND idlang = :idlang:';
    $params = array(
      'tpinpu' => $values['tpinpu'],
      'codice' => $values['codice'],
      'tpdesc' => $values['tpdesc'],
      'idlang' => $values['idlang']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  public static function saveModelDescription($cdartn, $type, $lang, $text) {
    $desart = new self();
    $desart->tpinpu = 'AN';
    $desart->codice = $cdartn;
    $desart->tpdesc = $type;
    $desart->idlang = strtoupper($lang);
    $desart->descri = $text;
    $desart->save();
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertOrReplaceDescription($itemType, $code, $descriptionType, $lang, $description) {
    $params = array(
      'tpinpu' => $itemType,
      'codice' => $code,
      'tpdesc' => $descriptionType,
      'idlang' => strtoupper($lang),
      'descri' => $description
    );
    $query = "REPLACE INTO desart (tpinpu, codice, tpdesc, idlang, descri)
      VALUES (:tpinpu, :codice, :tpdesc, :idlang, :descri)";
    Di::getDefault()->get('db')->query($query, $params);
  }
  
  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function importDescriTipolo($cdartn, $descri) {
    $params = array('cdartn' => $cdartn);
    foreach ( $descri AS $idlang => $des ) {
      if ($des != '') {
        $params['idlang'] = $idlang;
        $params['descri'] = $des;

        $query = "INSERT INTO desart(tpinpu, codice, tpdesc, idlang, descri)
          VALUES('AN', :cdartn, 'COMM', :idlang, :descri) ON DUPLICATE KEY
          UPDATE descri = :descri";
        Di::getDefault()->get('db')->query($query, $params);
      }
    }
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteDescription($itemType, $code, $descriptionType, $lang) {
    $params = array(
      'tpinpu' => $itemType,
      'codice' => $code,
      'tpdesc' => $descriptionType,
      'idlang' => strtoupper($lang),
    );
    $query = "DELETE d.*
      FROM desart d
      WHERE d.tpinpu = :tpinpu AND d.codice = :codice AND d.tpdesc = :tpdesc AND d.idlang = :idlang";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllDescriptionsForModel($cdartn) {
    $query = "DELETE d.*
      FROM desart d
      WHERE d.tpinpu = 'AN' AND d.codice = :cdartn";
    Di::getDefault()->get('db')->query($query, array('cdartn' => $cdartn));
  }

  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function emptyTable() {
    $query = "TRUNCATE desart";
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
