<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Cttest extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdcata;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dscata;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $dtiniz;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $dtfine;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $flescl;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $cdregv;

  /**
   *
   * @var string
   * @Column(type="string", length=4, nullable=false)
   */
  public $cdstag;

  /**
   *
   * @var integer
   * @Column(type="integer", length=2, nullable=false)
   */
  public $fltipo;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('cttest');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdcata' => isset($rec->cdcata) && (string)$rec->cdcata !== '' ? (string)$rec->cdcata : new RawValue('""'),
      'dscata' => isset($rec->dscata) && (string)$rec->dscata !== '' ? (string)$rec->dscata : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0,
      'dtiniz' => isset($rec->dtiniz) && (string)$rec->dtiniz !== '' ? (string)$rec->dtiniz : '0000-00-00',
      'dtfine' => isset($rec->dtfine) && (string)$rec->dtfine !== '' ? (string)$rec->dtfine : '0000-00-00',
      'flescl' => isset($rec->flescl) && (string)$rec->flescl !== '' ? (string)$rec->flescl : 0,
      'cdregv' => isset($rec->cdregv) && (string)$rec->cdregv !== '' ? (string)$rec->cdregv : 0,
      'cdstag' => isset($rec->cdstag) && (string)$rec->cdstag !== '' ? (string)$rec->cdstag : new RawValue('""'),
      'fltipo' => isset($rec->fltipo) && (string)$rec->fltipo !== '' ? (string)$rec->fltipo : 0
    );

    $query  = 'cdcata = :cdcata:';
    $params = array(
      'cdcata' => $values['cdcata']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Cttest objects
   */
  public static function getAllCatalogs() {
    $query = 'SELECT c.cdcata, c.dscata, c.seqrap,
      DATE_FORMAT(c.dtiniz, "%d/%m/%Y") AS dtiniz,
      DATE_FORMAT(c.dtfine, "%d/%m/%Y") AS dtfine, c.flescl
      FROM Go2B\Models\Cttest c
      ORDER BY c.cdcata';
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Cttest objects
   */
  public static function getAllCatalogsForUser($id_usr) {
    $query = 'SELECT DISTINCT c.cdcata, c.dscata
      FROM Go2B\Models\Cttest c
      INNER JOIN Go2B\Models\B2bUsrctl u ON u.cdcata = c.cdcata
      WHERE id_usr = :id_usr:
      ORDER BY c.cdcata';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('id_usr' => $id_usr));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Cttest objects
   */
  public static function getCatalogForUser($id_usr) {
    $query = "SELECT c.cdcata, c.dscata, c.seqrap,
      DATE_FORMAT(c.dtiniz, '%d/%m/%Y') AS dtiniz,
      DATE_FORMAT(c.dtfine, '%d/%m/%Y') AS dtfine, c.flescl, c.fltipo
      FROM Go2B\Models\Cttest c
      INNER JOIN Go2B\Models\B2bUsrctl u ON u.cdcata = c.cdcata
      WHERE u.id_usr = :idusr:
      AND (
        (c.dtiniz <= CURRENT_DATE() AND c.dtfine >= CURRENT_DATE())
        OR c.dtiniz = '0000-00-00'
        OR c.dtfine = '0000-00-00')
      ORDER BY c.seqrap, c.cdcata";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('idusr' => $id_usr));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Cttest objects
   */
  public static function getAllAvailableCatalogs() {
    $query = 'SELECT c.cdcata, c.dscata
      FROM Go2B\Models\Cttest c
      WHERE c.dtiniz <= CURRENT_DATE() AND c.dtfine >= CURRENT_DATE()
      ORDER BY c.cdcata';
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Cttest objects
   */
  public static function getAllMinimalCatalogs() {
    $query = 'SELECT c.cdcata, c.dscata, c.cdcata AS code, c.dscata AS description
      FROM Go2B\Models\Cttest c
      ORDER BY c.dscata';
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Cttest objects
   */
  public static function getAllCatalogsForAgent($cdagen) {
    $query = "SELECT uc.cdcata, ct.dscata
      FROM Go2B\Models\Cttest ct
      INNER JOIN Go2B\Models\B2bUsrctl uc ON uc.cdcata = ct.cdcata
      INNER JOIN Go2B\Models\B2bUsrage ua ON ua.id_usr = uc.id_usr
      INNER JOIN Go2B\Models\Anaage aa ON aa.cdagen = ua.cdagen
      WHERE aa.cdagen = :cdagen:";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdagen' => $cdagen));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Cttest objects
   */
  public static function getAllCatalogsForCustomer($tpanag, $cdanag) {
    $query = "SELECT uc.cdcata, ct.dscata
      FROM Go2B\Models\Cttest ct
      INNER JOIN Go2B\Models\B2bUsrctl uc ON uc.cdcata = ct.cdcata
      INNER JOIN Go2B\Models\B2bUsrana ua ON ua.id_usr = uc.id_usr
      INNER JOIN Go2B\Models\Anagra ag ON ag.tpanag = ua.tpanag AND ag.cdanag = ua.cdanag
      WHERE ag.tpanag = :tpanag: AND ag.cdanag = :cdanag:";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('tpanag' => $tpanag, 'cdanag' => $cdanag));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Cttest objects
   */
  public static function getAllCatalogsForShipping($cddesm) {
    $query = "SELECT uc.cdcata, ct.dscata
      FROM Go2B\Models\Desmer dm
      INNER JOIN Go2B\Models\B2bUsrdsm ud ON dm.cddesm = ud.cddesm
      INNER JOIN Go2B\Models\B2bUsrctl uc ON ud.id_usr = uc.id_usr
      INNER JOIN Go2B\Models\Cttest ct ON uc.cdcata = ct.cdcata
      WHERE dm.cddesm = :cddesm:";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cddesm' => $cddesm));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Cttest objects
   */
  public static function getCatalogsForCoupon($cdcoup) {
    $query = 'SELECT DISTINCT ct.dscata
      FROM Go2B\Models\Cttest ct
      INNER JOIN Go2B\Models\B2bCtlcpn cp ON ct.cdcata = cp.cdcoup
      WHERE cp.cdcoup = :cdcoup:';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdcoup' => $cdcoup));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Cttest objects
   */
  public static function getSortingCatalog($cdcata) {
    $query = 'SELECT DISTINCT ct.cdcata, ct.dscata, COALESCE(ai.valore, 0) AS seqrapType
      FROM Go2B\Models\Cttest ct
      LEFT JOIN Go2B\Models\B2bAddinf ai ON ai.tabell = "cttest" AND ai.codic1 = ct.cdcata AND ai.codic2 = "" AND ai.tpdato = "seqtip"
      WHERE ct.cdcata = :cdcata:';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdcata' => $cdcata))[0];
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function saveNewCatalog($cdcata, $dscata, $seqrap, $dtiniz, $dtfine, $cdstag = '') {
    $cttest = new self();
    $cttest->cdcata = $cdcata;
    $cttest->dscata = $dscata;
    $cttest->seqrap = $seqrap;
    $cttest->dtiniz = $dtiniz;
    $cttest->dtfine = $dtfine;
    $cttest->cdstag = $cdstag != '' ? $cdstag : new RawValue('""');
    $cttest->flescl = 0;
    $cttest->save();
  }

  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function emptyTable() {
    $query = "TRUNCATE cttest";
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
