<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Ctetic extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdcata;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdetic;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('ctetic');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec) {
    $values = array(
      'cdcata' => isset($rec->cdcata) && (string)$rec->cdcata !== '' ? (string)$rec->cdcata : new RawValue('""'),
      'cdetic' => isset($rec->cdetic) && (string)$rec->cdetic !== '' ? (string)$rec->cdetic : new RawValue('""')
    );

    // Always tipoagg = 'del'
    $row = new self();
    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Ctetic objects
   */
  public static function getLabelsByCatalog() {
    $query = 'SELECT c.cdcata, c.cdetic, a.dsetic
      FROM Go2B\Models\Ctetic c
      INNER JOIN Go2B\Models\Anaeti a ON a.cdetic = c.cdetic
      ORDER BY c.cdcata, c.cdetic';
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function emptyTable() {
    $query = "TRUNCATE ctetic";
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
