<?php

namespace Go2B\Models;

use Go2B\Controllers\Utility;
use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Ctarti extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdcata;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdarti;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('ctarti');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdcata' => isset($rec->cdcata) && (string)$rec->cdcata !== '' ? (string)$rec->cdcata : new RawValue('""'),
      'cdarti' => isset($rec->cdarti) && (string)$rec->cdarti !== '' ? (string)$rec->cdarti : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0
    );

    $query  = 'cdcata = :cdcata: AND cdarti = :cdarti:';
    $params = array(
      'cdcata' => $values['cdcata'],
      'cdarti' => $values['cdarti']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Ctarti objects
   */
  public static function getAllModelsFromCatalog($cdcata, $idlang) {
    if ($idlang != 'IT') {
      $dsartn = 'COALESCE(d1.descri,t.dsartn) AS dsartn';
      $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = t.cdartn AND d1.idlang = :idlang: ";
    } else {
      $dsartn = 't.dsartn AS dsartn';
      $lnJoin = '';
    }

    $query = "SELECT t.cdartn, $dsartn, IF(EXISTS(SELECT m.cdartn FROM Go2B\Models\B2bModevi m WHERE m.cdartn = t.cdartn AND m.cdcata = c.cdcata), 1, 0) AS exist
      FROM Go2B\Models\Ctarti c
      INNER JOIN Go2B\Models\Anaart a ON a.cdarti = c.cdarti
      INNER JOIN Go2B\Models\Tipolo t ON t.cdartn = a.cdartn
      $lnJoin
      WHERE c.cdcata = :cdcata:
      GROUP BY t.cdartn";

    $params = $idlang != 'IT'
      ? array('cdcata' => $cdcata, 'idlang' => $idlang)
      : array('cdcata' => $cdcata);

    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Ctarti objects
   */
  public static function getAllArticlesFromCatalog($cdcata, $idlang = 'IT') {
    if ($idlang != 'IT') {
      $dsarti = 'COALESCE(d1.descri,a.dsarti) AS dsarti';
      $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsarti' AND d1.codic1 = a.cdarti AND d1.idlang = :idlang: ";
      $params = array('cdcata' => $cdcata, 'idlang' => $idlang);
    } else {
      $dsarti = 'a.dsarti AS dsarti';
      $lnJoin = '';
      $params = array('cdcata' => $cdcata);
    }

    $query = "SELECT a.cdarti, $dsarti, IF(EXISTS(SELECT m.cdartn FROM Go2B\Models\B2bModevi m WHERE m.cdartn = a.cdarti AND m.cdcata = c.cdcata), 1, 0) AS exist
      FROM Go2B\Models\Ctarti c
      INNER JOIN Go2B\Models\Anaart a ON a.cdarti = c.cdarti
      $lnJoin
      WHERE c.cdcata = :cdcata:
      GROUP BY a.cdarti";

    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Ctarti objects
   */
  public static function getAllArtColFromCatalog($cdcata, $idlang = 'IT') {
    if ($idlang != 'IT') {
      $dsarti = 'COALESCE(d1.descri,a.dsarti) AS dsarti';
      $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsarti' AND d1.codic1 = a.cdarti AND d1.idlang = :idlang: ";
      $params = array('cdcata' => $cdcata, 'idlang' => $idlang);
    } else {
      $dsarti = 'a.dsarti AS dsarti';
      $lnJoin = '';
      $params = array('cdcata' => $cdcata);
    }

    $query = "SELECT CONCAT(a.cdarti, ' ', ac.cdcolo) as cdarti, $dsarti, IF(EXISTS(SELECT m.cdartn FROM Go2B\Models\B2bModevi m WHERE m.cdartn = CONCAT(ac.cdarti, ' ', ac.cdcolo) AND m.cdcata = c.cdcata), 1, 0) AS exist
      FROM Go2B\Models\Artcol ac
      LEFT JOIN Go2B\Models\Ctarti c ON ac.cdarti = c.cdarti
      INNER JOIN Go2B\Models\Anaart a ON a.cdarti = c.cdarti
      $lnJoin
      WHERE c.cdcata = :cdcata:";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Ctarti objects
   */
  public static function getAllArticlesWithImagesFromCatalog($cdcata, $idlang = 'IT') {
    if ($idlang != 'IT') {
      $dsarti = 'COALESCE(d1.descri,aa.dsarti) AS dsarti';
      $dsartn = 'COALESCE(d2.descri,tp.dsartn) AS dsartn';
      $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsarti' AND d1.codic1 = aa.cdarti AND d1.idlang = :idlang:
                 LEFT JOIN Go2B\Models\Deslin d2 ON d2.tpdato = 'dsartn' AND d2.codic1 = tp.cdartn AND d2.idlang = :idlang: ";
      $params = array('cdcata' => $cdcata, 'idlang' => $idlang);
    } else {
      $dsarti = 'aa.dsarti AS dsarti';
      $dsartn = 'tp.dsartn AS dsartn';
      $lnJoin = '';
      $params = array('cdcata' => $cdcata);
    }

    $query = "SELECT aa.cdarti, $dsarti, aa.flimag AS flimag_i1, aa.cdartn, $dsartn, tp.flimag AS flimag_n1,
      COALESCE(ia1.flimag, '') AS flimag_i2, COALESCE(ia2.flimag, '') AS flimag_i3,
      COALESCE(ia3.flimag, '') AS flimag_i4, COALESCE(ia4.flimag, '') AS flimag_i5,
      COALESCE(it1.flimag, '') AS flimag_n2, COALESCE(it2.flimag, '') AS flimag_n3,
      COALESCE(it3.flimag, '') AS flimag_n4, COALESCE(it4.flimag, '') AS flimag_n5
      FROM Go2B\Models\Ctarti ca
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = ca.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      LEFT JOIN Go2B\Models\Imgart ia1 ON ia1.tpimag = 'AR02' AND ia1.codic1 = aa.cdarti AND ia1.codic2 = ''
      LEFT JOIN Go2B\Models\Imgart ia2 ON ia2.tpimag = 'AR03' AND ia2.codic1 = aa.cdarti AND ia2.codic2 = ''
      LEFT JOIN Go2B\Models\Imgart ia3 ON ia3.tpimag = 'AR04' AND ia3.codic1 = aa.cdarti AND ia3.codic2 = ''
      LEFT JOIN Go2B\Models\Imgart ia4 ON ia4.tpimag = 'AR05' AND ia4.codic1 = aa.cdarti AND ia4.codic2 = ''
      LEFT JOIN Go2B\Models\Imgart it1 ON it1.tpimag = 'MOD2' AND it1.codic1 = aa.cdartn AND it1.codic2 = ''
      LEFT JOIN Go2B\Models\Imgart it2 ON it2.tpimag = 'MOD3' AND it2.codic1 = aa.cdartn AND it2.codic2 = ''
      LEFT JOIN Go2B\Models\Imgart it3 ON it3.tpimag = 'MOD4' AND it3.codic1 = aa.cdartn AND it3.codic2 = ''
      LEFT JOIN Go2B\Models\Imgart it4 ON it4.tpimag = 'MOD5' AND it4.codic1 = aa.cdartn AND it4.codic2 = ''
      $lnJoin
      WHERE ca.cdcata = :cdcata:
      GROUP BY aa.cdarti";

    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Ctarti objects
   */
  public static function getAllArticlesFromCatalogAndModel($cdcata, $cdartn) {
    $query = "SELECT c.cdarti, a.dsarti, t.cdlinm, a.cdcolo, a.flimag, a.dscolo
      FROM Go2B\Models\Ctarti c
      INNER JOIN Go2B\Models\Anaart a ON c.cdarti = a.cdarti
      INNER JOIN Go2B\Models\Tipolo t ON a.cdartn = t.cdartn
      WHERE c.cdcata = :cdcata: AND t.cdartn = :cdartn:
      ORDER BY a.cdarti";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdcata' => $cdcata, 'cdartn' => $cdartn));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Ctarti objects
   */
  public static function getAllFabricsForModel($cdartn, $cdcata, $idlang, $nulist, $numdis, $tagFilter) {
    $params = array('cdcata' => $cdcata, 'cdartn' => $cdartn, 'nulist' => $nulist, 'idlang' => $idlang);
    $dsarti_fd = 'aa.dsarti AS dsarti';
    $sconto_fd = '0 AS cust_disc, ';
    $dsarti_jn = $sconto_jn ='';

    if ($idlang != 'IT') {
      $dsarti_fd = 'COALESCE(d1.descri,aa.dsarti) AS dsarti';
      $dsarti_jn = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsarti' AND d1.codic1 = aa.cdarti AND d1.idlang = :idlang: ";
      $params['idlang'] = $idlang;
      $commercialDescription = "COALESCE(de.descri,di.descri,'') AS des_comm ";
    } else {
      $commercialDescription = "COALESCE(di.descri,de.descri,'') AS des_comm ";
    }

    if ($numdis > 0) {
      $sconto_fd = 'COALESCE(c6.sconto,0) AS cust_disc, ';
      $sconto_jn = 'LEFT JOIN Go2B\Models\B2bDisbdy c6 ON c6.cdarti = aa.cdarti AND c6.numdis = :numdis: ';
      $params['numdis'] = $numdis;
    }

    $innerJoinTag = '';
    if (!empty($tagFilter)) {
      $innerJoinTag = 'INNER JOIN Go2B\Models\Artcla ac ON ac.tpinpu = "AR" AND ac.codice = ca.cdarti AND ac.tpclas LIKE "TB2%" AND ac.valore = :tag:';
      $params['tag'] = $tagFilter;
    }

    $query = "SELECT aa.cdarti, $dsarti_fd, aa.cdpers, aa.cdcolo, aa.dscolo, COALESCE(ap.flimag,aa.flimag) AS flimag,
      aa.flimag AS flimag_arti, ap.compos, ap.dspers,
      COALESCE(dc.descri,'') AS descom, COALESCE(dt.descri,'') AS destec, $sconto_fd
      COALESCE(IF(lc.taglia > '', -1, MAX(lc.prezzo)), 0) AS prezzo,
      COALESCE(IF(lc.taglia > '', -1, MAX(lc.preven)), 0) AS preven,
      COALESCE(lc.cdvalu,'') AS cdvalu, $commercialDescription
      FROM Go2B\Models\Ctarti ca
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = ca.cdarti
      INNER JOIN Go2B\Models\Anaper ap ON ap.cdpers = aa.cdpers
      $innerJoinTag
      LEFT JOIN Go2B\Models\Desart dc ON aa.cdarti = dc.codice AND dc.tpinpu = 'AR' AND dc.idlang = :idlang: AND dc.tpdesc = 'COMM'
      LEFT JOIN Go2B\Models\Desart dt ON aa.cdarti = dt.codice AND dt.tpinpu = 'AR' AND dt.idlang = :idlang: AND dt.tpdesc = 'TECN'
      LEFT JOIN Go2B\Models\Lscorp lc ON aa.cdarti = lc.cdarti AND lc.nulist = :nulist:
      LEFT JOIN Go2B\Models\Desart di ON di.tpinpu = 'AP' AND di.codice = ap.cdpers AND di.tpdesc = 'COMM' AND di.idlang = 'IT'
      LEFT JOIN Go2B\Models\Desart de ON de.tpinpu = 'AP' AND de.codice = ap.cdpers AND de.tpdesc = 'COMM' AND de.idlang = 'EN'
      $dsarti_jn
      $sconto_jn
      WHERE ca.cdcata = :cdcata: AND aa.cdartn = :cdartn: AND aa.flbloc = 0
      GROUP BY aa.cdarti
      ORDER BY aa.cdarti";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Ctarti objects
   */
  public static function getAllSizesFromAvailableCatalogs() {
    $query = "SELECT DISTINCT pt.taglia
      FROM Go2B\Models\Ctarti ca
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = ca.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Postgl pt ON pt.cdtagl = tp.cdtagl
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      WHERE tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      GROUP BY pt.taglia
      ORDER BY pt.taglia + 0, pt.cdtagl, pt.postgl";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Ctarti objects
   */
  public static function getAllSizesFromCurrentCatalog($cdcata) {
    $params = array('cdcata' => $cdcata);
    $query = "SELECT DISTINCT pt.taglia
      FROM Go2B\Models\Ctarti ca
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = ca.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Postgl pt ON pt.cdtagl = tp.cdtagl
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      WHERE ca.cdcata = :cdcata: AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      GROUP BY pt.taglia
      ORDER BY pt.taglia + 0, pt.cdtagl, pt.postgl";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Ctarti objects
   */
  public static function getCatalogDetail($cdcata) {
    $query = "SELECT ca.cdarti, aa.dsarti, aa.flimag AS arti_img,
      tp.cdartn, tp.dsartn, tp.flimag AS artn_img,
      tp.cdlinm, lm.dslinm, lm.flimag AS linm_img,
      tp.cdserm, COALESCE(sm.dsserm,'') AS dsserm, sm.flimag AS serm_img,
      lm.cdtitl, tl.dstitl, tl.flimag AS titl_img,
      COALESCE(da01.descri,'') AS artn_comm_it, COALESCE(da02.descri,'') AS artn_comm_en,
      COALESCE(da03.descri,'') AS artn_comm_es, COALESCE(da04.descri,'') AS artn_comm_fr,
      COALESCE(da05.descri,'') AS artn_comm_de, COALESCE(da06.descri,'') AS artn_tecn_it,
      COALESCE(da07.descri,'') AS artn_tecn_en, COALESCE(da08.descri,'') AS artn_tecn_es,
      COALESCE(da09.descri,'') AS artn_tecn_fr, COALESCE(da10.descri,'') AS artn_tecn_de,
      COALESCE(da11.descri,'') AS arti_comm_it, COALESCE(da12.descri,'') AS arti_comm_en,
      COALESCE(da13.descri,'') AS arti_comm_es, COALESCE(da14.descri,'') AS arti_comm_fr,
      COALESCE(da15.descri,'') AS arti_comm_de, COALESCE(da16.descri,'') AS arti_tecn_it,
      COALESCE(da17.descri,'') AS arti_tecn_en, COALESCE(da18.descri,'') AS arti_tecn_es,
      COALESCE(da19.descri,'') AS arti_tecn_fr, COALESCE(da20.descri,'') AS arti_tecn_de
      FROM Go2B\Models\Ctarti ca
      INNER JOIN Go2B\Models\Anaart aa ON ca.cdarti = aa.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON aa.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON tp.cdlinm = lm.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON lm.cdtitl = tl.cdtitl
      LEFT JOIN Go2B\Models\Sermod sm ON tp.cdlinm = sm.cdlinm AND tp.cdserm = sm.cdserm
      LEFT JOIN Go2B\Models\Desart da01 ON da01.tpinpu = 'AN' AND da01.codice = aa.cdartn AND da01.tpdesc = 'COMM' AND da01.idlang = 'IT'
      LEFT JOIN Go2B\Models\Desart da02 ON da02.tpinpu = 'AN' AND da02.codice = aa.cdartn AND da02.tpdesc = 'COMM' AND da02.idlang = 'EN'
      LEFT JOIN Go2B\Models\Desart da03 ON da03.tpinpu = 'AN' AND da03.codice = aa.cdartn AND da03.tpdesc = 'COMM' AND da03.idlang = 'ES'
      LEFT JOIN Go2B\Models\Desart da04 ON da04.tpinpu = 'AN' AND da04.codice = aa.cdartn AND da04.tpdesc = 'COMM' AND da04.idlang = 'FR'
      LEFT JOIN Go2B\Models\Desart da05 ON da05.tpinpu = 'AN' AND da05.codice = aa.cdartn AND da05.tpdesc = 'COMM' AND da05.idlang = 'DE'
      LEFT JOIN Go2B\Models\Desart da06 ON da06.tpinpu = 'AN' AND da06.codice = aa.cdartn AND da06.tpdesc = 'TECN' AND da06.idlang = 'IT'
      LEFT JOIN Go2B\Models\Desart da07 ON da07.tpinpu = 'AN' AND da07.codice = aa.cdartn AND da07.tpdesc = 'TECN' AND da07.idlang = 'EN'
      LEFT JOIN Go2B\Models\Desart da08 ON da08.tpinpu = 'AN' AND da08.codice = aa.cdartn AND da08.tpdesc = 'TECN' AND da08.idlang = 'ES'
      LEFT JOIN Go2B\Models\Desart da09 ON da09.tpinpu = 'AN' AND da09.codice = aa.cdartn AND da09.tpdesc = 'TECN' AND da09.idlang = 'FR'
      LEFT JOIN Go2B\Models\Desart da10 ON da10.tpinpu = 'AN' AND da10.codice = aa.cdartn AND da10.tpdesc = 'TECN' AND da10.idlang = 'DE'
      LEFT JOIN Go2B\Models\Desart da11 ON da11.tpinpu = 'AR' AND da11.codice = aa.cdarti AND da11.tpdesc = 'COMM' AND da11.idlang = 'IT'
      LEFT JOIN Go2B\Models\Desart da12 ON da12.tpinpu = 'AR' AND da12.codice = aa.cdarti AND da12.tpdesc = 'COMM' AND da12.idlang = 'EN'
      LEFT JOIN Go2B\Models\Desart da13 ON da13.tpinpu = 'AR' AND da13.codice = aa.cdarti AND da13.tpdesc = 'COMM' AND da13.idlang = 'ES'
      LEFT JOIN Go2B\Models\Desart da14 ON da14.tpinpu = 'AR' AND da14.codice = aa.cdarti AND da14.tpdesc = 'COMM' AND da14.idlang = 'FR'
      LEFT JOIN Go2B\Models\Desart da15 ON da15.tpinpu = 'AR' AND da15.codice = aa.cdarti AND da15.tpdesc = 'COMM' AND da15.idlang = 'DE'
      LEFT JOIN Go2B\Models\Desart da16 ON da16.tpinpu = 'AR' AND da16.codice = aa.cdarti AND da16.tpdesc = 'TECN' AND da16.idlang = 'IT'
      LEFT JOIN Go2B\Models\Desart da17 ON da17.tpinpu = 'AR' AND da17.codice = aa.cdarti AND da17.tpdesc = 'TECN' AND da17.idlang = 'EN'
      LEFT JOIN Go2B\Models\Desart da18 ON da18.tpinpu = 'AR' AND da18.codice = aa.cdarti AND da18.tpdesc = 'TECN' AND da18.idlang = 'ES'
      LEFT JOIN Go2B\Models\Desart da19 ON da19.tpinpu = 'AR' AND da19.codice = aa.cdarti AND da19.tpdesc = 'TECN' AND da19.idlang = 'FR'
      LEFT JOIN Go2B\Models\Desart da20 ON da20.tpinpu = 'AR' AND da20.codice = aa.cdarti AND da20.tpdesc = 'TECN' AND da20.idlang = 'DE'
      WHERE ca.cdcata = :cdcata:
      GROUP BY aa.cdarti
      ORDER BY tl.cdtitl, lm.seqrap, lm.cdlinm, sm.cdserm, tp.cdartn, aa.cdarti";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdcata' => $cdcata));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Ctarti objects
   */
  public static function getCatalogDetailModels($cdcata, $cdtitl = '', $cdlinm = '', $cdserm = '') {
    $params = array('cdcata' => $cdcata);
    $andWhere = '';
    if ($cdserm != '') {
      $params['cdserm'] = $cdserm;
      $andWhere .= ' AND tp.cdserm = :cdserm: ';
    }
    if ($cdlinm != '') {
      $params['cdlinm'] = $cdlinm;
      $andWhere .= ' AND tp.cdlinm = :cdlinm: ';
    }
    if ($cdtitl != '') {
      $params['cdtitl'] = $cdtitl;
      $andWhere .= ' AND lm.cdtitl = :cdtitl: ';
    }
    $query = "SELECT COUNT(ca.cdarti) AS num_variations,
      tp.cdartn, tp.dsartn, tp.flimag AS artn_img,
      tp.cdlinm, lm.dslinm, lm.flimag AS linm_img,
      tp.cdserm, COALESCE(sm.dsserm,'') AS dsserm, sm.flimag AS serm_img,
      lm.cdtitl, tl.dstitl, tl.flimag AS titl_img,
      COALESCE(da01.descri,'') AS artn_comm_it, COALESCE(da02.descri,'') AS artn_comm_en,
      COALESCE(da03.descri,'') AS artn_comm_es, COALESCE(da04.descri,'') AS artn_comm_fr,
      COALESCE(da05.descri,'') AS artn_comm_de, COALESCE(da06.descri,'') AS artn_tecn_it,
      COALESCE(da07.descri,'') AS artn_tecn_en, COALESCE(da08.descri,'') AS artn_tecn_es,
      COALESCE(da09.descri,'') AS artn_tecn_fr, COALESCE(da10.descri,'') AS artn_tecn_de
      FROM Go2B\Models\Ctarti ca
      INNER JOIN Go2B\Models\Anaart aa ON ca.cdarti = aa.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON aa.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON tp.cdlinm = lm.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON lm.cdtitl = tl.cdtitl
      LEFT JOIN Go2B\Models\Sermod sm ON tp.cdlinm = sm.cdlinm AND tp.cdserm = sm.cdserm
      LEFT JOIN Go2B\Models\Desart da01 ON da01.tpinpu = 'AN' AND da01.codice = aa.cdartn AND da01.tpdesc = 'COMM' AND da01.idlang = 'IT'
      LEFT JOIN Go2B\Models\Desart da02 ON da02.tpinpu = 'AN' AND da02.codice = aa.cdartn AND da02.tpdesc = 'COMM' AND da02.idlang = 'EN'
      LEFT JOIN Go2B\Models\Desart da03 ON da03.tpinpu = 'AN' AND da03.codice = aa.cdartn AND da03.tpdesc = 'COMM' AND da03.idlang = 'ES'
      LEFT JOIN Go2B\Models\Desart da04 ON da04.tpinpu = 'AN' AND da04.codice = aa.cdartn AND da04.tpdesc = 'COMM' AND da04.idlang = 'FR'
      LEFT JOIN Go2B\Models\Desart da05 ON da05.tpinpu = 'AN' AND da05.codice = aa.cdartn AND da05.tpdesc = 'COMM' AND da05.idlang = 'DE'
      LEFT JOIN Go2B\Models\Desart da06 ON da06.tpinpu = 'AN' AND da06.codice = aa.cdartn AND da06.tpdesc = 'TECN' AND da06.idlang = 'IT'
      LEFT JOIN Go2B\Models\Desart da07 ON da07.tpinpu = 'AN' AND da07.codice = aa.cdartn AND da07.tpdesc = 'TECN' AND da07.idlang = 'EN'
      LEFT JOIN Go2B\Models\Desart da08 ON da08.tpinpu = 'AN' AND da08.codice = aa.cdartn AND da08.tpdesc = 'TECN' AND da08.idlang = 'ES'
      LEFT JOIN Go2B\Models\Desart da09 ON da09.tpinpu = 'AN' AND da09.codice = aa.cdartn AND da09.tpdesc = 'TECN' AND da09.idlang = 'FR'
      LEFT JOIN Go2B\Models\Desart da10 ON da10.tpinpu = 'AN' AND da10.codice = aa.cdartn AND da10.tpdesc = 'TECN' AND da10.idlang = 'DE'
      WHERE ca.cdcata = :cdcata: $andWhere
      GROUP BY tp.cdartn
      ORDER BY tl.cdtitl, lm.seqrap, lm.cdlinm, sm.cdserm, tp.cdartn";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Ctarti objects
   */
  public static function getCatalogDetailCategories($cdcata) {
    $query = "SELECT
      lm.cdtitl, tl.dstitl, tl.flimag AS titl_img,
      tp.cdlinm, lm.dslinm, lm.flimag AS linm_img,
      tp.cdserm, COALESCE(sm.dsserm,'') AS dsserm, sm.flimag AS serm_img
      FROM Go2B\Models\Ctarti ca
      INNER JOIN Go2B\Models\Anaart aa ON ca.cdarti = aa.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON aa.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON tp.cdlinm = lm.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON lm.cdtitl = tl.cdtitl
      LEFT JOIN Go2B\Models\Sermod sm ON tp.cdlinm = sm.cdlinm AND tp.cdserm = sm.cdserm
      WHERE ca.cdcata = :cdcata:
      GROUP BY lm.cdtitl, tp.cdlinm, tp.cdserm
      ORDER BY tl.cdtitl, lm.seqrap, lm.cdlinm, sm.cdserm";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdcata' => $cdcata));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Ctarti objects
   */
  public static function getAllAvailableCatalogDetails($isPT, $idlang = 'IT') {
    $params = array();
    if ($idlang != 'IT') {
      $params['idlang'] = $idlang;
      $dsarti = 'COALESCE(d1.descri,aa.dsarti) AS dsarti';
      $dsartn = 'COALESCE(d2.descri,tp.dsartn) AS dsartn';
      $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsarti' AND d1.codic1 = aa.cdarti AND d1.idlang = :idlang:
                 LEFT JOIN Go2B\Models\Deslin d2 ON d2.tpdato = 'dsartn' AND d2.codic1 = tp.cdartn AND d2.idlang = :idlang: ";
    } else {
      $dsarti = 'aa.dsarti AS dsarti';
      $dsartn = 'tp.dsartn AS dsartn';
      $lnJoin = '';
    }

    if ($isPT) {
      $ptSel  = 'ac.cdcolo AS cdcolo_v, ac.flimag AS flimag_v, COALESCE(av.cdvari,"") AS cdvari, COALESCE(av.dsvari,"") AS dsvari,';
      $ptJoin = 'INNER JOIN Go2B\Models\Artcol ac ON ac.cdarti = aa.cdarti
                LEFT JOIN Go2B\Models\Artvar av ON av.cdarti = aa.cdarti ';
    } else {
      $ptSel  = '';
      $ptJoin = '';
    }

    $query = "SELECT aa.cdarti, $dsarti, aa.cdpers, aa.cdcolo AS cdcolo_i,
      aa.dscolo, tp.cdartn, $dsartn, $ptSel
      ca.cdcata, ct.dscata,
      tp.tppers, aa.flimag AS flimag_i, tp.flimag AS flimag_n, tp.cdtagl
      FROM Go2B\Models\Ctarti ca
      INNER JOIN Go2B\Models\Cttest ct ON ct.cdcata = ca.cdcata
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = ca.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      $lnJoin
      $ptJoin
      WHERE tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      ORDER BY ct.cdcata, tp.seqrap, tp.cdartn, aa.cdarti ";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Ctarti objects
   */
  public static function getAllCatalogDetailsForCurrentCatalog($isPT, $cdcata, $idlang = 'IT') {
    $params = array('cdcata' => $cdcata);
    if ($idlang != 'IT') {
      $params['idlang'] = $idlang;
      $dsarti = 'COALESCE(d1.descri,aa.dsarti) AS dsarti';
      $dsartn = 'COALESCE(d2.descri,tp.dsartn) AS dsartn';
      $lnJoin = "LEFT JOIN deslin d1 ON d1.tpdato = 'dsarti' AND d1.codic1 = aa.cdarti AND d1.idlang = :idlang
                 LEFT JOIN deslin d2 ON d2.tpdato = 'dsartn' AND d2.codic1 = tp.cdartn AND d2.idlang = :idlang ";
    } else {
      $dsarti = 'aa.dsarti AS dsarti';
      $dsartn = 'tp.dsartn AS dsartn';
      $lnJoin = '';
    }

    $groupAndOrder = $isPT ? ', cdcolo_v' : '';

    if ($isPT) {
      $ptSel  = 'ac.cdcolo AS cdcolo_v, ac.flimag AS flimag_v, COALESCE(av.cdvari, "") AS cdvari, COALESCE(av.dsvari, "") AS dsvari';
      $ptJoin = 'INNER JOIN artcol ac ON ac.cdarti = aa.cdarti
                 LEFT JOIN artvar av ON av.cdarti = aa.cdarti ';
    } else {
      $ptSel  = '';
      $ptJoin = '';
    }

    //$query = "SELECT aa.cdarti, $dsarti, aa.cdpers, aa.cdcolo AS cdcolo_i,
    //  aa.dscolo, tp.cdartn, $dsartn, $ptSel
    //  ca.cdcata, ct.dscata,
    //  tp.tppers, aa.flimag AS flimag_i, tp.flimag AS flimag_n, tp.cdtagl, tp.seqrap
    $query = "SELECT ca.cdarti, aa.cdpers, aa.cdcolo AS cdcolo_i, tp.cdartn, $ptSel
      FROM ctarti ca
      INNER JOIN cttest ct ON ct.cdcata = ca.cdcata
      INNER JOIN anaart aa ON aa.cdarti = ca.cdarti
      INNER JOIN tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN b2b_tipval ba ON ba.cdartn = tp.cdartn
      $lnJoin
      $ptJoin
      WHERE ca.cdcata = :cdcata AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      GROUP BY aa.cdarti $groupAndOrder
      ORDER BY ca.cdcata, tp.seqrap, tp.cdartn, ca.cdarti $groupAndOrder";

    return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Ctarti objects
   */
  public static function getAllCatalogDetailsWithAvailabilityForCurrentCatalog($isPT, $cdcata, $showNotAvailable, $idlang = 'IT') {
    $params = array('cdcata' => $cdcata);
    if ($idlang != 'IT') {
      $params['idlang'] = $idlang;
      $dsarti = 'COALESCE(d1.descri,aa.dsarti) AS dsarti';
      $lnJoin = "LEFT JOIN deslin d1 ON d1.tpdato = 'dsarti' AND d1.codic1 = aa.cdarti AND d1.idlang = :idlang ";
    } else {
      $dsarti = 'aa.dsarti AS dsarti';
      $lnJoin = '';
    }

    $groupAndOrder = $isPT ? ', cdcolo_v' : '';

    if ($isPT) {
      $groupAndOrder = ', av.cdvari' . $groupAndOrder;
      $ptSel  = 'IFNULL(ac.cdcolo, \'\') AS cdcolo_v, ac.flimag AS flimag_v, COALESCE(av.cdvari, "") AS cdvari, COALESCE(av.dsvari, "") AS dsvari,';
      $ptJoin = 'LEFT JOIN artcol ac ON ac.cdarti = aa.cdarti
                 LEFT JOIN (
                  SELECT cdarti,cdvari,dsvari,preagg FROM artvar 
                  UNION
                  SELECT cdarti, \'\' AS cdvari, \'\' AS dsvari,0 AS preagg FROM artvar GROUP BY cdarti 
               ) av ON av.cdarti = aa.cdarti ';
    } else {
      $ptSel  = '';
      $ptJoin = '';
    }

    if ($isPT) {
      $leftJoinAvailability = 'LEFT JOIN (
        SELECT dc1.cdarti AS cdarti, dc1.cdcolo AS cdcolo, dc1.cdvari AS cdvari, dc1.taglia AS item, dc1.dtdisp AS dtdisp, COALESCE(dc1.quanti -
          (SELECT COALESCE(SUM(og1.quanti), 0)
          FROM octagl og1
          INNER JOIN occorp oc1 ON oc1.nurorc = og1.nurorc
          INNER JOIN octest ot1 ON ot1.nuordc = oc1.nuordc
          WHERE oc1.cdarti = dc1.cdarti AND oc1.cdcolo = dc1.cdcolo
          AND oc1.cdvari = dc1.cdvari AND ot1.flstat = 2 AND og1.dstagl = dc1.taglia),
        0) AS quanti, 0 AS isasso
        FROM dscorp dc1
        WHERE dc1.cdasso = ""
        UNION
        SELECT dc2.cdarti AS cdarti, dc2.cdcolo AS cdcolo, dc2.cdvari AS cdvari, dc2.cdasso AS item, dc2.dtdisp AS dtdisp, COALESCE(dc2.quanti -
          (SELECT COALESCE(SUM(oa2.quanti), 0)
          FROM ocasso oa2
          INNER JOIN occorp oc2 ON oc2.nurorc = oa2.nurorc
          INNER JOIN octest ot2 ON ot2.nuordc = oc2.nuordc
          WHERE oc2.cdarti = dc2.cdarti AND oc2.cdcolo = dc2.cdcolo
          AND oc2.cdvari = dc2.cdvari AND ot2.flstat = 2 AND oa2.cdasso = dc2.cdasso),
        0) AS quanti, 1 AS isasso
        FROM dscorp dc2
        WHERE dc2.cdasso != ""
        GROUP BY dtdisp
        ORDER BY dtdisp, isasso, item
      ) AS disp ON ca.cdarti = disp.cdarti AND IFNULL(ac.cdcolo, \'\') = disp.cdcolo AND COALESCE(av.cdvari,"") = disp.cdvari';
    } else {
      $leftJoinAvailability = 'LEFT JOIN (
        SELECT dc1.cdarti AS cdarti, dc1.cdcolo AS cdcolo, dc1.taglia AS item, dc1.dtdisp AS dtdisp, COALESCE(dc1.quanti -
          (SELECT COALESCE(SUM(og1.quanti), 0)
          FROM octagl og1
          INNER JOIN occorp oc1 ON oc1.nurorc = og1.nurorc
          INNER JOIN octest ot1 ON ot1.nuordc = oc1.nuordc
          WHERE oc1.cdarti = dc1.cdarti AND ot1.flstat = 2 AND og1.dstagl = dc1.taglia),
        0) AS quanti, 0 AS isasso
        FROM dscorp dc1
        WHERE dc1.cdasso = ""
        UNION
        SELECT dc2.cdarti AS cdarti, dc2.cdcolo AS cdcolo, dc2.cdasso AS item, dc2.dtdisp AS dtdisp, COALESCE(dc2.quanti -
          (SELECT COALESCE(SUM(oa2.quanti), 0)
          FROM ocasso oa2
          INNER JOIN occorp oc2 ON oc2.nurorc = oa2.nurorc
          INNER JOIN octest ot2 ON ot2.nuordc = oc2.nuordc
          WHERE oc2.cdarti = dc2.cdarti AND ot2.flstat = 2 AND oa2.cdasso = dc2.cdasso),
        0) AS quanti, 1 AS isasso
        FROM dscorp dc2
        WHERE dc2.cdasso != ""
        GROUP BY dtdisp
        ORDER BY dtdisp, isasso, item
      ) AS disp ON ca.cdarti = disp.cdarti';
    }

    $having = '';
    if (!$showNotAvailable) {
      $having = "HAVING items != ''";
    }

    $query = "SELECT ca.cdarti, $dsarti, aa.cdpers, aa.cdcolo AS cdcolo_i, aa.dscolo, $ptSel
      GROUP_CONCAT(disp.item) AS items, GROUP_CONCAT(disp.dtdisp) AS availabilityDates, GROUP_CONCAT(disp.quanti) AS availabilityQuantities,
      GROUP_CONCAT(disp.isasso) AS isAsso,
      aa.flimag AS flimag_i, tp.flimag AS flimag_n, tp.cdtagl
      FROM ctarti ca
      INNER JOIN cttest ct ON ct.cdcata = ca.cdcata
      INNER JOIN anaart aa ON aa.cdarti = ca.cdarti
      INNER JOIN tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN b2b_tipval ba ON ba.cdartn = tp.cdartn
      $lnJoin
      $ptJoin
      $leftJoinAvailability
      WHERE ca.cdcata = :cdcata AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      GROUP BY aa.cdarti $groupAndOrder
      $having
      ORDER BY ca.cdcata, tp.seqrap, tp.cdartn, ca.cdarti $groupAndOrder";

//    Utility::dumpQuery($query, $params, true);
    return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Ctarti objects
   */
  public static function getCatalogDetailForXlsTemplate($cdcata, $nulist, $isPT, $idlang = 'IT') {
    if ($idlang != 'IT') {
      $dsarti = 'COALESCE(d1.descri,aa.dsarti) AS dsarti';
      $dslinm = 'COALESCE(d2.descri,lm.dslinm) AS dslinm';
      $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsarti' AND d1.codic1 = aa.cdarti AND d1.idlang = :idlang:
                 LEFT JOIN Go2B\Models\Deslin d2 ON d2.tpdato = 'dslinm' AND d2.codic1 = lm.cdlinm AND d2.idlang = :idlang: ";
    } else {
      $dsarti = 'aa.dsarti AS dsarti';
      $dslinm = 'lm.dslinm AS dslinm';
      $lnJoin = '';
    }

    if ($isPT) {
      $ptSel  = 'ac.cdcolo AS cdcolo_v, ac.dscolo AS dscolo_v, ac.flimag AS flimag_v, COALESCE(av.cdvari,"") AS cdvari, COALESCE(av.dsvari,"") AS dsvari, ';
      $ptJoin = 'INNER JOIN Go2B\Models\Artcol ac ON ac.cdarti = aa.cdarti
                 LEFT JOIN Go2B\Models\Artvar av ON av.cdarti = aa.cdarti ';
    } else {
      $ptSel  = '';
      $ptJoin = '';
    }

    $groupBy = 'GROUP BY aa.cdarti ' . ($isPT ? ', cdcolo_v' : '');

    $query = "SELECT aa.cdarti, $dsarti, aa.cdpers, aa.cdcolo AS cdcolo_i,
      aa.dscolo AS dscolo_i,
      $ptSel
      COALESCE(dn.descri,'') AS dscomm_n, COALESCE(dr.descri,'') AS dscomm_i,
      tp.cdartn, tp.tppers, aa.flimag AS flimag_i, tp.flimag AS flimag_n,
      tp.cdtagl, tl.cdtitl, tl.dstitl, tp.cdlinm, $dslinm,
      COALESCE(sm.cdserm,'') AS cdserm, COALESCE(sm.dsserm,'') AS dsserm,
      COALESCE ( IF ( lc.taglia > '', '0', lc.prezzo ), '0' ) as catalogPrice
      FROM Go2B\Models\Ctarti ca
      INNER JOIN Go2B\Models\Cttest ct ON ct.cdcata = ca.cdcata
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = ca.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN Go2B\Models\Sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
      LEFT JOIN Go2B\Models\Desart dn ON tp.cdartn = dn.codice AND dn.tpinpu = 'AN' AND dn.idlang = :idlang: AND dn.tpdesc = 'COMM'
      LEFT JOIN Go2B\Models\Desart dr ON aa.cdarti = dr.codice AND dr.tpinpu = 'AR' AND dr.idlang = :idlang: AND dr.tpdesc = 'COMM'
      LEFT JOIN Go2B\Models\Lscorp lc ON lc.nulist = :nulist: AND lc.cdarti = aa.cdarti
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      $ptJoin
      $lnJoin
      WHERE ca.cdcata = :cdcata:
      AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      $groupBy
      ORDER BY lm.cdtitl, lm.cdlinm, sm.cdserm, tp.cdartn, aa.cdarti";
    $params = array('cdcata' => $cdcata, 'nulist' => $nulist, 'idlang' => $idlang);
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Ctarti objects
   */
  public static function getModelsNotInSpecialSelection($cdspsl, $cdcata, $idlang = 'IT') {
    $params = array('cdspsl' => $cdspsl, 'cdcata' => $cdcata);
    if ($idlang != 'IT') {
      $params['idlang'] = $idlang;
      $dsartn = 'COALESCE(d1.descri,tp.dsartn)';
      $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = tp.cdartn AND d1.idlang = :idlang: ";
    } else {
      $dsartn = 'tp.dsartn';
      $lnJoin = '';
    }
    $query = "SELECT tp.cdartn AS code, $dsartn AS description, tp.flimag AS image
      FROM Go2B\Models\Ctarti ca
      INNER JOIN Go2B\Models\Anaart aa ON ca.cdarti = aa.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      $lnJoin
      WHERE ca.cdcata = :cdcata:
      AND tp.cdartn NOT IN (
        SELECT sc.codice
        FROM Go2B\Models\B2bSscorp sc
        WHERE sc.cdspsl = :cdspsl:
      )
      GROUP BY tp.cdartn
      ORDER BY tp.cdartn";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Ctarti objects
   */
  public static function getArticlesNotInSpecialSelection($cdspsl, $cdcata, $idlang = 'IT') {
    $params = array('cdspsl' => $cdspsl, 'cdcata' => $cdcata);
    if ($idlang != 'IT') {
      $params['idlang'] = $idlang;
      $dsarti = 'COALESCE(d1.descri,aa.dsarti)';
      $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsarti' AND d1.codic1 = aa.cdarti AND d1.idlang = :idlang: ";
    } else {
      $dsarti = 'aa.dsarti';
      $lnJoin = '';
    }
    $query = "SELECT aa.cdarti AS code, $dsarti AS description, aa.flimag AS image
      FROM Go2B\Models\Ctarti ca
      INNER JOIN Go2B\Models\Anaart aa ON ca.cdarti = aa.cdarti
      $lnJoin
      WHERE ca.cdcata = :cdcata:
      AND aa.cdarti NOT IN (
        SELECT sc.codice
        FROM Go2B\Models\B2bSscorp sc
        WHERE sc.cdspsl = :cdspsl:
      )
      GROUP BY aa.cdarti
      ORDER BY aa.cdarti";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Ctarti objects
   */
  public static function getXlsCategoriesRows($cdcata, $idlang = 'IT') {
    if ($idlang != 'IT') {
      $dslinm = "COALESCE(d2.descri,lm.dslinm) AS dslinm";
      $lnJoin = "LEFT JOIN Go2B\Models\Deslin d2 ON d2.tpdato = 'dslinm' AND d2.codic1 = lm.cdlinm AND d2.idlang = :idlang: ";
      $params = array('cdcata' => $cdcata, 'idlang' => $idlang);
    } else {
      $dslinm = 'lm.dslinm AS dslinm';
      $lnJoin = '';
      $params = array('cdcata' => $cdcata);
    }

    $query = "SELECT DISTINCT tl.cdtitl, tl.dstitl, lm.cdlinm, $dslinm, sm.cdserm, COALESCE(sm.dsserm,'') AS dsserm
      FROM Go2B\Models\Ctarti ca
      INNER JOIN Go2B\Models\Cttest ct ON ct.cdcata = ca.cdcata
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = ca.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN Go2B\Models\Sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      $lnJoin
      WHERE ca.cdcata = :cdcata:
      AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      ORDER BY tl.dstitl, lm.dslinm, dsserm ";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Ctarti objects
   */
  public static function getCategoriesRows($cdcata, $idlang = 'IT') {
    if ($idlang != 'IT') {
      $dslinm = "COALESCE(d2.descri,lm.dslinm) AS dslinm";
      $lnJoin = "LEFT JOIN Go2B\Models\Deslin d2 ON d2.tpdato = 'dslinm' AND d2.codic1 = lm.cdlinm AND d2.idlang = :idlang: ";
      $params = array('cdcata' => $cdcata, 'idlang' => $idlang);
    } else {
      $dslinm = 'lm.dslinm AS dslinm';
      $lnJoin = '';
      $params = array('cdcata' => $cdcata);
    }

    $query = "SELECT DISTINCT tl.cdtitl, tl.dstitl, lm.cdlinm, $dslinm, sm.cdserm, COALESCE(sm.dsserm,'') AS dsserm
      FROM Go2B\Models\Ctarti ca
      INNER JOIN Go2B\Models\Cttest ct ON ct.cdcata = ca.cdcata
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = ca.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN Go2B\Models\Sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
      $lnJoin
      WHERE ca.cdcata = :cdcata:
      ORDER BY tl.dstitl, lm.dslinm, dsserm ";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Ctarti objects
   */
  public static function getArticlesWithoutAvailability($cdcata) {
    $query = "SELECT DISTINCT aa.cdarti, aa.dsarti
      FROM Go2B\Models\Ctarti ca
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = ca.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      WHERE ca.cdcata = :cdcata: AND tp.flbloc = 0 AND aa.flbloc = 0
      AND ca.cdarti NOT IN (
        SELECT dc.cdarti
        FROM Go2B\Models\Dscorp dc
        INNER JOIN Go2B\Models\Ctarti ca2 ON ca2.cdarti = dc.cdarti
        WHERE dc.quanti > 0 AND ca2.cdcata = ca.cdcata
      ) ";

    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdcata' => $cdcata));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Ctarti objects
   */
  public static function getAllArticlesForCatalogAndLine($cdcata, $cdlinm) {
    $query = "SELECT c.cdarti
      FROM ctarti c
      INNER JOIN anaart a ON c.cdarti = a.cdarti
      INNER JOIN tipolo t ON a.cdartn = t.cdartn
      WHERE c.cdcata = :cdcata AND t.cdlinm = :cdlinm";
    return Di::getDefault()->get('db')->query($query, array('cdcata' => $cdcata, 'cdlinm' => $cdlinm))->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Ctarti objects
   */
  public static function getAllArticlesForCatalogAndSeries($cdcata, $cdserm, $cdlinm) {
    $query = "SELECT c.cdarti
      FROM ctarti c
      INNER JOIN anaart a ON c.cdarti = a.cdarti
      INNER JOIN tipolo t ON a.cdartn = t.cdartn
      WHERE c.cdcata = :cdcata AND t.cdlinm = :cdlinm AND t.cdserm = :cdserm";
    return Di::getDefault()->get('db')->query($query, array('cdcata' => $cdcata, 'cdlinm' => $cdlinm, 'cdserm' => $cdserm))->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Ctarti objects
   */
  public static function getAllArticlesForCatalogAndModel($cdcata, $cdartn) {
    $query = "SELECT c.cdarti
      FROM ctarti c
      INNER JOIN anaart a ON c.cdarti = a.cdarti
      INNER JOIN tipolo t ON a.cdartn = t.cdartn
      WHERE c.cdcata = :cdcata AND t.cdartn = :cdartn";
    return Di::getDefault()->get('db')->query($query, array('cdcata' => $cdcata, 'cdartn' => $cdartn))->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  int
   */
  public static function getNumberOfModelsFromSearchForCurrentCatalog($items, $checkSearchType = true) {
    $params = array('cdcata' => $items['cdcata'], 'search' => $items['search']);

    // Dsartn translation
    $dsartn = 'tp.dsartn AS dsartn';
    $leftJoinDsartn = '';
    if ($items['idlang'] != 'IT') {
      $dsartn = 'COALESCE(d1.descri,tp.dsartn) AS dsartn';
      $leftJoinDsartn = "LEFT JOIN deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = tp.cdartn AND d1.idlang = :idlang ";
      $params['idlang'] = $items['idlang'];
    }

    // Search type
    $searchFields = '';
    $leftJoinSearchType = '';
    $andWhereSearchType = '';
    if ($checkSearchType && $items['searchType'] > 0) {
        $searchFields = ", tp.tpmode, COALESCE(tm.dstmod,'') AS dstmod, lm.dslinm, COALESCE(sm.dsserm,'') AS dsserm ";
        $leftJoinSearchType = 'INNER JOIN linmod lm ON tp.cdlinm = lm.cdlinm
                           LEFT JOIN sermod sm ON tp.cdlinm = sm.cdlinm AND tp.cdserm = sm.cdserm
                           LEFT JOIN tpmode tm ON tp.tpmode = tm.tpmode ';
        $andWhereSearchType = ' OR (tp.tpmode LIKE :search OR dstmod LIKE :search) OR (lm.dslinm LIKE :search OR dsserm LIKE :search)';
        if ($items['searchType'] == 2) {
            $searchFields .= ", COALESCE(sa.valore,'') AS bolla ";
            $leftJoinSearchType .= "LEFT JOIN sparti sa ON aa.cdarti = sa.cdarti AND sa.tpcomp = 'BOLLA' ";
            $andWhereSearchType .= ' OR (sa.valore LIKE :search)';
        }
    }
    // Barcode
    if (!empty($items['barcode'])) {
        $searchFields .= ', bc.nubrcd';
        $leftJoinSearchType .= " LEFT JOIN barcod bc ON aa.cdarti = bc.cdarti AND bc.nubrcd LIKE :barcode ";
        $params['barcode'] = $items['barcode'];
        $andWhereSearchType .= ' OR (bc.nubrcd IS NOT NULL)';
    }
    // Availability
    $isAvailable = '';
    $leftJoinArtcol = '';
    $havingNotAvailable = '';
    if ($items['isAvailabilityOrder']) {
      $whr1_av = '';
      $whr2_av = '';
      if ($items['isPT']) {
        $leftJoinArtcol = ' LEFT JOIN artcol ac ON ac.cdarti = aa.cdarti ';
        $whr1_av = ' AND oc2.cdcolo = dc2.cdcolo AND oc2.cdvari = dc2.cdvari ';
        $whr2_av = ' AND dc2.cdcolo = ac.cdcolo ';
      }

      $isAvailable = ",
        IF(MAX(
          COALESCE(
            (SELECT MAX(dc2.quanti -
              COALESCE(
                (SELECT SUM(og2.quanti)
                FROM octagl og2
                INNER JOIN occorp oc2 ON oc2.nurorc = og2.nurorc
                INNER JOIN octest ot2 ON ot2.nuordc = oc2.nuordc
                WHERE oc2.cdarti = dc2.cdarti $whr1_av AND ot2.flstat = 2 AND og2.dstagl = dc2.taglia), 0)
              ) AS quanti
            FROM dscorp dc2
            WHERE dc2.cdarti = aa.cdarti $whr2_av),
          0)
        ) > 0, true, false) AS is_available ";

      // If parameter "show not available" is false, filter not available items
      if (!$items['showNotAvailable']) {
        $havingNotAvailable = ' HAVING is_available = 1 ';
      }
    }

    $query = "SELECT COUNT(*) as totSearch
      FROM (
        SELECT tp.cdartn, $dsartn, tp.tppers $searchFields $isAvailable
        FROM ctarti ca
        INNER JOIN anaart aa ON aa.cdarti = ca.cdarti
        INNER JOIN tipolo tp ON tp.cdartn = aa.cdartn
        LEFT JOIN b2b_tipval ba ON ba.cdartn = tp.cdartn
        $leftJoinArtcol
        $leftJoinDsartn
        $leftJoinSearchType
        WHERE ca.cdcata = :cdcata AND tp.flbloc = 0 AND aa.flbloc = 0
        AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
        AND ((tp.cdartn LIKE :search OR dsartn LIKE :search) $andWhereSearchType)
        GROUP BY tp.cdartn
        $havingNotAvailable) AS res";
    $res = Di::getDefault()->get('db')->query($query, $params)->fetchAll();

    return count($res) == 1 ? $res[0]['totSearch'] : 0;
  }

  /**
   * Query:   SELECT
   * Return:  int
   */
  public static function getNumberOfArticlesFromSearchForCurrentCatalog($items, $checkSearchType = true) {
    $params = array('cdcata' => $items['cdcata'], 'search' => $items['search']);

    // Dsartn, dsarti translation
    $dsartn = 'tp.dsartn AS dsartn';
    $dsarti = 'aa.dsarti AS dsarti';
    $leftJoinDsartn = '';
    $leftJoinDsarti = '';
    if ($items['idlang'] != 'IT') {
      $dsartn = 'COALESCE(d1.descri,tp.dsartn) AS dsartn';
      $dsarti = 'COALESCE(d2.descri,aa.dsarti) AS dsarti';
      $leftJoinDsartn = "LEFT JOIN deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = tp.cdartn AND d1.idlang = :idlang ";
      $leftJoinDsarti = "LEFT JOIN deslin d2 ON d2.tpdato = 'dsarti' AND d2.codic1 = aa.cdarti AND d2.idlang = :idlang ";
      $params['idlang'] = $items['idlang'];
    }

    // Search type
    $searchFields = '';
    $leftJoinSearchType = '';
    $andWhereSearchType = '';
    if ($checkSearchType && $items['searchType'] > 0) {
      $searchFields = ", tp.tpmode, COALESCE(tm.dstmod,'') AS dstmod, lm.dslinm, COALESCE(sm.dsserm,'') AS dsserm ";
      $leftJoinSearchType = 'INNER JOIN linmod lm ON tp.cdlinm = lm.cdlinm
                             LEFT JOIN sermod sm ON tp.cdlinm = sm.cdlinm AND tp.cdserm = sm.cdserm
                             LEFT JOIN tpmode tm ON tp.tpmode = tm.tpmode ';
      $andWhereSearchType = ' OR (tp.tpmode LIKE :search OR dstmod LIKE :search) OR (lm.dslinm LIKE :search OR dsserm LIKE :search)';

      if ($items['searchType'] == 2) {
        $searchFields .= ", COALESCE(sa.valore,'') AS bolla ";
        $leftJoinSearchType .= "LEFT JOIN sparti sa ON aa.cdarti = sa.cdarti AND sa.tpcomp = 'BOLLA' ";
        $andWhereSearchType .= ' OR (sa.valore LIKE :search)';
      }
    }
    // Barcode
    if (!empty($items['barcode'])) {
        $searchFields .= ', bc.nubrcd';
        $leftJoinSearchType .= " LEFT JOIN barcod bc ON aa.cdarti = bc.cdarti AND bc.nubrcd LIKE :barcode ";
        $params['barcode'] = $items['barcode'];
        $andWhereSearchType .= ' OR (bc.nubrcd IS NOT NULL)';
    }
    // Availability
    $isAvailable = '';
    $leftJoinArtcol = '';
    $havingNotAvailable = '';
    if ($items['isAvailabilityOrder']) {
      $whr1_av = '';
      $whr2_av = '';
      if ($items['isPT']) {
        $leftJoinArtcol = ' LEFT JOIN artcol ac ON ac.cdarti = aa.cdarti ';
        $whr1_av = ' AND oc2.cdcolo = dc2.cdcolo AND oc2.cdvari = dc2.cdvari ';
        $whr2_av = ' AND dc2.cdcolo = ac.cdcolo ';
      }

      $isAvailable = ",
        IF(MAX(
          COALESCE(
            (SELECT MAX(dc2.quanti -
              COALESCE(
                (SELECT SUM(og2.quanti)
                FROM octagl og2
                INNER JOIN occorp oc2 ON oc2.nurorc = og2.nurorc
                INNER JOIN octest ot2 ON ot2.nuordc = oc2.nuordc
                WHERE oc2.cdarti = dc2.cdarti $whr1_av AND ot2.flstat = 2 AND og2.dstagl = dc2.taglia), 0)
              ) AS quanti
            FROM dscorp dc2
            WHERE dc2.cdarti = aa.cdarti $whr2_av),
          0)
        ) > 0, true, false) AS is_available ";

      // If parameter "show not available" is false, filter not available items
      if (!$items['showNotAvailable']) {
        $havingNotAvailable = ' HAVING is_available = 1 ';
      }
    }

    $query = "SELECT COUNT(*) as totSearch
      FROM (
        SELECT aa.cdarti, $dsarti, tp.cdartn, $dsartn, tp.tppers $searchFields $isAvailable
        FROM ctarti ca
        INNER JOIN anaart aa ON aa.cdarti = ca.cdarti
        INNER JOIN tipolo tp ON tp.cdartn = aa.cdartn
        LEFT JOIN b2b_tipval ba ON ba.cdartn = tp.cdartn
        $leftJoinArtcol
        $leftJoinDsartn
        $leftJoinDsarti
        $leftJoinSearchType
        WHERE ca.cdcata = :cdcata
        AND tp.flbloc = 0 AND aa.flbloc = 0
        AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
        AND ((aa.cdarti LIKE :search OR dsarti LIKE :search) $andWhereSearchType)
        GROUP BY aa.cdarti
        $havingNotAvailable) AS res";
    $res = Di::getDefault()->get('db')->query($query, $params)->fetchAll();

    return count($res) == 1 ? $res[0]['totSearch'] : 0;
  }

  /**
   * Query:   SELECT
   * Return:  int
   */
  public static function getNumberOfArtColFromSearchForCurrentCatalog($items, $checkSearchType = true) {
    $params = array('cdcata' => $items['cdcata'], 'search' => $items['search']);

    // Dsartn, dsarti translation
    $dsartn = 'tp.dsartn AS dsartn';
    $dsarti = 'aa.dsarti AS dsarti';
    $leftJoinDsartn = '';
    $leftJoinDsarti = '';
    if ($items['idlang'] != 'IT') {
      $dsartn = 'COALESCE(d1.descri,tp.dsartn) AS dsartn';
      $dsarti = 'COALESCE(d2.descri,aa.dsarti) AS dsarti';
      $leftJoinDsartn = "LEFT JOIN deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = tp.cdartn AND d1.idlang = :idlang ";
      $leftJoinDsarti = "LEFT JOIN deslin d2 ON d2.tpdato = 'dsarti' AND d2.codic1 = aa.cdarti AND d2.idlang = :idlang ";
      $params['idlang'] = $items['idlang'];
    }

    // Search type
    $searchFields = '';
    $leftJoinSearchType = '';
    $andWhereSearchType = '';
    if ($checkSearchType && $items['searchType'] > 0) {
      $searchFields = ", tp.tpmode, COALESCE(tm.dstmod,'') AS dstmod, lm.dslinm, COALESCE(sm.dsserm,'') AS dsserm ";
      $leftJoinSearchType = 'INNER JOIN linmod lm ON tp.cdlinm = lm.cdlinm
                             LEFT JOIN sermod sm ON tp.cdlinm = sm.cdlinm AND tp.cdserm = sm.cdserm
                             LEFT JOIN tpmode tm ON tp.tpmode = tm.tpmode ';
      $andWhereSearchType = ' OR (tp.tpmode LIKE :search OR dstmod LIKE :search) OR (lm.dslinm LIKE :search OR dsserm LIKE :search)';

      if ($items['searchType'] == 2) {
        $searchFields .= ", COALESCE(sa.valore,'') AS bolla ";
        $leftJoinSearchType .= "LEFT JOIN sparti sa ON aa.cdarti = sa.cdarti AND sa.tpcomp = 'BOLLA' ";
        $andWhereSearchType .= ' OR (sa.valore LIKE :search)';
      }
    }
    // Barcode
    if (!empty($items['barcode'])) {
        $searchFields .= ', bc.nubrcd';
        $leftJoinSearchType .= " LEFT JOIN barcod bc ON aa.cdarti = bc.cdarti AND bc.nubrcd LIKE :barcode ";
        $params['barcode'] = $items['barcode'];
        $andWhereSearchType .= ' OR (bc.nubrcd IS NOT NULL)';
    }

    // Availability
    $isAvailable = '';
    $leftJoinArtcol = '';
    $havingNotAvailable = '';
    $whr1_av = '';
    $whr2_av = '';
    if ($items['isPT']) {
      $leftJoinArtcol = ' LEFT JOIN artcol ac ON ac.cdarti = aa.cdarti ';
      $whr1_av = ' AND oc2.cdcolo = dc2.cdcolo AND oc2.cdvari = dc2.cdvari ';
      $whr2_av = ' AND dc2.cdcolo = ac.cdcolo ';
    }
    if ($items['isAvailabilityOrder']) {

      $isAvailable = ",
        IF(MAX(
          COALESCE(
            (SELECT MAX(dc2.quanti -
              COALESCE(
                (SELECT SUM(og2.quanti)
                FROM octagl og2
                INNER JOIN occorp oc2 ON oc2.nurorc = og2.nurorc
                INNER JOIN octest ot2 ON ot2.nuordc = oc2.nuordc
                WHERE oc2.cdarti = dc2.cdarti $whr1_av AND ot2.flstat = 2 AND og2.dstagl = dc2.taglia), 0)
              ) AS quanti
            FROM dscorp dc2
            WHERE dc2.cdarti = aa.cdarti $whr2_av),
          0)
        ) > 0, true, false) AS is_available ";

      // If parameter "show not available" is false, filter not available items
      if (!$items['showNotAvailable']) {
        $havingNotAvailable = ' HAVING is_available = 1 ';
      }
    }

    $query = "SELECT COUNT(*) as totSearch
      FROM (
        SELECT aa.cdarti, ac.cdcolo, $dsarti, tp.cdartn, $dsartn, tp.tppers $searchFields $isAvailable
        FROM ctarti ca
        INNER JOIN anaart aa ON aa.cdarti = ca.cdarti
        INNER JOIN tipolo tp ON tp.cdartn = aa.cdartn
        LEFT JOIN b2b_tipval ba ON ba.cdartn = tp.cdartn
        $leftJoinArtcol
        $leftJoinDsartn
        $leftJoinDsarti
        $leftJoinSearchType
        WHERE ca.cdcata = :cdcata
        AND tp.flbloc = 0 AND aa.flbloc = 0 AND ac.flbloc = 0
        AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
        AND ((aa.cdarti LIKE :search OR dsarti LIKE :search) $andWhereSearchType)
        GROUP BY ac.cdcolo, aa.cdarti
        $havingNotAvailable) AS res";
    $res = Di::getDefault()->get('db')->query($query, $params)->fetchAll();
    return count($res) == 1 ? $res[0]['totSearch'] : 0;
  }

  /**
   * Query:   SELECT
   * Return:  int
   */
  public static function getNumberOfFabricsFromSearchForCurrentCatalog($items) {
    $params = array('cdcata' => $items['cdcata'], 'search' => $items['search']);

    $query = "SELECT COUNT(*) as totSearch
      FROM (
        SELECT ap.cdpers
        FROM ctarti ca
        INNER JOIN anaart aa ON aa.cdarti = ca.cdarti
        INNER JOIN anaper ap ON ap.cdpers = aa.cdpers
        INNER JOIN tipolo tp ON tp.cdartn = aa.cdartn
        LEFT JOIN b2b_tipval ba ON ba.cdartn = tp.cdartn
        WHERE ca.cdcata = :cdcata
        AND tp.flbloc = 0 AND aa.flbloc = 0
        AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
        AND (ap.cdpers LIKE :search OR ap.dspers LIKE :search)
        GROUP BY ap.cdpers
      ) AS res";
    $res = Di::getDefault()->get('db')->query($query, $params)->fetchAll();

    return count($res) == 1 ? $res[0]['totSearch'] : 0;
  }

  /**
   * Query:   SELECT
   * Return:  int
   */
  public static function getNumberOfArticlesForCurrentCatalog($cdcata) {
    $query = "SELECT COUNT(ca.cdarti) AS tot
      FROM Go2B\Models\Ctarti ca
      WHERE ca.cdcata = :cdcata:";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdcata' => $cdcata))[0]->tot;
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertArticleForCatalog($cdcata, $cdarti) {
    $ctarti = new self();
    $ctarti->cdcata = $cdcata;
    $ctarti->cdarti = $cdarti;
    $ctarti->seqrap = 0;
    $ctarti->save();
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertArticlesToCatalog($cdcata, $articles) {
    if (count($articles) > 0) {
      $query = 'INSERT IGNORE INTO ctarti (cdcata, cdarti, seqrap) VALUES ';
      $params = array(
        'cdcata' => $cdcata
      );

      for ($i = 0; $i < count($articles); $i++) {
        $query .= '(:cdcata, :cdarti' . $i . ', 0),';
        $params['cdarti' . $i] = $articles[$i]['cdarti'];
      }
      try {
        Di::getDefault()->get('db')->query(substr($query, 0, -1), $params);
      } catch (\Exception $e) {
        Di::getDefault()->get('logger')->info(print_r($e->getMessage(), true));
      }
    }
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertArticlesToCatalogFromModels($models, $cdcata) {
    if ($models != '' && count($models) > 0) {
      $where = '';
      $params = array('cdcata' => $cdcata);
      for ($i = 0; $i < count($models); $i++) {
        $where .= ':cdartn' . $i . ',';
        $params['cdartn' . $i] = $models[$i]['cdartn'];
      }
      $where = substr($where, 0, -1);

      $query =
        "INSERT IGNORE INTO ctarti (cdcata, cdarti, seqrap)
        SELECT :cdcata, a.cdarti, 0
        FROM anaart a
        INNER JOIN tipolo t ON t.cdartn = a.cdartn
        WHERE t.cdartn IN ($where)";
      Di::getDefault()->get('db')->query($query, $params);
    }
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertArticlesToCatalogFromLines($lines, $cdcata) {
    if ($lines != '' && count($lines) > 0) {
      $where = '';
      $params = array('cdcata' => $cdcata);
      for ($i = 0; $i < count($lines); $i++) {
        $where .= ':cdlinm' . $i . ',';
        $params['cdlinm' . $i] = $lines[$i]['cdlinm'];
      }
      $where = substr($where, 0, -1);

      $query =
        "INSERT IGNORE INTO ctarti (cdcata, cdarti, seqrap)
        SELECT :cdcata, a.cdarti, 0
        FROM anaart a
        INNER JOIN tipolo t ON t.cdartn = a.cdartn
        INNER JOIN linmod l On l.cdlinm = t.cdlinm
        WHERE l.cdlinm IN ($where)";
      Di::getDefault()->get('db')->query($query, $params);
    }
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertArticlesToCatalogFromSeasons($seasons, $cdcata) {
    if ($seasons != '' && count($seasons) > 0) {
      $where = '';
      $params = array('cdcata' => $cdcata);
      for ($i = 0; $i < count($seasons); $i++) {
        $where .= ':cdstag' . $i . ',';
        $params['cdstag' . $i] = $seasons[$i]['cdstag'];
      }
      $where = substr($where, 0, -1);

      $query =
        "INSERT IGNORE INTO ctarti (cdcata, cdarti, seqrap)
        SELECT :cdcata, a.cdarti, 0
        FROM anaart a
        INNER JOIN tipolo t ON t.cdartn = a.cdartn
        WHERE t.cdstag IN ($where)";
      Di::getDefault()->get('db')->query($query, $params);
    }
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllArticlesForCatalogAndBrand($cdcata, $cdtitl) {
    $query = "DELETE c.*
      FROM ctarti c
      INNER JOIN anaart a ON c.cdarti = a.cdarti
      INNER JOIN tipolo t ON a.cdartn = t.cdartn
      INNER JOIN linmod l ON t.cdlinm = l.cdlinm
      WHERE c.cdcata = :cdcata AND l.cdtitl = :cdtitl";
    Di::getDefault()->get('db')->query($query, array('cdcata' => $cdcata, 'cdtitl' => $cdtitl));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllArticlesForCatalogAndLine($cdcata, $cdlinm) {
    $query = "DELETE c.*
      FROM ctarti c
      INNER JOIN anaart a ON c.cdarti = a.cdarti
      INNER JOIN tipolo t ON a.cdartn = t.cdartn
      WHERE c.cdcata = :cdcata AND t.cdlinm = :cdlinm";
    Di::getDefault()->get('db')->query($query, array('cdcata' => $cdcata, 'cdlinm' => $cdlinm));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllArticlesForCatalogAndSeries($cdcata, $cdserm, $cdlinm) {
    $query = "DELETE c.*
      FROM ctarti c
      INNER JOIN anaart a ON c.cdarti = a.cdarti
      INNER JOIN tipolo t ON a.cdartn = t.cdartn
      WHERE c.cdcata = :cdcata AND t.cdlinm = :cdlinm AND t.cdserm = :cdserm";
    Di::getDefault()->get('db')->query($query, array('cdcata' => $cdcata, 'cdlinm' => $cdlinm, 'cdserm' => $cdserm));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllArticlesForCatalogAndModel($cdcata, $cdartn) {
    $query = "DELETE c.*
      FROM ctarti c
      INNER JOIN anaart a ON c.cdarti = a.cdarti
      WHERE c.cdcata = :cdcata AND a.cdartn = :cdartn";
    Di::getDefault()->get('db')->query($query, array('cdcata' => $cdcata, 'cdartn' => $cdartn));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteArticleFromCatalog($cdcata, $cdarti) {
    $query = "DELETE c.*
      FROM ctarti c
      WHERE c.cdcata = :cdcata AND c.cdarti = :cdarti";
    Di::getDefault()->get('db')->query($query, array('cdcata' => $cdcata, 'cdarti' => $cdarti));
  }

  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function emptyTable() {
    $query = "TRUNCATE ctarti";
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
