<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Ctanag extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdcata;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=2, nullable=false)
   */
  public $tpanag;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdanag;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('ctanag');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec) {
    $values = array(
      'cdcata' => isset($rec->cdcata) && (string)$rec->cdcata !== '' ? (string)$rec->cdcata : new RawValue('""'),
      'tpanag' => isset($rec->tpanag) && (string)$rec->tpanag !== '' ? (string)$rec->tpanag : new RawValue('""'),
      'cdanag' => isset($rec->cdanag) && (string)$rec->cdanag !== '' ? (string)$rec->cdanag : new RawValue('""')
    );

    // Always tipoagg = 'del'
    $row = new self();
    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateCustomerCode($oldcode, $cdanag) {
    $query = 'UPDATE ctanag c
      INNER JOIN anagra a ON a.tpanag = c.tpanag AND a.cdanag = c.cdanag
      SET c.tpanag = "CL", c.cdanag = :cdanag
      WHERE c.tpanag = "CN" AND c.cdanag = :oldcode AND a.cdblco = 0';
    Di::getDefault()->get('db')->query($query, array('cdanag' => $cdanag, 'oldcode' => $oldcode));
  }

  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function emptyTable() {
    $query = "TRUNCATE ctanag";
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
