<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Mvc\Model;

class Blocom extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=6, nullable=false)
   */
  public $cdblco;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dsblco;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $livblo;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('blocom');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdblco' => isset($rec->cdblco) && (string)$rec->cdblco !== '' ? (string)$rec->cdblco : 0,
      'dsblco' => isset($rec->dsblco) && (string)$rec->dsblco !== '' ? (string)$rec->dsblco : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0,
      'livblo' => isset($rec->livblo) && (string)$rec->livblo !== '' ? (string)$rec->livblo : 0
    );

    $query  = 'cdblco = :cdblco:';
    $params = array(
      'cdblco' => $values['cdblco']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion
}
