<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bUsrcpn extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Identity
   * @Column(type="integer", length=11, nullable=false)
   */
  public $id;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $id_usr;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $cdcoup;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $applcp;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_usrcpn');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  B2bUsrcpn object
   */
  public static function getUserCoupon($id_usr, $cdcoup, $checkLimit = false) {
    $params = array('id_usr' => $id_usr, 'cdcoup' => $cdcoup);
    $limit = $checkLimit ? 'AND uc.applcp > 0' : '';
    $query = "SELECT uc.id, uc.id_usr, uc.cdcoup, uc.applcp
      FROM Go2B\Models\B2bUsrcpn uc
      WHERE uc.id_usr = :id_usr: AND uc.cdcoup = :cdcoup:
      $limit";
    $usrcpn = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    return count($usrcpn) > 0 ? $uscrpn[0] : null;
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertCouponForUsers($cdcoup, $usrmax, $users) {
    $values = '';
    $i = 0;
    $params = array(
      'cdcoup' => $cdcoup,
      'applcp' => $usrmax
    );
    foreach ($users as $id) {
      $values .= "('', :id_usr" . $i . ", :cdcoup, :applcp),";
      $params['id_usr' . $i] = $cdcata;
      $i++;
    }
    $values = substr($values, 0, -1);
    $query = "INSERT INTO b2b_usrcpn (id, id_usr, cdcoup, applcp) VALUES $values";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllRecordsForCdcoup($cdcoup) {
    $query = 'DELETE uc
      FROM b2b_usrcpn uc
      WHERE uc.cdcoup = :cdcoup';
    Di::getDefault()->get('db')->query($query, array('cdcoup' => $cdcoup));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllRecordsForIdUsr($id_usr) {
    $query = 'DELETE uc
      FROM b2b_usrcpn uc
      WHERE uc.id_usr = :id_usr';
    Di::getDefault()->get('db')->query($query, array('id_usr' => $id_usr));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllRecordsForCoupons($coupons) {
    $params = array();
    $where  = 'WHERE ';
    for ($i = 0; $i < count($coupons); $i++) {
      $params['cdcoup' . $i] = $coupons[$i];
      $where .= ($i != 0 ? ' OR ' : '') . 'uc.cdcoup = :cdcoup' . $i;
    }
    $query = "DELETE uc
      FROM b2b_usrcpn uc
      $where ";
    Di::getDefault()->get('db')->query($query, $params);
  }
  //endregion
}
