<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bUsrana extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=11, nullable=false)
   */
  public $id;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $id_usr;

  /**
   *
   * @var string
   * @Column(type="string", length=2, nullable=false)
   */
  public $tpanag;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdanag;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_usrana');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateCustomerCode($oldcode, $cdanag) {
    $query = 'UPDATE b2b_usrana b
      INNER JOIN anagra a ON a.tpanag = b.tpanag AND a.cdanag = b.cdanag
      SET b.tpanag = "CL", b.cdanag = :cdanag
      WHERE b.tpanag = "CN" AND b.cdanag = :oldcode AND a.cdblco = 0';
    Di::getDefault()->get('db')->query($query, array('cdanag' => $cdanag, 'oldcode' => $oldcode));
  }
  //endregion
}
