<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bTkargo extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Identity
   * @Column(type="integer", length=6, nullable=false)
   */
  public $cdargo;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $dsargo;

  /**
   *
   * @var integer
   * @Column(type="integer", length=4, nullable=false)
   */
  public $flbloc;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_tkargo');
  }
  //endregion

  //region Custom queries
  /**
   * Inserts default values
   *
   * Query:   Insert
   * Return:  void
   */
  public static function populate() {
    $default = [
      array (
        'cdargo' => 100,
        'dsargo' => 'support.arg.other',
        'flbloc' => 0,
      ),
      array (
        'cdargo' => 1,
        'dsargo' => 'support.arg.damaged.item',
        'flbloc' => 0,
      ),
      array (
        'cdargo' => 2,
        'dsargo' => 'support.arg.not.delivered',
        'flbloc' => 0,
      )
      ];

      for ($i = 0; $i < count($default); $i++) {
        $tkargo = new B2bTkargo();
        $tkargo->cdargo = $default[$i]['cdargo'];
        $tkargo->dsargo = $default[$i]['dsargo'];
        $tkargo->flbloc = $default[$i]['flbloc'];
        $tkargo->save();
      }
  }
  //endregion
}
