<?php

namespace Go2B\Models;

use Go2B\Controllers\Utility;
use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bSysusr extends Model
{
    //region Consts
    const TYPE_SUPER_ADMIN = 1;
    const TYPE_ADMIN = 2;
    const TYPE_AGENT = 3;
    const TYPE_CUSTOMER = 4;
    const TYPE_SHIPPING = 5;
    const TYPE_SUPPORT = 6;
    //endregion

    //region Fields
    /**
     *
     * @var integer
     * @Primary
     * @Identity
     * @Column(type="integer", length=11, nullable=false)
     */
    public $id;

    /**
     *
     * @var string
     * @Column(type="string", length=255, nullable=false)
     */
    public $username;

    /**
     *
     * @var string
     * @Column(type="string", length=255, nullable=false)
     */
    public $password;

    /**
     *
     * @var integer
     * @Column(type="integer", length=1, nullable=false)
     */
    public $enabled;

    /**
     *
     * @var integer
     * @Column(type="integer", length=1, nullable=false)
     */
    public $orders_enabled;


    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $created_at;

    /**
     *
     * @var string
     * @Column(type="string", nullable=true)
     */
    public $last_login;

    /**
     *
     * @var integer
     * @Column(type="integer", length=2, nullable=false)
     */
    /* 1: super admin
     * 2: admin
     * 3: agent
     * 4: customer
     * 5: shipping
     * 6: support
     */
    public $type;

    /**
     *
     * @var string
     * @Column(type="string", length=2, nullable=true)
     */
    public $locale;

    /**
     *
     * @var string
     * @Column(type="string", nullable=true)
     */
    public $last_active;

    /**
     *
     * @var integer
     * @Column(type="integer", length=6, nullable=false)
     */
    public $email_sent;
    //endregion

    //region Default functions
    /**
     * Initialize method for model.
     */
    public function initialize()
    {
        /*$path = APP_PATH . '/app/config/config.ini';
        // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');*/
        $config = $this->getDI()->get('config');
        $this->setSchema($config->database->dbname);
        $this->setSource('b2b_sysusr');
    }
    //endregion

    //region Custom queries
    /**
     * Query:   SELECT
     * Return:  Array of B2bSysusr objects
     */
    public static function getUsersForAgent($cdagen)
    {
        $query = "SELECT s.id, s.username, s.enabled, u.cdagen, COUNT(o.nuordc) AS tot_orders
      FROM Go2B\Models\B2bSysusr s
      INNER JOIN Go2B\Models\B2bUsrage u ON u.id_usr = s.id
      LEFT JOIN Go2B\Models\Octest o ON o.id_usr = s.id
      WHERE u.cdagen = :cdagen:
      GROUP BY s.id
      ORDER BY s.id";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdagen' => $cdagen));
    }

    /**
     * Query:   SELECT
     * Return:  int
     */
    public static function getLicensesCount()
    {
        $query = "SELECT COUNT(b.username) AS licenses
      FROM Go2B\Models\B2bSysusr b
      WHERE b.type != 1 AND b.type != 2 AND b.enabled = 1";
        return Di::getDefault()->get('modelsManager')->executeQuery($query)[0]->licenses;
    }

    /**
     * Query:   UPDATE
     * Return:  void
     */
    public static function changeStatus($id, $type, $enabled)
    {
        $type = ($type !== 'orders_enabled' ? 'enabled' : 'orders_enabled');
        $query = 'UPDATE b2b_sysusr su
      SET su.' . $type . ' = :enabled
      WHERE su.id = :id';
        Di::getDefault()->get('db')->query($query, array('id' => $id, 'enabled' => $enabled));
    }

    /**
     * Query:   UPDATE
     * Return:  bool
     */
    public static function changePassword($username, $oldPassword, $newPassword)
    {
        $user = self::findFirst(array(
            "username = :username: AND password = :password: AND enabled = 1",
            'bind' => array('username' => $username, 'password' => sha1($oldPassword))
        ));

        if ($user) {
            $user->password = sha1($newPassword);
            return ($user->save());
        }

        return false;
    }

    public static function generateUserPasswordString($username, $standardOrNull = false)
    {
        if (!empty($username)) {
            // Scusate lo sfogo MA QUALE CAZZO DOVREBBE ESSERE IL PREFISSO PE STI CAZZO DE DATI???
            //          $config = Di::getDefault()->get('config');
            //          $prefix = $config->release->user;
            //          $prefix = strtolower(Di::getDefault()->get('utility')->getAppUtils('company'));
            $prefix = Di::getDefault()->get('utility')->getAppUtils('prefix');
            $standardUsernameRegex = '/^' . $prefix . '(\d+)$/i';
            if (preg_match($standardUsernameRegex, $username, $matches)) {
                $index = intval($matches[1]);
                return $prefix . "SNG" . sprintf('%05d', (100000 - $index));
            } else if (!$standardOrNull) {
                return Utility::generateRandomPassword(8);
            }
        }
        return null;
    }

    public function resetPassword($newPassword = null)
    {

        if (empty($newPassword)) {
            $newPassword = self::generateUserPasswordString($this->username);
        }

        if (empty($newPassword)) {
            throw new \Exception('Unable to reset user password');
        }

        $this->password = sha1($newPassword);

        if (!$this->save()) {
            throw new \Exception('Unable to store data while resetting user password');
        }

        return $newPassword;
    }

    /**
     * Query:   UPDATE
     * Return:  bool
     */
    public static function updateLanguage($id_usr, $language)
    {
        $query = 'UPDATE b2b_sysusr SET locale = :locale WHERE id = :id';
        return Di::getDefault()->get('db')->query($query, array('locale' => $language, 'id' => $id_usr));
    }

    /**
     * Query:   UPDATE
     * Return:  bool
     */
    public static function updateActivity($id_usr)
    {
        $query = 'UPDATE b2b_sysusr SET last_active = :now WHERE id = :id';
        return Di::getDefault()->get('db')->query($query, array('now' => date("Y-m-d H:i:s"), 'id' => $id_usr));
    }

    /**
     * Query:   DELETE
     * Return:  void
     */
    public static function deleteUser($id_usr)
    {
        $query = 'DELETE FROM b2b_sysusr WHERE id = :id';
        Di::getDefault()->get('db')->query($query, array('id' => $id_usr));
    }
    //endregion
}
