<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bSstest extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdspsl;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdcata;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $des_it;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $des_en;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $des_es;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $des_fr;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $des_de;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $flbloc;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_sstest');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of B2bSstest objects
   */
  public static function getSpecialSelectionForCatalog($cdcata, $idlang = 'it') {
    $descri = 'des_' . strtolower($idlang);
    $params = array('cdcata' => $cdcata);
    $query = "SELECT st.cdspsl, $descri AS descri, st.des_it, st.des_en, st.des_es,
      st.des_fr, st.des_de, st.flbloc, COALESCE(COUNT(sc.codice),0) AS num_products
      FROM Go2B\Models\B2bSstest st
      LEFT JOIN Go2B\Models\B2bSscorp sc ON st.cdspsl = sc.cdspsl
      WHERE st.cdcata = :cdcata:
      GROUP BY st.cdspsl";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  bool
   */
  public static function canBeInserted($cdspsl, $codice) {
    $params = array('cdspsl' => $cdspsl, 'codice' => $codice);

    $query = "SELECT COUNT(aa.cdarti) AS tot_products
      FROM Go2B\Models\B2bSstest st
      INNER JOIN Go2B\Models\Ctarti ca ON st.cdcata = ca.cdcata
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = ca.cdarti
      WHERE st.cdspsl = :cdspsl: AND (aa.cdarti = :codice: OR aa.cdartn = :codice:)";
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    return count($result) == 1 ? $result[0]->tot_products > 0 : false;
  }

  /**
   * Query:   INSERT
   * Return:  B2bSstest object
   */
  public static function insertNewSpecialSelection($cdcata, $des_it, $des_en, $des_es, $des_fr, $des_de) {
    $sstest = new self();
    $sstest->cdcata = $cdcata;
    $sstest->des_it = $des_it;
    $sstest->des_en = $des_en;
    $sstest->des_es = $des_es;
    $sstest->des_fr = $des_fr;
    $sstest->des_de = $des_de;
    $sstest->flbloc = 0;
    $sstest->save();

    return $sstest;
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function editSpecialSelection($cdspsl, $des_it, $des_en, $des_es, $des_fr, $des_de, $flbloc) {
    $params = array('cdspsl' => $cdspsl, 'des_it' => $des_it, 'des_en' => $des_en, 'des_es' => $des_es, 'des_fr' => $des_fr, 'des_de' => $des_de, 'flbloc' => $flbloc);
    $query = "UPDATE b2b_sstest st
      SET st.des_it = :des_it, st.des_en = :des_en, st.des_es = :des_es, st.des_fr = :des_fr, st.des_de = :des_de, st.flbloc = :flbloc
      WHERE st.cdspsl = :cdspsl";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteSpecialSelection($cdspsl) {
    $query = "DELETE st.*
      FROM b2b_sstest st
      WHERE st.cdspsl = :cdspsl";
    Di::getDefault()->get('db')->query($query, array('cdspsl' => $cdspsl));
  }
  //endregion
}
