<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bSscorp extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdspsl;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $codice;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $flimag;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_sscorp');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of B2bSscorp objects
   */
  public static function getAllModelsForSpecialSelection($cdspsl, $idlang) {
    $params = array('cdspsl' => $cdspsl);
    if ($idlang != 'IT') {
      $params['idlang'] = $idlang;
      $dsartn = 'COALESCE(d1.descri,tp.dsartn)';
      $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = tp.cdartn AND d1.idlang = :idlang: ";
    } else {
      $dsartn = 'tp.dsartn';
      $lnJoin = '';
    }
    $query = "SELECT sc.codice, $dsartn AS descri, sc.seqrap,
      sc.flimag AS custom_flimag, tp.flimag AS default_flimag
      FROM Go2B\Models\B2bSscorp sc
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = sc.codice
      $lnJoin
      WHERE sc.cdspsl = :cdspsl:
      GROUP BY sc.codice
      ORDER BY sc.seqrap";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of B2bSscorp objects
   */
  public static function getAllArticlesForSpecialSelection($cdspsl, $idlang) {
    $params = array('cdspsl' => $cdspsl);
    if ($idlang != 'IT') {
      $params['idlang'] = $idlang;
      $dsarti = 'COALESCE(d1.descri,aa.dsarti)';
      $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsarti' AND d1.codic1 = aa.cdarti AND d1.idlang = :idlang: ";
    } else {
      $dsarti = 'aa.dsarti';
      $lnJoin = '';
    }
    $query = "SELECT sc.codice, $dsarti AS descri, sc.seqrap,
      sc.flimag AS custom_flimag, aa.flimag AS default_flimag
      FROM Go2B\Models\B2bSscorp sc
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = sc.codice
      $lnJoin
      WHERE sc.cdspsl = :cdspsl:
      GROUP BY sc.codice
      ORDER BY sc.seqrap";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertNewProductForSpecialSelection($cdspsl, $codice, $seqrap, $flimag) {
    $params = array('cdspsl' => $cdspsl, 'codice' => $codice, 'seqrap' => $seqrap, 'flimag' => $flimag);
    $query = "INSERT INTO b2b_sscorp (cdspsl, codice, seqrap, flimag)
      VALUES (:cdspsl, :codice, :seqrap, :flimag)";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllProductsForSpecialSelection($cdspsl) {
    $query = "DELETE sc.*
      FROM b2b_sscorp sc
      WHERE sc.cdspsl = :cdspsl";
    Di::getDefault()->get('db')->query($query, array('cdspsl' => $cdspsl));
  }
  //endregion
}
