<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bReqacc extends Model
{
    //region Fields
    /**
     *
     * @var string
     * @Primary
     * @Column(type="string", length=80, nullable=false)
     */
    public $descri;

    /**
     *
     * @var string
     * @Primary
     * @Column(type="string", nullable=false)
     */
    public $dtcrea;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $dtelab;

    /**
     *
     * @var string
     * @Column(type="string", length=60)
     */
    public $dsetic;

    /**
     *
     * @var string
     * @Column(type="string", length=20, nullable=false)
     */
    public $ivacfi;

    /**
     *
     * @var string
     * @Column(type="string", length=60, nullable=false)
     */
    public $indema;

    /**
     *
     * @var string
     * @Column(type="string", length=40)
     */
    public $numtel;

    /**
     *
     * @var string
     * @Column(type="string", length=80, nullable=false)
     */
    public $indiri;

    /**
     *
     * @var string
     * @Column(type="string", length=60, nullable=false)
     */
    public $ccitta;

    /**
     *
     * @var string
     * @Column(type="string", length=60, nullable=false)
     */
    public $dsnazi;

    /**
     *
     * @var string
     * @Column(type="string", length=10)
     */
    public $provin;

    /**
     *
     * @var string
     * @Column(type="string", length=10)
     */
    public $codsid;

    /**
     *
     * @var string
     * @Column(type="string", length=10)
     */
    public $emapec;
    //endregion

    /**
     *
     * @var string
     * @Column(type="string", length=10)
     */
    public $desindi1;
    //endregion

    /**
     *
     * @var string
     * @Column(type="string", length=10)
     */
    public $descitta1;
    //endregion

    /**
     *
     * @var string
     * @Column(type="string", length=10)
     */
    public $desdsnazi1;
    //endregion

    /**
     *
     * @var string
     * @Column(type="string", length=10)
     */
    public $desprov1;
    //endregion

    /**
     *
     * @var string
     * @Column(type="string", length=10)
     */
    public $desindi2;
    //endregion

    /**
     *
     * @var string
     * @Column(type="string", length=10)
     */
    public $descitta2;
    //endregion

    /**
     *
     * @var string
     * @Column(type="string", length=10)
     */
    public $desdsnazi2;
    //endregion

    /**
     *
     * @var string
     * @Column(type="string", length=10)
     */
    public $desprov2;
    //endregion

    /**
     *
     * @var string
     * @Column(type="string", length=10)
     */
    public $desind3;
    //endregion

    /**
     *
     * @var string
     * @Column(type="string", length=10)
     */
    public $descitta3;
    //endregion

    /**
     *
     * @var string
     * @Column(type="string", length=10)
     */
    public $desdsnazi3;
    //endregion

    /**
     *
     * @var string
     * @Column(type="string", length=10)
     */
    public $desprov3;
    //endregion

    /**
     *
     * @var string
     * @Column(type="string", length=10)
     */
    public $desragsoc1;
    //endregion

    /**
     *
     * @var string
     * @Column(type="string", length=10)
     */
    public $desragsoc2;
    //endregion

    /**
     *
     * @var string
     * @Column(type="string", length=10)
     */
    public $desragsoc3;
    //endregion

    //region Default functions
    /**
     * Initialize method for model.
     */
    public function initialize()
    {
        $path   = realpath('..') . '/app/config/config.ini';
        // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
        $this->setSchema($config->database->dbname);
        $this->setSource('b2b_reqacc');
    }
    //endregion

    //region Custom queries
    /**
     * Query:   INSERT
     * Return:  void
     */
    public static function createAccessRequest($post)
    {
        $values = array(
            'dtcrea'     => date("Y-m-d H:i:s"),
            'descri'     => $post['descri'],
            'dsetic'     => $post['dsetic'] != '' ? $post['dsetic'] : new RawValue('""'),
            'ivacfi'     => $post['ivacfi'],
            'indema'     => $post['indema'],
            'numtel'     => $post['numtel'] != '' ? $post['numtel'] : new RawValue('""'),
            'indiri'     => $post['indiri'],
            'ccitta'     => $post['ccitta'],
            'dsnazi'     => $post['dsnazi'],
            'provin'     => $post['provin'] != '' ? $post['provin'] : new RawValue('""'),
            'codsid'     => $post['codsid'] != '' ? $post['codsid'] : new RawValue('""'),
            'emapec'     => $post['emapec'] != '' ? $post['emapec'] : new RawValue('""'),
            'desragsoc1' => $post['desragsoc1'],
            'desindi1'   => $post['desindi1'],
            'descitta1'  => $post['descitta1'],
            'desdsnazi1' => $post['desdsnazi1'],
            'desprov1'   => $post['desprov1'],
            'desragsoc2' => (isset($post['desragsoc2']) and $post['desragsoc2'] != '') ? $post['desragsoc2'] : new RawValue('""'),
            'desindi2'   => (isset($post['desindi2']) and $post['desindi2'] != '') ? $post['desindi2'] : new RawValue('""'),
            'descitta2'  => (isset($post['descitta2']) and $post['descitta2'] != '') ? $post['descitta2'] : new RawValue('""'),
            'desdsnazi2' => (isset($post['desdsnazi2']) and $post['desdsnazi2'] != '') ? $post['desdsnazi2'] : new RawValue('""'),
            'desprov2'   => (isset($post['desprov2']) and $post['desprov2'] != '') ? $post['desprov2'] : new RawValue('""'),
            'desragsoc3' => (isset($post['desragsoc3']) and $post['desragsoc3'] != '') ? $post['desragsoc3'] : new RawValue('""'),
            'desindi3'   => (isset($post['desindi3']) and $post['desindi3'] != '') ? $post['desindi3'] : new RawValue('""'),
            'descitta3'  => (isset($post['descitta3']) and $post['descitta3'] != '') ? $post['descitta3'] : new RawValue('""'),
            'desdsnazi3' => (isset($post['desdsnazi3']) and $post['desdsnazi3'] != '') ? $post['desdsnazi3'] : new RawValue('""'),
            'desprov3'   => (isset($post['desprov3']) and $post['desprov3'] != '') ? $post['desprov3'] : new RawValue('""'),

        );
        $reqacc = new self();
        $reqacc->save($values);
    }

    /**
     * Query:   UDPATE
     * Return:  void
     */
    public static function elaborateRequest($descri, $dtcrea)
    {
        $query = 'UPDATE b2b_reqacc ra
      SET ra.dtelab = :dtelab
      WHERE ra.descri = :descri AND ra.dtcrea = :dtcrea';
        Di::getDefault()->get('db')->query($query, array('descri' => $descri, 'dtcrea' => $dtcrea, 'dtelab' => date('Y-m-d')));
    }

    /**
     * Query:   DELETE
     * Return:  void
     */
    public static function deleteRequest($descri, $dtcrea)
    {
        $query = 'DELETE ra.* FROM b2b_reqacc ra
      WHERE ra.descri = :descri AND ra.dtcrea = :dtcrea';
        Di::getDefault()->get('db')->query($query, array('descri' => $descri, 'dtcrea' => $dtcrea));
    }
    //endregion
}
