<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bNdanag extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Identity
   * @Column(type="integer", length=11, nullable=false)
   */
  public $numana;

  /**
   *
   * @var string
   * @Column(type="string", length=2, nullable=false)
   */
  public $tpanag;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdanag;

  /**
   *
   * @var string
   * @Column(type="string", length=80, nullable=false)
   */
  public $descri;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $ccitta;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=true)
   */
  public $dsnazi;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=true)
   */
  public $indema;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_ndanag');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateCustomerCode($oldcode, $cdanag) {
    $query = 'UPDATE b2b_ndanag n
      INNER JOIN anagra a ON a.tpanag = n.tpanag AND a.cdanag = n.cdanag
      SET n.tpanag = "CL", n.cdanag = :cdanag
      WHERE n.tpanag = "CN" AND n.cdanag = :oldcode AND a.cdblco = 0';
    Di::getDefault()->get('db')->query($query, array('cdanag' => $cdanag, 'oldcode' => $oldcode));
  }
  //endregion
}
