<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bModinf extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdartn;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $dettit;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $detten;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $dettes;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $dettfr;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $dettde;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $madein;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $vestib;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $compos;

  /**
   *
   * @var integer
   * @Column(type="integer", nullable=true)
   */
  public $clsfz1;

  /**
   *
   * @var integer
   * @Column(type="integer", nullable=true)
   */
  public $clsfz2;

  /**
   *
   * @var integer
   * @Column(type="integer", nullable=true)
   */
  public $clsfz3;

  /**
   *
   * @var integer
   * @Column(type="integer", nullable=true)
   */
  public $clsfz4;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $filpdf;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $filvid;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_modinf');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertNewModelInfo($cdartn, $descit, $descen, $desces, $descfr, $descde, $dettit, $detten, $dettes, $dettfr, $dettde, $madein, $compos, $vestib, $clsfzList, $filpdf, $filvid) {
    $modinf = new self();
    $modinf->cdartn = $cdartn;
    $modinf->descit = !empty($descit) ? $descit : new RawValue('NULL');
    $modinf->descen = !empty($descen) ? $descen : new RawValue('NULL');
    $modinf->desces = !empty($desces) ? $desces : new RawValue('NULL');
    $modinf->descfr = !empty($descfr) ? $descfr : new RawValue('NULL');
    $modinf->descde = !empty($descde) ? $descde : new RawValue('NULL');
    $modinf->dettit = $dettit != '' ? $dettit : new RawValue('""');
    $modinf->detten = $detten != '' ? $detten : new RawValue('""');
    $modinf->dettes = $dettes != '' ? $dettes : new RawValue('""');
    $modinf->dettfr = $dettfr != '' ? $dettfr : new RawValue('""');
    $modinf->dettde = $dettde != '' ? $dettde : new RawValue('""');
    $modinf->madein = $madein != '' ? $madein : new RawValue('""');
    $modinf->compos = $compos != '' ? $compos : new RawValue('""');
    $modinf->vestib = $vestib != '' ? $vestib : new RawValue('""');
    $modinf->filpdf = $filpdf != '' ? $filpdf : new RawValue('""');
    $modinf->filvid = $filvid != '' ? $filvid : new RawValue('""');
    if (!empty($clsfzList)) {
      for ($i = 1; $i < 5; $i++) {
        if (!empty($clsfzList[$i])) {
          $modinf->{'clsfz' . $i} = $clsfzList[$i];
        } else {
          $modinf->{'clsfz' . $i} = new RawValue('NULL');
        }
      }
    }

    $modinf->save();
  }

  /**
   * Query:   DELETE
   * Return:  bool
   */
  public static function deleteAllModelInfo() {
    $query = 'DELETE m.* FROM b2b_modinf m';
    return Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
