<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bHpcorp extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdcata;

  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=2, nullable=false)
   */
  public $nubloc;

  /**
   *
   * @var integer
   * @Column(type="integer", length=2, nullable=false)
   */
  public $blsize;

  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=2, nullable=false)
   */
  public $seqrap;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=true)
   */
  public $des_it;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=true)
   */
  public $des_en;

  /**
   *
   * @var string
   * @Column(type="string", length=2, nullable=true)
   */
  public $tpbloc;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=true)
   */
  public $codice;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=true)
   */
  public $flimag;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=true)
   */
  public $des_es;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=true)
   */
  public $des_de;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=true)
   */
  public $des_fr;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_hpcorp');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertNewBlock($items) {
    $params = $items;
    $query = 'INSERT INTO b2b_hpcorp (cdcata, nubloc, blsize, seqrap, des_it,
      des_en, tpbloc, codice, flimag, des_es, des_de, des_fr)
      VALUES (:cdcata, :nubloc, :blsize, :seqrap, :des_it, :des_en, :tpbloc,
      :codice, :flimag, :des_es, :des_de, :des_fr)';
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteHomePageBlocksForCatalog($cdcata) {
    $query = 'DELETE FROM b2b_hpcorp WHERE cdcata = :cdcata';
    Di::getDefault()->get('db')->query($query, array('cdcata' => $cdcata));
  }
  //endregion
}
