<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bFlcorp extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Identity
   * @Column(type="integer", length=11, nullable=false)
   */
  public $numfil;

  /**
   *
   * @var string
   * @Column(type="integer", length=11, nullable=false)
   */
  public $nutpfl;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $codice;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_flcorp');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Anaart or Tpmode or Tpgene or Postgl objects
   */
  public static function getCustomFilterBody($type, $idlang) {
    switch ($type) {
      case 'dscolo':
        $what = "aa.dscolo AS codice, CONCAT(aa.cdcolo, ' - ', aa.dscolo) AS descri";
        $from = 'Go2B\Models\Anaart aa ';
        $code = 'aa.dscolo ';
        $gror = 'GROUP BY aa.dscolo
                 ORDER BY aa.dscolo, aa.cdcolo';
        break;
      case 'tpmode':
        $what = "tm.tpmode AS codice, CONCAT(tm.tpmode, ' - ', tm.dstmod) AS descri";
        $from = 'Go2B\Models\Tpmode tm ';
        $code = 'tm.tpmode ';
        $gror = 'GROUP BY tm.tpmode
                 ORDER BY tm.seqrap, tm.dstmod';
        break;
      case 'tpgene':
        $what = "tg.tpgene AS codice, CONCAT(tg.dsgene, ' - ', tg.dsgene) AS descri";
        $from = 'Go2B\Models\Tpgene tg ';
        $code = 'tg.tpgene ';
        $gror = 'GROUP BY tg.tpgene
                 ORDER BY tg.seqrap, tg.dsgene';
        break;
      case 'taglia':
        $what = 'DISTINCT pt.taglia AS codice, pt.taglia AS descri';
        $from = 'Go2B\Models\Postgl pt ';
        $code = 'pt.taglia ';
        $gror = 'GROUP BY pt.taglia
                 ORDER BY pt.taglia + 0, pt.cdtagl, pt.postgl';
        break;
      case 'cdpers':
        $what = 'aa.cdpers AS codice, aa.cdpers AS descri';
        $from = 'Go2B\Models\Anaart aa ';
        $code = 'aa.cdpers ';
        $gror = 'GROUP BY aa.cdpers
                 ORDER BY aa.cdpers';
        break;
    }
    $dsfilt = 'ft.des_' . $idlang;

    $query = "SELECT $what, COALESCE(fc.numfil, -1) AS numfil,
      COALESCE(fc.nutpfl, -1) AS nutpfl, COALESCE($dsfilt, '') AS dsfilt
      FROM $from
      LEFT JOIN Go2B\Models\B2bFlcorp fc ON fc.codice = $code
      LEFT JOIN Go2B\Models\B2bFltest ft ON ft.nutpfl = fc.nutpfl
      $gror";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }
  //endregion
}
