<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bDispor extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=11, nullable=false)
   */
  public $numdis;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=4, nullable=false)
   */
  public $tpport;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
//    // $path = realpath('..') . '/app/config/config.ini';
//    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_dispor');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertCustomDiscountForPorts($numdis, $ports) {
    $params = array('numdis' => $numdis);
    $values = '';
    $baseQuery  = 'INSERT INTO b2b_dispor (numdis, tpport) VALUES';

    // Loop to raw insert max 200 rows each query
    for ($i = 0; $i < count($ports); $i++) {
      $params['tpport' . $i] = $ports[$i];
      $values .= (!empty($values) ? ',': '') . " (:numdis, :tpport" . $i . ")";

      // Se e' il 200esimo elemento o l'ultimo
      if ($i % 200 == 0 || $i == count($ports) - 1) {
        //  Eseguo la query
        Di::getDefault()->get('db')->query($baseQuery . $values, $params);
        // Resetto i valori per il prossimo chunk
        $params = array('numdis' => $numdis);
        $values = '';
      }
    }
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllRecordsForNumdis($numdis) {
    $query = 'DELETE d FROM b2b_dispag d WHERE d.numdis = :numdis';
    Di::getDefault()->get('db')->query($query, array('numdis' => $numdis));
  }
  //endregion
}
