<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bDisana extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=11, nullable=false)
   */
  public $numdis;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=2, nullable=false)
   */
  public $tpanag;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdanag;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_disana');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertCustomDiscountForCustomers($numdis, $customers) {
    $params = array('numdis' => $numdis);
    $values = '';
    $query  = 'INSERT INTO b2b_disana (numdis, tpanag, cdanag) VALUES';

    // Loop to raw insert max 200 rows each query
    for ($i = 0; $i < count($customers); $i++) {
      if ($i > 0 && $i % 200 == 0) {
        $query .= substr($values, 0, -1);
        Di::getDefault()->get('db')->query($query, $params);

        $params = array('numdis' => $numdis);
        $values = '';
        $query  = 'INSERT INTO b2b_disana (numdis, tpanag, cdanag) VALUES';
      }

      $params['tpanag' . $i] = $customers[$i][0];
      $params['cdanag' . $i] = $customers[$i][1];
      $values .= "(:numdis, :tpanag" . $i . ", :cdanag" . $i . "),";
    }

    $query .= substr($values, 0, -1);
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateCustomerCode($oldcode, $cdanag) {
    $query = 'UPDATE b2b_disana d
      INNER JOIN anagra a ON a.tpanag = d.tpanag AND a.cdanag = d.cdanag
      SET d.tpanag = "CL", d.cdanag = :cdanag
      WHERE d.tpanag = "CN" AND d.cdanag = :oldcode AND a.cdblco = 0';
    Di::getDefault()->get('db')->query($query, array('cdanag' => $cdanag, 'oldcode' => $oldcode));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllRecordsForNumdis($numdis) {
    $query = 'DELETE d
      FROM b2b_disana d
      WHERE d.numdis = :numdis';
    Di::getDefault()->get('db')->query($query, array('numdis' => $numdis));
  }
  //endregion
}
