<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bCtllog extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Identity
   * @Column(type="integer", length=11, nullable=false)
   */
  public $nuoper;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdarti;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdcata;

  /**
   *
   * @var integer
   * @Column(type="integer", length=2, nullable=false)
   * 1: admin
   * 2: sync
   */
  public $tpresp;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11)
   */
  public $id_adm;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=false)
   */
  public $respon;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=false)
   */
  public $tpoper;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $tsoper;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_ctllog');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertLogOperation($cdarti, $cdcata, $tpresp, $tpoper, $respon, $id_adm = '') {
    $el = new self();
    $el->cdcata = $cdcata;
    $el->cdarti = $cdarti;
    $el->tpresp = $tpresp;
    $el->id_adm = $id_adm;
    $el->respon = $respon;
    $el->tpoper = $tpoper;
    $el->save();
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertLogOperationForDeleteCatalog($cdcata, $tpresp, $respon, $id_adm = '') {
    $params = array('cdcata' => $cdcata, 'tpresp' => $tpresp, 'respon' => $respon, 'id_adm' => $id_adm);
    $query =
      "INSERT IGNORE INTO b2b_ctllog (nuoper, cdarti, cdcata, tpresp, id_adm, respon, tpoper, tsoper)
      SELECT '', ca.cdarti, ca.cdcata, :tpresp, :id_adm, :respon, 'DELETE', CURRENT_TIMESTAMP
      FROM ctarti ca
      WHERE ca.cdcata = :cdcata";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertLogOperationForBrand($cdtitl, $cdcata, $tpresp, $tpoper, $respon, $id_adm = '') {
    $params = array('cdtitl' => $cdtitl, 'cdcata' => $cdcata, 'tpresp' => $tpresp, 'tpoper' => $tpoper,'respon' => $respon, 'id_adm' => $id_adm);
    $query =
      "INSERT IGNORE INTO b2b_ctllog (nuoper, cdarti, cdcata, tpresp, id_adm, respon, tpoper, tsoper)
      SELECT '', ca.cdarti, ca.cdcata, :tpresp, :id_adm, :respon, :tpoper, CURRENT_TIMESTAMP
      FROM ctarti ca
      INNER JOIN anaart aa ON ca.cdarti = aa.cdarti
      INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn
      INNER JOIN linmod lm ON tp.cdlinm = lm.cdlinm
      WHERE ca.cdcata = :cdcata AND lm.cdtitl = :cdtitl
      GROUP BY ca.cdarti";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertLogOperationForLine($cdlinm, $cdcata, $tpresp, $tpoper, $respon, $id_adm = '') {
    $params = array('cdlinm' => $cdlinm, 'cdcata' => $cdcata, 'tpresp' => $tpresp, 'tpoper' => $tpoper,'respon' => $respon, 'id_adm' => $id_adm);
    $query =
      "INSERT IGNORE INTO b2b_ctllog (nuoper, cdarti, cdcata, tpresp, id_adm, respon, tpoper, tsoper)
      SELECT '', ca.cdarti, ca.cdcata, :tpresp, :id_adm, :respon, :tpoper, CURRENT_TIMESTAMP
      FROM ctarti ca
      INNER JOIN anaart aa ON ca.cdarti = aa.cdarti
      INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn
      WHERE ca.cdcata = :cdcata AND tp.cdlinm = :cdlinm
      GROUP BY ca.cdarti";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertLogOperationForSeries($cdserm, $cdlinm, $cdcata, $tpresp, $tpoper, $respon, $id_adm = '') {
    $params = array('cdserm' => $cdserm, 'cdlinm' => $cdlinm, 'cdcata' => $cdcata, 'tpresp' => $tpresp, 'tpoper' => $tpoper, 'respon' => $respon, 'id_adm' => $id_adm);
    $query =
      "INSERT IGNORE INTO b2b_ctllog (nuoper, cdarti, cdcata, tpresp, id_adm, respon, tpoper, tsoper)
      SELECT '', ca.cdarti, ca.cdcata, :tpresp, :id_adm, :respon, :tpoper, CURRENT_TIMESTAMP
      FROM ctarti ca
      INNER JOIN anaart aa ON ca.cdarti = aa.cdarti
      INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn
      WHERE ca.cdcata = :cdcata AND tp.cdlinm = :cdlinm AND tp.cdserm = :cdserm
      GROUP BY ca.cdarti";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertLogOperationForModel($cdartn, $cdcata, $tpresp, $tpoper, $respon, $id_adm = '') {
    $params = array('cdartn' => $cdartn, 'cdcata' => $cdcata, 'tpresp' => $tpresp, 'tpoper' => $tpoper, 'respon' => $respon, 'id_adm' => $id_adm);
    $query =
      "INSERT IGNORE INTO b2b_ctllog (nuoper, cdarti, cdcata, tpresp, id_adm, respon, tpoper, tsoper)
      SELECT '', ca.cdarti, ca.cdcata, :tpresp, :id_adm, :respon, :tpoper, CURRENT_TIMESTAMP
      FROM ctarti ca
      INNER JOIN anaart aa ON ca.cdarti = aa.cdarti
      WHERE ca.cdcata = :cdcata AND aa.cdartn = :cdartn
      GROUP BY ca.cdarti";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertLogOperationForSeason($cdstag, $cdcata, $tpresp, $tpoper, $respon, $id_adm = '') {
    $params = array('cdstag' => $cdstag, 'cdcata' => $cdcata, 'tpresp' => $tpresp, 'tpoper' => $tpoper, 'respon' => $respon, 'id_adm' => $id_adm);
    $query =
      "INSERT IGNORE INTO b2b_ctllog (nuoper, cdarti, cdcata, tpresp, id_adm, respon, tpoper, tsoper)
      SELECT '', ca.cdarti, ca.cdcata, :tpresp, :id_adm, :respon, :tpoper, CURRENT_TIMESTAMP
      FROM ctarti ca
      INNER JOIN anaart aa ON ca.cdarti = aa.cdarti
      INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn
      WHERE ca.cdcata = :cdcata AND tp.cdstag = :cdstag
      GROUP BY ca.cdarti";
    Di::getDefault()->get('db')->query($query, $params);
  }
  //endregion
}
