<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bCoupon extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Identity
   * @Column(type="integer", length=11, nullable=false)
   */
  public $cdcoup;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dscoup;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $dtiniz;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $dtfine;

  /**
   *
   * @var integer
   * @Column(type="integer", length=2, nullable=false)
   */
  /* 0: free delivery
   * 1: % discount
   * 2: amount discount
   */
  public $tpcoup;

  /**
   *
   * @var double
   * @Column(type="double", length=10, nullable=false)
   */
  public $impsco;

  /**
   *
   * @var double
   * @Column(type="double", length=10, nullable=false)
   */
  public $qtamin;

  /**
   *
   * @var double
   * @Column(type="double", length=10, nullable=false)
   */
  public $qtamax;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $cpnmax;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $cpncnt;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $usrmax;

  /**
   *
   * @var integer
   * @Column(type="integer", length=1, nullable=false)
   */
  /* 0: all
   * 1: selected
   */
  public $tpcata;

  /**
   *
   * @var integer
   * @Column(type="integer", length=1, nullable=false)
   */
  /* 0: all
   * 1: all agents
   * 2: selected agents
   * 3: all customers
   * 4: selected customers
   * 5: all shippings
   * 6: selected shippings
   */
  public $tpuser;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_coupon');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of B2bCoupon objects
   */
  public static function getCoupon($dscoup, $qtatot) {
    $params = array('dscoup' => $dscoup, 'dtoggi' => date('Y-m-d'), 'qtatot' => $qtatot);
    $query = "SELECT cp.cdcoup, cp.dscoup, cp.dtiniz, cp.dtfine, cp.tpcoup,
      cp.impsco, cp.qtamin, cp.qtamax, cp.cpnmax, cp.cpncnt, cp.usrmax,
      cp.tpcata, cp.tpuser
      FROM Go2B\Models\B2bCoupon cp
      WHERE cp.dscoup = :dscoup:
      AND (cp.dtiniz <= :dtoggi: AND cp.dtfine >= :dtoggi:)
      AND COALESCE(cp.qtamin, 0) <= :qtatot:
      AND (COALESCE(cp.qtamax, 0) = 0 OR cp.qtamax >= :qtatot:)
      AND (cp.cpnmax = 0 OR cp.cpncnt = 0)
      ORDER BY cp.tpuser DESC, cp.cdcoup ASC";
      return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllRecordsForCoupons($coupons) {
    $params = array();
    $where  = 'WHERE ';
    for ($i = 0; $i < count($coupons); $i++) {
      $params['cdcoup' . $i] = $coupons[$i];
      $where .= ($i != 0 ? ' OR ' : '') . 'cp.cdcoup = :cdcoup' . $i;
    }
    $query = "DELETE cp
      FROM b2b_coupon cp
      $where ";
    Di::getDefault()->get('db')->query($query, $params);
  }
  //endregion
}
