<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bCatimg extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdcata;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=false)
   */
  public $flimag;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_catimg');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of B2bCatimg objects
   */
  public static function getCatalogsPresentation($id) {
    $query = "SELECT b.cdcata, c.dscata, b.seqrap, b.flimag
      FROM Go2B\Models\B2bCatimg b
      INNER JOIN Go2B\Models\Cttest c ON b.cdcata = c.cdcata
      INNER JOIN Go2B\Models\B2bUsrctl u ON c.cdcata = u.cdcata
      WHERE c.dtiniz <= CURRENT_DATE() AND c.dtfine >= CURRENT_DATE()
      AND u.id_usr = :id_usr:
      ORDER BY b.seqrap, b.cdcata";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('id_usr' => $id));
  }
  //endregion
}
