<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bBramod extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdlinm;

  /**
   *
   * @var string
   * @Column(type="string", length=4, nullable=false)
   */
  public $dwlist;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $dsbann;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=false)
   */
  public $fimag;
  //endregion

    /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=false)
   */
  public $cdling;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_bramod');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdlinm' => isset($rec->cdlinm) && (string)$rec->cdlinm !== '' ? (string)$rec->cdlinm : new RawValue('""'),
      'dwlist' => isset($rec->dwlist) && (string)$rec->dwlist !== '' ? (string)$rec->dwlist : new RawValue('""'),
      'dsbann' => isset($rec->dsbann) && (string)$rec->dsbann !== '' ? (string)$rec->dsbann : new RawValue('""'),
      'cdling' => isset($rec->cdling) && (string)$rec->cdling !== '' ? (string)$rec->cdling : new RawValue('""'),
      'flimag' => isset($rec->fimag) && (string)$rec->fimag !== '' ? (string)$rec->fimag : new RawValue('""')
    );

    $query  = 'cdlinm = :cdlinm: AND cdling = :cdling:';
    $params = array(
      'cdlinm' => $values['cdlinm'],
      'cdling' => $values['cdling']
      
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries

  /**
   * Query:   SELECT
   * Return:  Array of Linmod objects
   */
  public static function load($idlang) {
    
    $params = array('cdling' => strtolower($idlang));
    $query = "SELECT * FROM Go2B\Models\B2bBramod WHERE cdling = :cdling:";  
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);

  }



 
  /**
   * Query:   SELECT
   * Return:  Array of Linmod objects
   */
  public static function getExportBrand($cdlinm, $isOrder, $order_info, $customer) {  

    if ($isOrder) {

      /*$query = "SELECT aa.cdarti, aa.dsarti, aa.dscolo, aa.cdartn, tp.cdlinm, pt.taglia, rq.qtamin, lc.prezzo, lc.preven
      FROM Go2B\Models\Anaart aa 
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Postgl pt ON tp.cdtagl = pt.cdtagl
      INNER JOIN Go2B\Models\Lscorp lc ON aa.cdarti = lc.cdarti AND IFNULL(pt.taglia,'') = lc.taglia
      LEFT  JOIN Go2B\Models\Regqta rq ON aa.cdarti = rq.cdarti 
      WHERE tp.cdlinm = :cdlinm: AND lc.nulist = :nulist:
      GROUP BY aa.cdarti
      ORDER BY tp.cdlinm, aa.cdarti, pt.taglia"; 
        
      */

      $query = "SELECT aa.cdarti, aa.dsarti,tp.cdartn,aa.dscolo,aa.cdartn,tp.cdlinm,pt.taglia,
      IFNULL(rq.qtamin,1) AS qtamin,
      COALESCE(lc.prezzo,ln.prezzo) AS prezzo, 
      COALESCE(lc.preven,ln.preven) AS preven
      FROM Go2B\Models\Anaart aa
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      LEFT JOIN Go2B\Models\Postgl pt ON tp.cdtagl = pt.cdtagl
      LEFT JOIN Go2B\Models\Lscorp lc ON lc.nulist = :nulist: AND aa.cdarti = lc.cdarti AND IFNULL(pt.taglia,'') = lc.taglia
      LEFT JOIN Go2B\Models\Lscorp ln ON ln.nulist = :nulist: AND aa.cdarti = ln.cdarti AND ln.taglia = ''
      LEFT  JOIN Go2B\Models\Regqta rq ON aa.cdarti = rq.cdarti
      WHERE tp.cdlinm = :cdlinm:
      GROUP BY aa.cdarti, pt.taglia
      HAVING prezzo > 0
      ORDER BY tp.cdlinm, aa.cdarti, pt.taglia";


      return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdlinm' => $cdlinm, 'nulist' => $order_info->nulist));
 
    } else if ($customer != null) {

      /*$query = "SELECT aa.cdarti, aa.dsarti, aa.dscolo, aa.cdartn, tp.cdlinm, pt.taglia, rq.qtamin, lc.prezzo, lc.preven
      FROM Go2B\Models\Anaart aa 
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Postgl pt ON tp.cdtagl = pt.cdtagl
      INNER JOIN Go2B\Models\Lscorp lc ON aa.cdarti = lc.cdarti AND pt.taglia = lc.taglia
      LEFT  JOIN Go2B\Models\Regqta rq ON aa.cdarti = rq.cdarti 
      WHERE tp.cdlinm = :cdlinm: AND lc.nulist = :nulist:
      GROUP BY aa.cdarti
      ORDER BY tp.cdlinm, aa.cdarti, pt.taglia"; */
      
      $query = "SELECT aa.cdarti, aa.dsarti,tp.cdartn,aa.dscolo,aa.cdartn,tp.cdlinm,pt.taglia,
      IFNULL(rq.qtamin,1) AS qtamin,
      COALESCE(lc.prezzo,ln.prezzo) AS prezzo, 
      COALESCE(lc.preven,ln.preven) AS preven
      FROM Go2B\Models\Anaart aa
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      LEFT JOIN Go2B\Models\Postgl pt ON tp.cdtagl = pt.cdtagl
      LEFT JOIN Go2B\Models\Lscorp lc ON lc.nulist = :nulist: AND aa.cdarti = lc.cdarti AND IFNULL(pt.taglia,'') = lc.taglia
      LEFT JOIN Go2B\Models\Lscorp ln ON ln.nulist = :nulist: AND aa.cdarti = ln.cdarti AND ln.taglia = ''
      LEFT  JOIN Go2B\Models\Regqta rq ON aa.cdarti = rq.cdarti
      WHERE tp.cdlinm = :cdlinm:
      GROUP BY aa.cdarti, pt.taglia
      HAVING prezzo > 0
      ORDER BY tp.cdlinm, aa.cdarti, pt.taglia";


      return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdlinm' => $cdlinm, 'nulist' => $customer[0]->nulist));
    } else {

      $query = "SELECT aa.cdarti, aa.dsarti, aa.dscolo, aa.cdartn, tp.cdlinm, pt.taglia, rq.qtamin, '0' as prezzo, '0' as preven
                FROM Go2B\Models\Anaart aa 
                INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
                INNER JOIN Go2B\Models\Postgl pt ON tp.cdtagl = pt.cdtagl 
                LEFT  JOIN Go2B\Models\Regqta rq ON aa.cdarti = rq.cdarti 
                WHERE tp.cdlinm = :cdlinm:
                GROUP BY aa.cdarti
                ORDER BY tp.cdlinm, aa.cdarti, pt.taglia";
        
             


        return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdlinm' => $cdlinm));
    }


  }



  public static function getUserPricelistCode($user_id) {
    $query = "SELECT ua.tpanag, aa.nulist, ua.id_usr FROM Go2B\Models\B2bUsrana ua
              INNER JOIN Go2B\Models\Anagra  aa ON ua.cdanag = aa.cdanag
              WHERE ua.id_usr =  :idusr: ";
     return Di::getDefault()->get('modelsManager')->executeQuery($query, array('idusr' => $user_id));
  }
		



 
  /**
   * Query:   SELECT
   * Return:  Array of Linmod objects
   */
  public static function getAllBrandWithBanner() {
    $query = "SELECT lm.cdlinm AS code1, '' AS code2, lm.dslinm AS description, COALESCE(ai.valore,'') AS banner
      FROM Go2B\Models\Linmod lm
      LEFT JOIN Go2B\Models\B2bAddinf ai ON ai.tabell = 'linmod' AND ai.codic1 = lm.cdlinm AND ai.codic2 = '' AND ai.tpdato = 'banner'
      ORDER BY lm.dslinm";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }


  public static function insertBannerBrand($bramod) {
    foreach ($bramod as $item) { 

      if ($item->dsbann != "") {
        $bmod = new self();
        $bmod->cdlinm = $item->cdlinm;
        $bmod->dwlist = $item->dwlist;
        $bmod->dsbann = $item->dsbann;
        $bmod->cdling = $item->cdling;
        $bmod->fimag = $item->fimag;
        $bmod->save();
      }
     }

  }

  public static function deleteBannerBrand($cdling) {
    $query = 'DELETE ai.*
    FROM b2b_bramod ai WHERE ai.cdling = :cdling';
  Di::getDefault()->get('db')->query($query, array('cdling' => $cdling));

  }

  public static function updateImageBrand($cdling, $codic1, $codic2, $banner) {
    $query = 'UPDATE b2b_bramod ai
      SET ai.fimag = :fimag
      WHERE ai.cdlinm = :cdlinm AND ai.cdling = :cdling ';
    Di::getDefault()->get('db')->query($query, array('fimag'=> $banner, 'cdlinm' => $codic1, 'cdling' => $cdling));
  }

  public static function deleteImageBrand($cdling, $codic1, $codic2) {
    $query = 'UPDATE b2b_bramod ai
    SET ai.fimag = ""
    WHERE ai.cdlinm = :cdlinm AND ai.cdling = :cdling ';
    Di::getDefault()->get('db')->query($query, array('cdlinm' => $codic1, 'cdling' => $cdling));

  }
 
  //endregion
}
