<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bBgtest extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="integer", length=11, nullable=false)
   */
  public $nubudg;

  /**
   *
   * @var string
   * @Column(type="string", length=4, nullable=false)
   */
  public $tpanag;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdanag;

  /**
   *
   * @var string
   * @Column(type="string", length=4, nullable=false)
   */
  public $cdtitl;

  /**
   *
   * @var string
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdlinm;

  /**
   *
   * @var string
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdserm;

  /**
   *
   * @var string
   * @Column(type="string", length=10, nullable=false)
   */
  public $cduscc;

  /**
   *
   * @var string
   * @Column(type="string", length=4, nullable=false)
   */
  public $cdstag;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $qtabdg;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $valbdg;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $qtatrg;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $valtrg;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_bgtest');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of B2bBgtest objects
   */
  public static function getSortedBudgetsFromOrder($nuordc, $isLineSorting = true) {
    $params = array('nuordc' => $nuordc);
    $orderBy = $isLineSorting
      ? "bt.cdtitl, bt.cdlinm, bt.cdserm, bt.cduscc"
      : "bt.cduscc, bt.cdtitl, bt.cdlinm, bt.cdserm";
    $query = "SELECT DISTINCT bt.nubudg
      FROM Go2B\Models\B2bBgtest bt
      INNER JOIN Go2B\Models\Octest ot ON ot.tpanag = bt.tpanag AND ot.cdanag = bt.cdanag AND ot.cdstag = bt.cdstag
      WHERE ot.nuordc = :nuordc:
      ORDER BY $orderBy";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of B2bBgtest objects
   */
  public static function getSortedBudgetsFromCustomerAndSeason($tpanag, $cdanag, $cdstag, $isLineSorting = true) {
    $params = array('tpanag' => $tpanag, 'cdanag' => $cdanag, 'cdstag' => $cdstag);
    $orderBy = $isLineSorting
      ? "bt.cdtitl, bt.cdlinm, bt.cdserm, bt.cduscc"
      : "bt.cduscc, bt.cdtitl, bt.cdlinm, bt.cdserm";
    $query = "SELECT DISTINCT bt.nubudg
      FROM Go2B\Models\B2bBgtest bt
      WHERE bt.tpanag = :tpanag: AND bt.cdanag = :cdanag: AND bt.cdstag = :cdstag:
      ORDER BY $orderBy";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of B2bBgtest arrays
   */
  public static function getBudgetInfoFromOrder($nuordc) {
    $params = array('nuordc' => $nuordc);
    $query = "SELECT
      bto.nubudg,
      bto.cdtitl, COALESCE(tl.dstitl,'') AS dstitl,
      bto.cdlinm, COALESCE(lm.dslinm,'') AS dslinm,
      bto.cdserm, COALESCE(sm.dsserm,'') AS dsserm,
      bto.cduscc, COALESCE(ic.dsindo,'') AS dsuscc,
      bto.cdstag, COALESCE(tso.dsstag,'') AS dsstag,
      bto.qtabdg, bto.valbdg, bto.valbdg, bto.qtatrg, bto.valtrg,
      tb.cdstag AS stgcmp, COALESCE(ts.dsstag,'') AS dstcmp, IFNULL(bco.qtastg,0) AS qtacmp, IFNULL(bco.valstg,0) AS valcmp
      FROM b2b_bgtest bto
      INNER JOIN octest oto ON oto.tpanag = bto.tpanag AND oto.cdanag = bto.cdanag AND oto.cdstag = bto.cdstag
      INNER JOIN
        (SELECT bc.cdstag
        FROM b2b_bgcorp bc
        INNER JOIN b2b_bgtest bt ON bc.nubudg = bt.nubudg
        INNER JOIN octest ot ON ot.tpanag = bt.tpanag AND ot.cdanag = bt.cdanag AND ot.cdstag = bt.cdstag
        WHERE ot.nuordc = :nuordc
        GROUP BY bc.cdstag) AS tb
      LEFT JOIN titlin tl ON tl.cdtitl = bto.cdtitl
      LEFT JOIN linmod lm ON lm.cdlinm = bto.cdlinm
      LEFT JOIN sermod sm ON sm.cdlinm = bto.cdlinm AND sm.cdserm = bto.cdserm
      LEFT JOIN indorc ic ON ic.tpindo = bto.cduscc
      LEFT JOIN b2b_bgcorp bco ON bto.nubudg = bco.nubudg AND bco.cdstag = tb.cdstag
      LEFT JOIN tabstg ts ON ts.cdstag = tb.cdstag
      LEFT JOIN tabstg tso ON tso.cdstag = bto.cdstag
      WHERE oto.nuordc = :nuordc
      ORDER BY bto.nubudg, tb.cdstag";
    return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of B2bBgtest arrays
   */
  public static function getAllBudgetInfoFromCustomerAndSeason($tpanag, $cdanag, $cdstag) {
    $params = array('tpanag' => $tpanag, 'cdanag' => $cdanag, 'cdstag' => $cdstag);
    $query = "SELECT
      bto.nubudg,
      bto.cdtitl, COALESCE(tl.dstitl,'') AS dstitl,
      bto.cdlinm, COALESCE(lm.dslinm,'') AS dslinm,
      bto.cdserm, COALESCE(sm.dsserm,'') AS dsserm,
      bto.cduscc, COALESCE(ic.dsindo,'') AS dsuscc,
      bto.cdstag, COALESCE(tso.dsstag,'') AS dsstag,
      bto.qtabdg, bto.valbdg, bto.valbdg, bto.qtatrg, bto.valtrg,
      tb.cdstag AS stgcmp, COALESCE(ts.dsstag,'') AS dstcmp, IFNULL(bco.qtastg,0) AS qtacmp, IFNULL(bco.valstg,0) AS valcmp
      FROM b2b_bgtest bto
      INNER JOIN
        (SELECT bc.cdstag
        FROM b2b_bgcorp bc
        INNER JOIN b2b_bgtest bt ON bc.nubudg = bt.nubudg
        WHERE bt.tpanag = :tpanag AND bt.cdanag = :cdanag AND bt.cdstag = :cdstag
        GROUP BY bc.cdstag) AS tb
      LEFT JOIN titlin tl ON tl.cdtitl = bto.cdtitl
      LEFT JOIN linmod lm ON lm.cdlinm = bto.cdlinm
      LEFT JOIN sermod sm ON sm.cdlinm = bto.cdlinm AND sm.cdserm = bto.cdserm
      LEFT JOIN indorc ic ON ic.tpindo = bto.cduscc
      LEFT JOIN b2b_bgcorp bco ON bto.nubudg = bco.nubudg AND bco.cdstag = tb.cdstag
      LEFT JOIN tabstg ts ON ts.cdstag = tb.cdstag
      LEFT JOIN tabstg tso ON tso.cdstag = bto.cdstag
      WHERE bto.tpanag = :tpanag AND bto.cdanag = :cdanag AND bto.cdstag = :cdstag
      ORDER BY bto.nubudg, tb.cdstag";
    return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of B2bBgtest objects
   */
  public static function getBudgetInfoFromCustomerAndSeason($tpanag, $cdanag, $cdstag, $cmpSeasons, $columns, $isLineSorting = true) {
    $params = array('tpanag' => $tpanag, 'cdanag' => $cdanag, 'cdstag' => $cdstag);

    // Columns for season 0
    if (empty($columns)) {
      $fields = 'bt.qtabdg, bt.valbdg, bt.qtatrg, bt.valtrg,';
    } else {
      $fields = '';
      if (in_array(0, $columns)) {
        $fields .= 'bt.qtabdg, bt.valbdg,';
      }
      if (in_array(1, $columns)) {
        $fields .= 'bt.qtatrg, bt.valtrg,';
      }
    }

    // Comparing seasons
    $cmpFields = '';
    $cmpLeftJoins = '';
    $totstg = !empty($cmpSeasons) ? count($cmpSeasons) . ' AS totstg, ' : '0 AS totstg ';
    if (!empty($cmpSeasons)) {
      for ($i = 0; $i < count($cmpSeasons); $i++) {
        $index = $i + 1;
        $cmpFields .= ":cdstg$index: AS cdstg$index, COALESCE(s$index.dsstag,'') AS dsstg$index,";
        $cmpFields .= "COALESCE(bc$index.qtastg,0) AS qtast$index, COALESCE(bc$index.valstg,0) AS valst$index,";
        $cmpLeftJoins .= "LEFT JOIN Go2B\Models\B2bBgcorp bc$index ON bc$index.nubudg = bt.nubudg AND bc$index.cdstag = :cdstg$index: ";
        $cmpLeftJoins .= "LEFT JOIN Go2B\Models\Tabstg s$index ON s$index.cdstag = :cdstg$index: ";
        $params['cdstg' . $index] = $cmpSeasons[$i];
      }
      $cmpFields = substr($cmpFields, 0, -1);
    }

    // Ordering
    $orderBy = $isLineSorting
      ? "bt.cdtitl, bt.cdlinm, bt.cdserm, bt.cduscc"
      : "bt.cduscc, bt.cdtitl, bt.cdlinm, bt.cdserm";

    $query = "SELECT
      bt.cduscc, COALESCE(ic.dsindo,'') AS dsuscc,
      bt.cdtitl, COALESCE(tl.dstitl,'') AS dstitl,
      bt.cdlinm, COALESCE(lm.dslinm,'') AS dslinm,
      bt.cdserm, COALESCE(sm.dsserm,'') AS dsserm,
      bt.cdstag, COALESCE(s0.dsstag,'') AS dsstag, $fields
      $totstg
      $cmpFields
      FROM Go2B\Models\B2bBgtest bt
      LEFT JOIN Go2B\Models\Tabstg s0 ON s0.cdstag = bt.cdstag
      $cmpLeftJoins
      LEFT JOIN Go2B\Models\Indorc ic ON ic.tpindo = bt.cduscc
      LEFT JOIN Go2B\Models\Titlin tl ON tl.cdtitl = bt.cdtitl
      LEFT JOIN Go2B\Models\Linmod lm ON lm.cdlinm = bt.cdlinm
      LEFT JOIN Go2B\Models\Sermod sm ON sm.cdlinm = bt.cdlinm AND sm.cdserm = bt.cdserm
      WHERE bt.tpanag = :tpanag: AND bt.cdanag = :cdanag: AND bt.cdstag = :cdstag:
      ORDER BY bt.cdstag, $orderBy";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of B2bBgtest objects
   */
  public static function getGlobalBudgetInfoFromSeason($cdstag, $cmpSeasons, $columns, $line, $drop) {
    $params = array('cdstag' => $cdstag);

    // Columns for season 0
    if (empty($columns)) {
      $fields = 'SUM(bt.qtabdg) AS qtabdg, SUM(bt.valbdg) AS valbdg, SUM(bt.qtatrg) AS qtatrg, SUM(bt.valtrg) AS valtrg,';
    } else {
      $fields = '';
      if (in_array(0, $columns)) {
        $fields .= 'SUM(bt.qtabdg) AS qtabdg, SUM(bt.valbdg) AS valbdg,';
      }
      if (in_array(1, $columns)) {
        $fields .= 'SUM(bt.qtatrg) AS qtatrg, SUM(bt.valtrg) AS valtrg,';
      }
    }

    $andWhere = '';

    // Line filter
    if ($line != -1) {
      $andWhere .= ' AND bt.cdlinm = :cdlinm: ';
      $params['cdlinm'] = $line;
    }

    // Drop filter
    if ($drop != -1) {
      $andWhere .= ' AND bt.cduscc = :cduscc: ';
      $params['cduscc'] = $drop;
    }

    // Comparing seasons
    $cmpFields = '';
    $cmpLeftJoins = '';
    $totstg = !empty($cmpSeasons) ? count($cmpSeasons) . ' AS totstg, ' : '0 AS totstg ';
    if (!empty($cmpSeasons)) {
      for ($i = 0; $i < count($cmpSeasons); $i++) {
        $index = $i + 1;
        $cmpFields .= ":cdstg$index: AS cdstg$index, COALESCE(s$index.dsstag,'') AS dsstg$index,";
        $cmpFields .= "COALESCE(SUM(bc$index.qtastg),0) AS qtast$index, COALESCE(SUM(bc$index.valstg),0) AS valst$index,";
        $cmpLeftJoins .= "LEFT JOIN Go2B\Models\B2bBgcorp bc$index ON bc$index.nubudg = bt.nubudg AND bc$index.cdstag = :cdstg$index: ";
        $cmpLeftJoins .= "LEFT JOIN Go2B\Models\Tabstg s$index ON s$index.cdstag = :cdstg$index: ";
        $params['cdstg' . $index] = $cmpSeasons[$i];
      }
      $cmpFields = substr($cmpFields, 0, -1);
    }

    $query = "SELECT
      bt.tpanag, bt.cdanag, COALESCE(aa.descri,'') AS descri, COALESCE(lt.cdvalu,'EUR') AS cdvalu,
      bt.cdstag, COALESCE(s0.dsstag,'') AS dsstag, $fields
      $totstg
      $cmpFields
      FROM Go2B\Models\B2bBgtest bt
      LEFT JOIN Go2B\Models\Anagra aa ON bt.tpanag = aa.tpanag AND bt.cdanag = aa.cdanag
      LEFT JOIN Go2B\Models\Tabstg s0 ON s0.cdstag = bt.cdstag
      LEFT JOIN Go2B\Models\Lstest lt ON aa.nulist = lt.nulist
      $cmpLeftJoins
      WHERE bt.cdstag = :cdstag:
      GROUP BY bt.tpanag, bt.cdanag
      ORDER BY descri";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of B2bBgtest objects
   */
  public static function getAllDrops() {
    $query = "SELECT DISTINCT bt.cduscc, COALESCE(ic.dsindo,'') AS dsuscc
      FROM Go2B\Models\B2bBgtest bt
      LEFT JOIN Go2B\Models\Indorc ic ON ic.tpindo = bt.cduscc";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of B2bBgtest objects
   */
  public static function getReferenceSeasons() {
    $query = "SELECT DISTINCT bt.cdstag, COALESCE(ts.dsstag,'') AS dsstag
      FROM Go2B\Models\B2bBgtest bt
      LEFT JOIN Go2B\Models\Tabstg ts ON ts.cdstag = bt.cdstag
      ORDER BY bt.cdstag DESC";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function emptyTable() {
    $query = "TRUNCATE b2b_bgtest";
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
