<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bAddinf extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=6, nullable=false)
   */
  public $tabell;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $codic1;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $codic2;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=6, nullable=false)
   */
  public $tpdato;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=false)
   */
  public $valore;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_addinf');
  }

  /**
   * Checks record uniqueness before to save
   *
   * @return bool
   */
  public function validation() {
    $validator = new \Phalcon\Validation();
    $validator->add(
      array(
        'tabell',
        'codic1',
        'codic2',
        'tpdato'
      ),
      new \Phalcon\Validation\Validator\Uniqueness()
    );
    return $this->validate($validator);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of B2bAddinf objects
   */
  public static function getPdfConditionsForCatalog($cdcata, $idlang = '') {
    $params = array('cdcata' => $cdcata);
    $andIdlang = '';
    if ($idlang != '') {
      $params['idlang'] = $idlang;
      $andIdlang = "AND ai.codic2 = :idlang:";
    }

    $query = "SELECT ai.codic2 AS idlang, ai.valore
      FROM \Go2B\Models\B2bAddinf ai
      WHERE ai.tabell = 'cttest' AND ai.codic1 = :cdcata: $andIdlang AND ai.tpdato = 'pdfcnd' ";
    $addinf = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);

    return $addinf;
  }

  /**
   * Query:   SELECT
   * Return:  B2bAddinf object
   */
  public static function getAgentEmail($cdagen) {
    return self::findFirst(array('tabell = "anaage" AND codic1 = :cdagen: AND codic2 = "" AND tpdato = "indema"', 'bind' => array('cdagen' => $cdagen)));
  }

  /**
   * Query:   SELECT
   * Return:  B2bAddinf object
   */
  public static function getAgentDifferentBehaviourFlag($cdagen) {
    return self::findFirst(array('tabell = "anaage" AND codic1 = :cdagen: AND codic2 = "" AND tpdato = "fldfbh"', 'bind' => array('cdagen' => $cdagen)));
  }

  /**
   * Query:   SELECT
   * Return:  string
   */
  public static function getEmailForAgentFromCustomerUserId($id) {
    $query = 'SELECT COALESCE(ai.valore,"") AS indema
      FROM Go2B\Models\B2bAddinf ai
      INNER JOIN Go2B\Models\Anagra ag ON ag.cdagen = ai.codic1
      INNER JOIN Go2B\Models\B2bUsrana ua ON ua.tpanag = ag.tpanag AND ua.cdanag = ag.cdanag
      WHERE ai.tabell = "anaage" AND ai.codic2 = "" AND ai.tpdato = "indema" AND ag.tpanag = "CL" AND ua.id_usr = :id:';
    $addinf = Di::getDefault()->get('modelsManager')->executeQuery($query, array('id' => $id));

    return count($addinf) > 0 ? $addinf[0]->indema : '';
  }

  /**
   * Query:   SELECT
   * Return:  string
   */
  public static function getEmailForAgentFromUserId($id) {
    $query = 'SELECT COALESCE(ai.valore,"") AS indema
      FROM b2b_addinf ai
      INNER JOIN b2b_usrage ua ON ai.codic1 = ua.cdagen
      WHERE ai.tabell = "anaage" AND ai.codic2 = "" AND ai.tpdato = "indema" AND ua.id_usr = :id ';
    $addinf = Di::getDefault()->get('db')->query($query, array('id' => $id))->fetchAll();

    return count($addinf) > 0 ? $addinf[0]['indema'] : '';
  }

  /**
   * Query:   SELECT
   * Return:  string
   */
  public static function getThreeDimensionalImageForModel($cdartn) {
    $query = 'SELECT ai.valore AS fl360d
      FROM b2b_addinf ai
      WHERE ai.tabell = "tipolo" AND ai.codic1 = :cdartn AND ai.tpdato = "fl360d" ';
    $addinf = Di::getDefault()->get('db')->query($query, array('cdartn' => $cdartn))->fetchAll();

    return count($addinf) > 0 ? $addinf[0]['fl360d'] : '';
  }

  /**
   * Query:   SELECT
   * Return:  string
   */
  public static function getCustomLogoForCatalog($cdcata) {
    $query = 'SELECT ai.valore AS logo
      FROM b2b_addinf ai
      WHERE ai.tabell = "cttest" AND ai.codic1 = :cdcata AND ai.tpdato = "flimag" ';
    $addinf = Di::getDefault()->get('db')->query($query, array('cdcata' => $cdcata))->fetchAll();

    return count($addinf) > 0 ? $addinf[0]['logo'] : '';
  }

  /**
   * Query:   SELECT
   * Return:  bool
   */
  public static function isSpecialAgent($id_usr) {
    $query = 'SELECT ai.valore AS fldfbh
      FROM b2b_addinf ai
      INNER JOIN b2b_usrage ua ON ua.cdagen = ai.codic1
      WHERE ai.tabell = "anaage" AND ai.codic2 = "" AND ai.tpdato = "fldfbh" AND ua.id_usr = :id_usr ';
    $addinf = Di::getDefault()->get('db')->query($query, array('id_usr' => $id_usr))->fetchAll();

    return count($addinf) > 0 ? $addinf[0]['fldfbh'] == 1 : false;
  }

  /**
   * Query:   SELECT
   * Return:  bool
   */
  public static function hasCustomSortingForCatalog($cdcata) {
    $query = 'SELECT ai.valore AS seqtip
      FROM b2b_addinf ai
      WHERE ai.tabell = "cttest" AND ai.codic1 = :cdcata AND ai.codic2 = "" AND ai.tpdato = "seqtip" ';
    $addinf = Di::getDefault()->get('db')->query($query, array('cdcata' => $cdcata))->fetchAll();

    return count($addinf) > 0 ? $addinf[0]['seqtip'] == 1 : false;
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertLocalizedDescription($table, $code1, $code2, $tpdato, $valore) {
    $addinf = new self();
    $addinf->tabell = $table;
    $addinf->codic1 = $code1;
    $addinf->codic2 = $code2 != '' ? $code2 : new RawValue('""');
    $addinf->tpdato = $tpdato;
    $addinf->valore = $valore;
    $addinf->save();
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertAgentEmail($cdagen, $indema) {
    $addinf = new self();
    $addinf->tabell = 'anaage';
    $addinf->codic1 = $cdagen;
    $addinf->codic2 = new RawValue('""');
    $addinf->tpdato = 'indema';
    $addinf->valore = $indema;
    $addinf->save();
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertAgentDifferentBehaviourFlag($cdagen, $fldfbh) {
    $addinf = new self();
    $addinf->tabell = 'anaage';
    $addinf->codic1 = $cdagen;
    $addinf->codic2 = new RawValue('""');
    $addinf->tpdato = 'fldfbh';
    $addinf->valore = $fldfbh;
    $addinf->save();
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertSelectablePriceListsForAgent($cdagen, $nulist, $i) {
    $addinf = new self();
    $addinf->tabell = 'anaage';
    $addinf->codic1 = $cdagen;
    $addinf->codic2 = $i;
    $addinf->tpdato = 'nulist';
    $addinf->valore = $nulist;
    $addinf->save();
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertCategoryBanner($table, $codic1, $codic2, $banner) {
    $addinf = new self();
    $addinf->tabell = $table;
    $addinf->codic1 = $codic1;
    $addinf->codic2 = $table == 'sermod' ? $codic2 : new RawValue('""');
    $addinf->tpdato = 'banner';
    $addinf->valore = $banner;
    $addinf->save();
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertCustomLogoForCatalog($codic1, $flimag) {
    $addinf = new self();
    $addinf->tabell = 'cttest';
    $addinf->codic1 = $codic1;
    $addinf->codic2 = new RawValue('""');
    $addinf->tpdato = 'flimag';
    $addinf->valore = $flimag;
    $addinf->save();
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertDoubleRowsFlagForOrder($nuordc, $fldbrw) {
    $addinf = new self();
    $addinf->tabell = 'octest';
    $addinf->codic1 = $nuordc;
    $addinf->codic2 = new RawValue('""');
    $addinf->tpdato = 'fldbrw';
    $addinf->valore = $fldbrw;
    $addinf->save();
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertPdfConditionCatalog($cdcata, $idlang, $file) {
    $query = 'REPLACE INTO b2b_addinf (tabell, codic1, codic2, tpdato, valore)
      VALUES ("cttest", :cdcata, :idlang, "pdfcnd", :file)';
    Di::getDefault()->get('db')->query($query, array('cdcata' => $cdcata, 'idlang' => $idlang, 'file' => $file));
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertCustomSortingFlagForCatalog($cdcata) {
    $query = 'REPLACE INTO b2b_addinf (tabell, codic1, codic2, tpdato, valore)
      VALUES ("cttest", :cdcata, "", "seqtip", 1)';
    Di::getDefault()->get('db')->query($query, array('cdcata' => $cdcata));
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertCustomSeqrap($cdartn, $field, $index) {
    $query = 'REPLACE INTO b2b_addinf (tabell, codic1, codic2, tpdato, valore)
      VALUES ("tipolo", :cdartn, "", :field, :index)';
    Di::getDefault()->get('db')->query($query, array('cdartn' => $cdartn, 'field' => $field, 'index' => $index));
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateAgentEmail($cdagen, $indema) {
    $query = 'UPDATE b2b_addinf ai
      SET ai.valore = :indema
      WHERE ai.tabell = "anaage" AND ai.codic1 = :cdagen AND ai.codic2 = "" AND ai.tpdato = "indema" ';
    Di::getDefault()->get('db')->query($query, array('cdagen' => $cdagen, 'indema' => $indema));
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateAgentDifferentBehaviourFlag($cdagen, $indema) {
    $query = 'UPDATE b2b_addinf ai
      SET ai.valore = :indema
      WHERE ai.tabell = "anaage" AND ai.codic1 = :cdagen AND ai.codic2 = "" AND ai.tpdato = "fldfbh" ';
    Di::getDefault()->get('db')->query($query, array('cdagen' => $cdagen, 'indema' => $indema));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAgentEmail($cdagen) {
    $query = 'DELETE ai.*
      FROM b2b_addinf ai
      WHERE ai.tabell = "anaage" AND ai.codic1 = :cdagen AND ai.codic2 = "" AND ai.tpdato = "indema" ';
    Di::getDefault()->get('db')->query($query, array('cdagen' => $cdagen));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deletePdfConditionCatalog($cdcata, $idlang) {
    $query = 'DELETE ai.*
      FROM b2b_addinf ai
      WHERE ai.tabell = "cttest" AND ai.codic1 = :cdcata AND ai.codic2 = :idlang AND ai.tpdato = "pdfcnd" ';
    Di::getDefault()->get('db')->query($query, array('cdcata' => $cdcata, 'idlang' => $idlang));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAgentDifferentBehaviourFlag($cdagen) {
    $query = 'DELETE ai.*
      FROM b2b_addinf ai
      WHERE ai.tabell = "anaage" AND ai.codic1 = :cdagen AND ai.codic2 = "" AND ai.tpdato = "fldfbh" ';
    Di::getDefault()->get('db')->query($query, array('cdagen' => $cdagen));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteSelectablePriceListsForAgent($cdagen) {
    $query = 'DELETE ai.*
      FROM b2b_addinf ai
      WHERE ai.tabell = "anaage" AND ai.codic1 = :cdagen AND ai.tpdato = "nulist" ';
    Di::getDefault()->get('db')->query($query, array('cdagen' => $cdagen));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllLocalizedDescriptions($table) {
    $query = 'DELETE ai.*
      FROM b2b_addinf ai
      WHERE ai.tabell = :table AND ai.tpdato IN ("des_it","des_en","des_es","des_de","des_fr")';
    Di::getDefault()->get('db')->query($query, array('table' => $table));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteCustomLogoForCatalog($cdcata) {
    $query = 'DELETE ai.*
      FROM b2b_addinf ai
      WHERE ai.tabell = "cttest" AND ai.codic1 = :cdcata AND ai.codic2 = "" AND ai.tpdato = "flimag"';
    Di::getDefault()->get('db')->query($query, array('cdcata' => $cdcata));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteCustomSortingFlagForCatalog($cdcata) {
    $query = 'DELETE ai.*
      FROM b2b_addinf ai
      WHERE ai.tabell = "cttest" AND ai.codic1 = :cdcata AND ai.codic2 = "" AND ai.tpdato = "seqtip"';
    Di::getDefault()->get('db')->query($query, array('cdcata' => $cdcata));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteCustomSortingForCatalog($cdcata) {
    $query = 'DELETE ai.*
      FROM b2b_addinf ai
      INNER JOIN anaart aa ON aa.cdartn = ai.codic1
      INNER JOIN ctarti ca ON ca.cdarti = aa.cdarti
      WHERE ai.tabell = "tipolo" AND ai.codic2 = "" AND ai.tpdato LIKE "seqra%" AND ca.cdcata = :cdcata';
    Di::getDefault()->get('db')->query($query, array('cdcata' => $cdcata));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteCategoryBanner($table, $codic1, $codic2) {
    if ($table == 'sermod') {
      $params = array('table' => $table, 'codic1' => $codic1, 'codic2' => $codic2);
      $andWhere = ' ai.codic1 = :codic1 AND ai.codic2 = :codic2 AND ai.tpdato = "banner" ';
    } else {
      $params = array('table' => $table, 'codic1' => $codic1);
      $andWhere = ' ai.codic1 = :codic1 AND ai.codic2 = "" AND ai.tpdato = "banner" ';
    }

    $query = "DELETE ai.*
      FROM b2b_addinf ai
      WHERE ai.tabell = :table AND $andWhere";
    Di::getDefault()->get('db')->query($query, $params);
  }
  //endregion
}
