<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Astest extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdtagl;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdasso;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $quanti;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('astest');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdtagl' => isset($rec->cdtagl) && (string)$rec->cdtagl !== '' ? (string)$rec->cdtagl : new RawValue('""'),
      'cdasso' => isset($rec->cdasso) && (string)$rec->cdasso !== '' ? (string)$rec->cdasso : new RawValue('""'),
      'quanti' => isset($rec->quanti) && (string)$rec->quanti !== '' ? (string)$rec->quanti : 0
    );

    $query  = 'cdtagl = :cdtagl: AND cdasso = :cdasso:';
    $params = array(
      'cdtagl' => $values['cdtagl'],
      'cdasso' => $values['cdasso']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Astest objects
   */
  public static function getAssortmentQuantityForModel($cdartn, $cdtagl, $cdasso) {
    $query = "SELECT t.quanti
      FROM Go2B\Models\Astest t
      INNER JOIN Go2B\Models\Assmod a ON t.cdtagl = a.cdtagl AND t.cdasso = a.cdasso
      WHERE a.cdartn = :cdartn: AND a.cdtagl = :cdtagl: AND a.cdasso = :cdasso:";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdartn' => $cdartn, 'cdtagl' => $cdtagl, 'cdasso' => $cdasso));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Astest objects
   */
  public static function getAllAssortmentsForArticle($cdarti) {
    $query = "SELECT at.*
      FROM Go2B\Models\Astest at
      INNER JOIN Go2B\Models\Assmod am ON at.cdasso = am.cdasso
      INNER JOIN Go2B\Models\Tipolo tp ON am.cdartn = tp.cdartn AND am.cdtagl = tp.cdtagl
      INNER JOIN Go2B\Models\Anaart aa ON tp.cdartn = aa.cdartn
      WHERE aa.cdarti = :cdarti: ";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdarti' => $cdarti));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Astest objects
   */
  public static function getAllAssortmentsForArticleWithAvailability($cdarti) {
    $query = "SELECT at.cdtagl, at.cdasso, COALESCE(dc.quanti, 0) AS quanti
      FROM Go2B\Models\Astest at
      INNER JOIN Go2B\Models\Assmod am ON at.cdasso = am.cdasso
      INNER JOIN Go2B\Models\Tipolo tp ON am.cdartn = tp.cdartn AND am.cdtagl = tp.cdtagl
      INNER JOIN Go2B\Models\Anaart aa ON tp.cdartn = aa.cdartn
      LEFT JOIN Go2B\Models\Dscorp dc ON dc.cdarti = aa.cdarti AND dc.cdasso = at.cdasso
      WHERE aa.cdarti = :cdarti: ";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdarti' => $cdarti));
  }
  //endregion
}
