<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Ascorp extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdtagl;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdasso;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $taglia;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $qtatgl;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('ascorp');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdtagl' => isset($rec->cdtagl) && (string)$rec->cdtagl !== '' ? (string)$rec->cdtagl : new RawValue('""'),
      'cdasso' => isset($rec->cdasso) && (string)$rec->cdasso !== '' ? (string)$rec->cdasso : new RawValue('""'),
      'taglia' => isset($rec->taglia) && (string)$rec->taglia !== '' ? (string)$rec->taglia : new RawValue('""'),
      'qtatgl' => isset($rec->qtatgl) && (string)$rec->qtatgl !== '' ? (string)$rec->qtatgl : 0
    );

    $query  = 'cdtagl = :cdtagl: AND cdasso = :cdasso: AND taglia = :taglia:';
    $params = array(
      'cdtagl' => $values['cdtagl'],
      'cdasso' => $values['cdasso'],
      'taglia' => $values['taglia']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Ascorp objects
   */
  public static function getAssortmentDetail($cdasso, $cdtagl) {
    $query = 'SELECT ac.taglia, ac.qtatgl
      FROM Go2B\Models\Ascorp ac
      WHERE ac.cdtagl = :cdtagl: AND ac.cdasso = :cdasso:
      ORDER BY ac.taglia ';
    $params = array('cdtagl' => $cdtagl, 'cdasso' => $cdasso);
    return DI::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }
  //endregion
}
