<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Mvc\Model;

class ApiClient extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Identity
   * @Column(type="integer", length=11, nullable=false)
   */
  public $id;

  /**
   *
   * @var string
   * @Column(type="string", length=50, nullable=false)
   */
  public $name;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=false)
   * $secret = \Phalcon\Security->hash($name . 'SNG')
   */
  public $secret;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=false)
   */
  public $redirectUrl;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('api_client');
  }
  //endregion
}
