<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Mvc\Model;
use League\OAuth2\Server\Entities\UserEntityInterface;

class ApiAppusr extends Model implements UserEntityInterface
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Identity
   * @Column(type="integer", length=11, nullable=false)
   */
  public $id;

  /**
   *
   * @var string
   * @Column(type="string", length=50, nullable=false)
   */
  public $username;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=false)
   */
  public $password;

  /**
   *
   * @var string
   * @Column(type="string", length=20, nullable=false)
   */
  public $license_number;

  /**
   *
   * @var string
   * @Column(type="string", length=20, nullable=false)
   */
  public $customer;

  /**
   *
   * @var string
   * @Column(type="string", length=100, nullable=false)
   */
  public $email;

  /**
   *
   * @var string
   * @Column(type="string", nullable=true)
   */
  public $created_at;

  /**
   *
   * @var string
   * @Column(type="string", nullable=true)
   */
  public $last_login;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=true)
   */
  public $ios_mobile_device_id;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=true)
   */
  public $device;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $status;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $inactive;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $license_type;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=true)
   */
  public $version_number;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $multi_access;

  /**
   *
   * @var string
   * @Column(type="string", nullable=true)
   */
  public $last_sync_img;

  /**
   *
   * @var string
   * @Column(type="string", length=512, nullable=true)
   */
  public $apn_device_token;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('api_appusr');
  }

  public function getIdentifier() {
    return $this->id;
  }
  //endregion
}
