<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Anazon extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=4, nullable=false)
   */
  public $cdzona;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dszona;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('anazon');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdzona' => isset($rec->cdzona) && (string)$rec->cdzona !== '' ? utf8_decode((string)$rec->cdzona) : new RawValue('""'),
      'dszona' => isset($rec->dszona) && (string)$rec->dszona !== '' ? utf8_decode((string)$rec->dszona) : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? utf8_decode((string)$rec->seqrap) : 0
    );

    $query  = 'cdzona = :cdzona:';
    $params = array(
      'cdzona' => $values['cdzona']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function emptyTable() {
    $query = "TRUNCATE anazon";
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
