<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Anaprov extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=4, nullable=false)
   */
  public $cdprov;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dsprov;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('anaprov');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdprov' => isset($rec->cdprov) && (string)$rec->cdprov !== '' ? (string)$rec->cdprov : new RawValue('""'),
      'dsprov' => isset($rec->dsprov) && (string)$rec->dsprov !== '' ? (string)$rec->dsprov : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0
    );

    $query  = 'cdprov = :cdprov:';
    $params = array(
      'cdprov' => $values['cdprov']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Ananaz objects
   */
  public static function getAllProvinces() {
    $query = "SELECT an.cdprov, an.dsprov
      FROM Go2B\Models\Anaprov an
      ORDER BY an.dsprov";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }
  //endregion
}
