<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Anaper extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdpers;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dspers;

  /**
   *
   * @var string
   * @Column(type="string", length=255 nullable=false)
   */
  public $compos;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=false)
   */
  public $flimag;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('anaper');
  }
  //endregion

  //region Sync functions
  /**
   * Save flawlessly record
   */
  public static function safelySave($anaper) {
    $anaper->save(array(
      'cdpers' => (string)$anaper->cdpers !== '' ? (string)$anaper->cdpers : new RawValue('""'),
      'dspers' => (string)$anaper->dspers !== '' ? (string)$anaper->dspers : new RawValue('""'),
      'compos' => (string)$anaper->compos !== '' ? (string)$anaper->compos : new RawValue('""'),
      'flimag' => (string)$anaper->flimag !== '' ? (string)$anaper->flimag : new RawValue('""')
    ));
  }

  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdpers' => isset($rec->cdpers) && (string)$rec->cdpers !== '' ? (string)$rec->cdpers : new RawValue('""'),
      'dspers' => isset($rec->dspers) && (string)$rec->dspers !== '' ? (string)$rec->dspers : new RawValue('""'),
      'compos' => isset($rec->compos) && (string)$rec->compos !== '' ? (string)$rec->compos : new RawValue('""'),
      'flimag' => isset($rec->flimag) && (string)$rec->flimag !== '' ? (string)$rec->flimag : new RawValue('""')
    );

    $query  = 'cdpers = :cdpers:';
    $params = array(
      'cdpers' => $values['cdpers']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Anaper objects
   */
  public static function getAllFabricsForCatalog($items) {
    $params = array('cdcata' => $items['cdcata']);

    // Section selected
    $whereSection = $items['section']['where'];
    if ($whereSection != '') {
      if (isset($items['section']['code'])) {
        $params['code'] = $items['section']['code'];
      } else {
        $params['code1'] = $items['section']['code1'];
        $params['code2'] = $items['section']['code2'];
      }
    }

    if ($items['idlang'] == 'IT') {
      $commercialDescription = "COALESCE(di.descri,de.descri,'') AS des_comm ";
    } else {
      $commercialDescription = "COALESCE(de.descri,di.descri,'') AS des_comm ";
    }

    // Filters (no price filter)
    $innerJoinFilters = in_array('TG', $items['filters']['contexts']) ? ' INNER JOIN Go2B\Models\Postgl pt ON pt.cdtagl = tp.cdtagl ' : '';
    $innerJoinFilters .= $items['filters']['joins'];
    $whereFilters     = $items['filters']['where'];

    $query = "SELECT ap.cdpers, ap.dspers, ap.compos, ap.flimag, $commercialDescription
      FROM Go2B\Models\Anaper ap
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdpers = ap.cdpers
      INNER JOIN Go2B\Models\Ctarti ca ON ca.cdarti = aa.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN Go2B\Models\Sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      LEFT JOIN Go2B\Models\Desart di ON di.tpinpu = 'AP' AND di.codice = aa.cdpers AND di.tpdesc = 'COMM' AND di.idlang = 'IT'
      LEFT JOIN Go2B\Models\Desart de ON de.tpinpu = 'AP' AND de.codice = aa.cdpers AND de.tpdesc = 'COMM' AND de.idlang = 'EN'
      $innerJoinFilters
      WHERE ca.cdcata = :cdcata:
      AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      $whereSection
      $whereFilters
      GROUP BY ap.cdpers
      ORDER BY ap.cdpers";

    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaper objects
   */
  public static function getAllFabricsForCatalogFromSearch($items) {
    $params = array('cdcata' => $items['cdcata'], 'search' => $items['search']);

    if ($items['idlang'] == 'IT') {
      $commercialDescription = "COALESCE(di.descri,de.descri,'') AS des_comm ";
    } else {
      $commercialDescription = "COALESCE(de.descri,di.descri,'') AS des_comm ";
    }

    $query = "SELECT ap.cdpers, ap.dspers, ap.compos, ap.flimag, $commercialDescription
      FROM Go2B\Models\Anaper ap
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdpers = ap.cdpers
      INNER JOIN Go2B\Models\Ctarti ca ON ca.cdarti = aa.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN Go2B\Models\Sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      LEFT JOIN Go2B\Models\Desart di ON di.tpinpu = 'AP' AND di.codice = aa.cdpers AND di.tpdesc = 'COMM' AND di.idlang = 'IT'
      LEFT JOIN Go2B\Models\Desart de ON de.tpinpu = 'AP' AND de.codice = aa.cdpers AND de.tpdesc = 'COMM' AND de.idlang = 'EN'
      WHERE ca.cdcata = :cdcata:
      AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      AND (ap.cdpers LIKE :search: OR ap.dspers LIKE :search:)
      GROUP BY ap.cdpers
      ORDER BY ap.cdpers";

    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaper objects
   */
  public static function getFabricsForLookFromModel($cdartn, $cdcata) {
    $query = "SELECT ap.cdpers
      FROM Go2B\Models\Anaper ap
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdpers = ap.cdpers
      INNER JOIN Go2B\Models\Ctarti ca ON ca.cdarti = aa.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      WHERE ca.cdcata = :cdcata: AND tp.cdartn = :cdartn:
      GROUP BY ap.cdpers
      ORDER BY ap.cdpers";

    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdartn' => $cdartn, 'cdcata' => $cdcata));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaper objects
   */
  public static function getAllFabrics() {
    $query = 'SELECT DISTINCT ap.cdpers, ap.dspers,
      COUNT(IF(aa.flbloc = 0, 1, NULL)) AS not_blocked,
      COUNT(IF(aa.flbloc = 1, 1, NULL)) AS blocked
      FROM Go2B\Models\Anaper ap
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdpers = ap.cdpers
      GROUP BY ap.cdpers';
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Anaper object
   */
  public static function getFullFabric($cdpers, $idlang = 'IT') {
    $params = array('cdpers' => $cdpers);

    if ($idlang == 'IT') {
      $commercialDescription = "COALESCE(di.descri,de.descri,'') AS des_comm ";
    } else {
      $commercialDescription = "COALESCE(de.descri,di.descri,'') AS des_comm ";
    }

    $query = "SELECT ap.cdpers, ap.dspers, ap.compos, ap.flimag, $commercialDescription
      FROM Go2B\Models\Anaper ap
      LEFT JOIN Go2B\Models\Desart di ON di.tpinpu = 'AP' AND di.codice = ap.cdpers AND di.tpdesc = 'COMM' AND di.idlang = 'IT'
      LEFT JOIN Go2B\Models\Desart de ON de.tpinpu = 'AP' AND de.codice = ap.cdpers AND de.tpdesc = 'COMM' AND de.idlang = 'EN'
      WHERE ap.cdpers = :cdpers: ";

    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    return count($result) > 0 ? $result[0] : null;
  }

  /**
   * Query:   SELECT
   * Return:  string
   */
  public static function getFabricImage($cdpers) {
    $query = "SELECT ap.flimag
      FROM Go2B\Models\Anaper ap
      WHERE ap.cdpers = :cdpers:";
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdpers' => $cdpers));
    return count($result) > 0 ? $result[0]->flimag : '';
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateFabricImage($cdpers, $flimag) {
    $params = array(
      'cdpers' => $cdpers,
      'flimag' => $flimag != '' ? $flimag : ''
    );

    $query = "UPDATE anaper ap
      SET ap.flimag = :flimag
      WHERE ap.cdpers = :cdpers";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateImage($cdpers, $dummyCode, $flimag) {
    $params = array('cdpers' => $cdpers, 'flimag' => $flimag);
    $query = "UPDATE anaper a
      SET a.flimag = :flimag
      WHERE a.cdpers = :cdpers";
    Di::getDefault()->get('db')->query($query, $params);
  }
  //endregion
}
